/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateType;
import org.openmetadata.client.model.CustomProperty;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.Type;
import org.openmetadata.client.model.TypeList;

public interface MetadataApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/metadata/types/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void addProperty(@Param(value="id") UUID var1, CustomProperty var2);

    @RequestLine(value="PUT /v1/metadata/types/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> addPropertyWithHttpInfo(@Param(value="id") UUID var1, CustomProperty var2);

    @RequestLine(value="PUT /v1/metadata/types")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Type createOrUpdate(CreateType var1);

    @RequestLine(value="PUT /v1/metadata/types")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Type> createOrUpdateWithHttpInfo(CreateType var1);

    @RequestLine(value="POST /v1/metadata/types")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Type createType(CreateType var1);

    @RequestLine(value="POST /v1/metadata/types")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Type> createTypeWithHttpInfo(CreateType var1);

    @RequestLine(value="DELETE /v1/metadata/types/{id}")
    @Headers(value={"Accept: application/json"})
    public void deleteType(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/metadata/types/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTypeWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/metadata/types/name/{name}")
    @Headers(value={"Accept: application/json"})
    public void deleteTypeByName(@Param(value="name") String var1);

    @RequestLine(value="DELETE /v1/metadata/types/name/{name}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTypeByNameWithHttpInfo(@Param(value="name") String var1);

    @RequestLine(value="GET /v1/metadata/types/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Type getSpecificTypeVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/metadata/types/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Type> getSpecificTypeVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/metadata/types/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Type getTypeByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/metadata/types/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Type> getTypeByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/metadata/types/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Type getTypeByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetTypeByIDQueryParams var2);

    @RequestLine(value="GET /v1/metadata/types/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Type> getTypeByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetTypeByIDQueryParams var2);

    @RequestLine(value="GET /v1/metadata/types/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Type getTypeByName(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/metadata/types/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Type> getTypeByNameWithHttpInfo(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/metadata/types/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Type getTypeByName(@Param(value="name") String var1, @QueryMap(encoded=true) GetTypeByNameQueryParams var2);

    @RequestLine(value="GET /v1/metadata/types/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Type> getTypeByNameWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) GetTypeByNameQueryParams var2);

    @RequestLine(value="GET /v1/metadata/types/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTypeVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/metadata/types/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllTypeVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/metadata/types?category={category}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public TypeList listTypes(@Param(value="category") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4);

    @RequestLine(value="GET /v1/metadata/types?category={category}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TypeList> listTypesWithHttpInfo(@Param(value="category") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4);

    @RequestLine(value="GET /v1/metadata/types?category={category}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public TypeList listTypes(@QueryMap(encoded=true) ListTypesQueryParams var1);

    @RequestLine(value="GET /v1/metadata/types?category={category}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TypeList> listTypesWithHttpInfo(@QueryMap(encoded=true) ListTypesQueryParams var1);

    @RequestLine(value="PATCH /v1/metadata/types/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchType(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/metadata/types/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTypeWithHttpInfo(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/metadata/types/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchType1(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/metadata/types/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchType1WithHttpInfo(@Param(value="id") UUID var1, Object var2);

    public static class ListTypesQueryParams
    extends HashMap<String, Object> {
        public ListTypesQueryParams category(String value) {
            this.put("category", EncodingUtils.encode(value));
            return this;
        }

        public ListTypesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTypesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTypesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTypeByNameQueryParams
    extends HashMap<String, Object> {
        public GetTypeByNameQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTypeByNameQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTypeByIDQueryParams
    extends HashMap<String, Object> {
        public GetTypeByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTypeByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }
}

