/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateSearchService;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.SearchService;
import org.openmetadata.client.model.SearchServiceList;
import org.openmetadata.client.model.TestConnectionResult;

public interface SearchServicesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/searchServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SearchService addTestConnectionResult7(@Param(value="id") UUID var1, TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/searchServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SearchService> addTestConnectionResult7WithHttpInfo(@Param(value="id") UUID var1, TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/searchServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SearchService createOrUpdateSearchService(CreateSearchService var1);

    @RequestLine(value="PUT /v1/services/searchServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SearchService> createOrUpdateSearchServiceWithHttpInfo(CreateSearchService var1);

    @RequestLine(value="POST /v1/services/searchServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SearchService createSearchService(CreateSearchService var1);

    @RequestLine(value="POST /v1/services/searchServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SearchService> createSearchServiceWithHttpInfo(CreateSearchService var1);

    @RequestLine(value="DELETE /v1/services/searchServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchService(@Param(value="id") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/searchServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchServiceWithHttpInfo(@Param(value="id") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/searchServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchService(@Param(value="id") String var1, @QueryMap(encoded=true) DeleteSearchServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/searchServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchServiceWithHttpInfo(@Param(value="id") String var1, @QueryMap(encoded=true) DeleteSearchServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/searchServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchServiceByFQN(@Param(value="fqn") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/searchServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchServiceByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/searchServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteSearchServiceByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteSearchServiceByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/services/searchServices/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteSearchServiceByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteSearchServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/searchServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchService getSearchServiceByFQN(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/searchServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchService> getSearchServiceByFQNWithHttpInfo(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/searchServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchService getSearchServiceByFQN(@Param(value="name") String var1, @QueryMap(encoded=true) GetSearchServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/searchServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchService> getSearchServiceByFQNWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) GetSearchServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/searchServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchService getSearchServiceByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/searchServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchService> getSearchServiceByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/searchServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchService getSearchServiceByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetSearchServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/searchServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchService> getSearchServiceByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetSearchServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/searchServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public SearchService getSpecificSearchServiceVersion(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/services/searchServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchService> getSpecificSearchServiceVersionWithHttpInfo(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/services/searchServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllSearchServiceVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/services/searchServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllSearchServiceVersionWithHttpInfo(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/services/searchServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchServiceList listSearchServices(@Param(value="fields") String var1, @Param(value="domain") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/services/searchServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchServiceList> listSearchServicesWithHttpInfo(@Param(value="fields") String var1, @Param(value="domain") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/services/searchServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public SearchServiceList listSearchServices(@QueryMap(encoded=true) ListSearchServicesQueryParams var1);

    @RequestLine(value="GET /v1/services/searchServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchServiceList> listSearchServicesWithHttpInfo(@QueryMap(encoded=true) ListSearchServicesQueryParams var1);

    @RequestLine(value="PATCH /v1/services/searchServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchSearchService(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/services/searchServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchSearchServiceWithHttpInfo(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/services/searchServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchSearchService1(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/services/searchServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchSearchService1WithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/services/searchServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SearchService restore29(RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/searchServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SearchService> restore29WithHttpInfo(RestoreEntity var1);

    public static class ListSearchServicesQueryParams
    extends HashMap<String, Object> {
        public ListSearchServicesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchServicesQueryParams domain(String value) {
            this.put("domain", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchServicesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchServicesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchServicesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListSearchServicesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetSearchServiceByIDQueryParams
    extends HashMap<String, Object> {
        public GetSearchServiceByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetSearchServiceByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetSearchServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public GetSearchServiceByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetSearchServiceByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteSearchServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteSearchServiceByFQNQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteSearchServiceByFQNQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteSearchServiceQueryParams
    extends HashMap<String, Object> {
        public DeleteSearchServiceQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteSearchServiceQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

