/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateLogicalTestCases;
import org.openmetadata.client.model.CreateTestCase;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TableData;
import org.openmetadata.client.model.TestCase;
import org.openmetadata.client.model.TestCaseList;
import org.openmetadata.client.model.TestCaseResult;
import org.openmetadata.client.model.TestCaseResultList;
import org.openmetadata.client.model.TestSuite;

public interface TestCasesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/dataQuality/testCases/{id}/failedRowsSample?validate={validate}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestCase addFailedRowsSample(@Param(value="id") UUID var1, @Param(value="validate") Boolean var2, TableData var3);

    @RequestLine(value="PUT /v1/dataQuality/testCases/{id}/failedRowsSample?validate={validate}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestCase> addFailedRowsSampleWithHttpInfo(@Param(value="id") UUID var1, @Param(value="validate") Boolean var2, TableData var3);

    @RequestLine(value="PUT /v1/dataQuality/testCases/{id}/failedRowsSample?validate={validate}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestCase addFailedRowsSample(@Param(value="id") UUID var1, TableData var2, @QueryMap(encoded=true) AddFailedRowsSampleQueryParams var3);

    @RequestLine(value="PUT /v1/dataQuality/testCases/{id}/failedRowsSample?validate={validate}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestCase> addFailedRowsSampleWithHttpInfo(@Param(value="id") UUID var1, TableData var2, @QueryMap(encoded=true) AddFailedRowsSampleQueryParams var3);

    @RequestLine(value="PUT /v1/dataQuality/testCases/{id}/inspectionQuery")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestCase addInspectionQuery(@Param(value="id") UUID var1, String var2);

    @RequestLine(value="PUT /v1/dataQuality/testCases/{id}/inspectionQuery")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestCase> addInspectionQueryWithHttpInfo(@Param(value="id") UUID var1, String var2);

    @RequestLine(value="PUT /v1/dataQuality/testCases/{fqn}/testCaseResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestCase addTestCaseResult(@Param(value="fqn") String var1, TestCaseResult var2);

    @RequestLine(value="PUT /v1/dataQuality/testCases/{fqn}/testCaseResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestCase> addTestCaseResultWithHttpInfo(@Param(value="fqn") String var1, TestCaseResult var2);

    @RequestLine(value="PUT /v1/dataQuality/testCases/logicalTestCases")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestSuite addTestCasesToLogicalTestSuite(CreateLogicalTestCases var1);

    @RequestLine(value="PUT /v1/dataQuality/testCases/logicalTestCases")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestSuite> addTestCasesToLogicalTestSuiteWithHttpInfo(CreateLogicalTestCases var1);

    @RequestLine(value="PUT /v1/dataQuality/testCases")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestCase createOrUpdateTest(CreateTestCase var1);

    @RequestLine(value="PUT /v1/dataQuality/testCases")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestCase> createOrUpdateTestWithHttpInfo(CreateTestCase var1);

    @RequestLine(value="POST /v1/dataQuality/testCases")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestCase createTestCase(CreateTestCase var1);

    @RequestLine(value="POST /v1/dataQuality/testCases")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestCase> createTestCaseWithHttpInfo(CreateTestCase var1);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/{id}/failedRowsSample")
    @Headers(value={"Accept: application/json"})
    public void deleteFailedRowsSample(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/{id}/failedRowsSample")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteFailedRowsSampleWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/logicalTestCases/{testSuiteId}/{id}")
    @Headers(value={"Accept: application/json"})
    public void deleteLogicalTestCase(@Param(value="testSuiteId") UUID var1, @Param(value="id") UUID var2);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/logicalTestCases/{testSuiteId}/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLogicalTestCaseWithHttpInfo(@Param(value="testSuiteId") UUID var1, @Param(value="id") UUID var2);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestCase(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestCaseWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestCase(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteTestCaseQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestCaseWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteTestCaseQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestCaseByName(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestCaseByNameWithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestCaseByName(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteTestCaseByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestCaseByNameWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteTestCaseByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/{fqn}/testCaseResult/{timestamp}")
    @Headers(value={"Accept: application/json"})
    public TestCase deleteTestCaseResult(@Param(value="fqn") String var1, @Param(value="timestamp") Long var2);

    @RequestLine(value="DELETE /v1/dataQuality/testCases/{fqn}/testCaseResult/{timestamp}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCase> deleteTestCaseResultWithHttpInfo(@Param(value="fqn") String var1, @Param(value="timestamp") Long var2);

    @RequestLine(value="GET /v1/dataQuality/testCases/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestCase get3(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testCases/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCase> get3WithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testCases/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestCase get3(@Param(value="id") UUID var1, @QueryMap(encoded=true) Get3QueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testCases/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCase> get3WithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Get3QueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testCases/{id}/failedRowsSample")
    @Headers(value={"Accept: application/json"})
    public TableData getFailedRowsSample(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testCases/{id}/failedRowsSample")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TableData> getFailedRowsSampleWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testCases/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public TestCase getSpecificTestCaseVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/dataQuality/testCases/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCase> getSpecificTestCaseVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/dataQuality/testCases/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestCase getTestCaseByName(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testCases/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCase> getTestCaseByNameWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testCases/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestCase getTestCaseByName(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetTestCaseByNameQueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testCases/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCase> getTestCaseByNameWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetTestCaseByNameQueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testCases/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTestCaseVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testCases/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllTestCaseVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testCases/{fqn}/testCaseResult?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public TestCaseResultList listTestCaseResults(@Param(value="fqn") String var1, @Param(value="startTs") BigDecimal var2, @Param(value="endTs") BigDecimal var3);

    @RequestLine(value="GET /v1/dataQuality/testCases/{fqn}/testCaseResult?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCaseResultList> listTestCaseResultsWithHttpInfo(@Param(value="fqn") String var1, @Param(value="startTs") BigDecimal var2, @Param(value="endTs") BigDecimal var3);

    @RequestLine(value="GET /v1/dataQuality/testCases/{fqn}/testCaseResult?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public TestCaseResultList listTestCaseResults(@Param(value="fqn") String var1, @QueryMap(encoded=true) ListTestCaseResultsQueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testCases/{fqn}/testCaseResult?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCaseResultList> listTestCaseResultsWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) ListTestCaseResultsQueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testCases?fields={fields}&limit={limit}&before={before}&after={after}&entityLink={entityLink}&testSuiteId={testSuiteId}&includeAllTests={includeAllTests}&include={include}&testCaseStatus={testCaseStatus}&testCaseType={testCaseType}")
    @Headers(value={"Accept: application/json"})
    public TestCaseList listTestCases(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="entityLink") String var5, @Param(value="testSuiteId") String var6, @Param(value="includeAllTests") Boolean var7, @Param(value="include") String var8, @Param(value="testCaseStatus") String var9, @Param(value="testCaseType") String var10);

    @RequestLine(value="GET /v1/dataQuality/testCases?fields={fields}&limit={limit}&before={before}&after={after}&entityLink={entityLink}&testSuiteId={testSuiteId}&includeAllTests={includeAllTests}&include={include}&testCaseStatus={testCaseStatus}&testCaseType={testCaseType}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCaseList> listTestCasesWithHttpInfo(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="entityLink") String var5, @Param(value="testSuiteId") String var6, @Param(value="includeAllTests") Boolean var7, @Param(value="include") String var8, @Param(value="testCaseStatus") String var9, @Param(value="testCaseType") String var10);

    @RequestLine(value="GET /v1/dataQuality/testCases?fields={fields}&limit={limit}&before={before}&after={after}&entityLink={entityLink}&testSuiteId={testSuiteId}&includeAllTests={includeAllTests}&include={include}&testCaseStatus={testCaseStatus}&testCaseType={testCaseType}")
    @Headers(value={"Accept: application/json"})
    public TestCaseList listTestCases(@QueryMap(encoded=true) ListTestCasesQueryParams var1);

    @RequestLine(value="GET /v1/dataQuality/testCases?fields={fields}&limit={limit}&before={before}&after={after}&entityLink={entityLink}&testSuiteId={testSuiteId}&includeAllTests={includeAllTests}&include={include}&testCaseStatus={testCaseStatus}&testCaseType={testCaseType}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCaseList> listTestCasesWithHttpInfo(@QueryMap(encoded=true) ListTestCasesQueryParams var1);

    @RequestLine(value="GET /v1/dataQuality/testCases/search/list?fields={fields}&limit={limit}&offset={offset}&entityLink={entityLink}&testSuiteId={testSuiteId}&includeAllTests={includeAllTests}&include={include}&testCaseStatus={testCaseStatus}&testCaseType={testCaseType}&testPlatforms={testPlatforms}&dataQualityDimension={dataQualityDimension}&startTimestamp={startTimestamp}&endTimestamp={endTimestamp}&sortField={sortField}&sortNestedPath={sortNestedPath}&sortNestedMode={sortNestedMode}&sortType={sortType}&includeFields={includeFields}&domain={domain}&owner={owner}&tags={tags}&tier={tier}&serviceName={serviceName}&q={q}")
    @Headers(value={"Accept: application/json"})
    public TestCaseList listTestCasesFromSearchService(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="offset") String var3, @Param(value="entityLink") String var4, @Param(value="testSuiteId") String var5, @Param(value="includeAllTests") Boolean var6, @Param(value="include") String var7, @Param(value="testCaseStatus") String var8, @Param(value="testCaseType") String var9, @Param(value="testPlatforms") String var10, @Param(value="dataQualityDimension") String var11, @Param(value="startTimestamp") Long var12, @Param(value="endTimestamp") Long var13, @Param(value="sortField") String var14, @Param(value="sortNestedPath") String var15, @Param(value="sortNestedMode") String var16, @Param(value="sortType") String var17, @Param(value="includeFields") String var18, @Param(value="domain") String var19, @Param(value="owner") String var20, @Param(value="tags") String var21, @Param(value="tier") String var22, @Param(value="serviceName") String var23, @Param(value="q") String var24);

    @RequestLine(value="GET /v1/dataQuality/testCases/search/list?fields={fields}&limit={limit}&offset={offset}&entityLink={entityLink}&testSuiteId={testSuiteId}&includeAllTests={includeAllTests}&include={include}&testCaseStatus={testCaseStatus}&testCaseType={testCaseType}&testPlatforms={testPlatforms}&dataQualityDimension={dataQualityDimension}&startTimestamp={startTimestamp}&endTimestamp={endTimestamp}&sortField={sortField}&sortNestedPath={sortNestedPath}&sortNestedMode={sortNestedMode}&sortType={sortType}&includeFields={includeFields}&domain={domain}&owner={owner}&tags={tags}&tier={tier}&serviceName={serviceName}&q={q}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCaseList> listTestCasesFromSearchServiceWithHttpInfo(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="offset") String var3, @Param(value="entityLink") String var4, @Param(value="testSuiteId") String var5, @Param(value="includeAllTests") Boolean var6, @Param(value="include") String var7, @Param(value="testCaseStatus") String var8, @Param(value="testCaseType") String var9, @Param(value="testPlatforms") String var10, @Param(value="dataQualityDimension") String var11, @Param(value="startTimestamp") Long var12, @Param(value="endTimestamp") Long var13, @Param(value="sortField") String var14, @Param(value="sortNestedPath") String var15, @Param(value="sortNestedMode") String var16, @Param(value="sortType") String var17, @Param(value="includeFields") String var18, @Param(value="domain") String var19, @Param(value="owner") String var20, @Param(value="tags") String var21, @Param(value="tier") String var22, @Param(value="serviceName") String var23, @Param(value="q") String var24);

    @RequestLine(value="GET /v1/dataQuality/testCases/search/list?fields={fields}&limit={limit}&offset={offset}&entityLink={entityLink}&testSuiteId={testSuiteId}&includeAllTests={includeAllTests}&include={include}&testCaseStatus={testCaseStatus}&testCaseType={testCaseType}&testPlatforms={testPlatforms}&dataQualityDimension={dataQualityDimension}&startTimestamp={startTimestamp}&endTimestamp={endTimestamp}&sortField={sortField}&sortNestedPath={sortNestedPath}&sortNestedMode={sortNestedMode}&sortType={sortType}&includeFields={includeFields}&domain={domain}&owner={owner}&tags={tags}&tier={tier}&serviceName={serviceName}&q={q}")
    @Headers(value={"Accept: application/json"})
    public TestCaseList listTestCasesFromSearchService(@QueryMap(encoded=true) ListTestCasesFromSearchServiceQueryParams var1);

    @RequestLine(value="GET /v1/dataQuality/testCases/search/list?fields={fields}&limit={limit}&offset={offset}&entityLink={entityLink}&testSuiteId={testSuiteId}&includeAllTests={includeAllTests}&include={include}&testCaseStatus={testCaseStatus}&testCaseType={testCaseType}&testPlatforms={testPlatforms}&dataQualityDimension={dataQualityDimension}&startTimestamp={startTimestamp}&endTimestamp={endTimestamp}&sortField={sortField}&sortNestedPath={sortNestedPath}&sortNestedMode={sortNestedMode}&sortType={sortType}&includeFields={includeFields}&domain={domain}&owner={owner}&tags={tags}&tier={tier}&serviceName={serviceName}&q={q}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestCaseList> listTestCasesFromSearchServiceWithHttpInfo(@QueryMap(encoded=true) ListTestCasesFromSearchServiceQueryParams var1);

    @RequestLine(value="PATCH /v1/dataQuality/testCases/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTest(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/dataQuality/testCases/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTestWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/dataQuality/testCases/{fqn}/testCaseResult/{timestamp}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTestCaseResult(@Param(value="fqn") String var1, @Param(value="timestamp") Long var2, Object var3);

    @RequestLine(value="PATCH /v1/dataQuality/testCases/{fqn}/testCaseResult/{timestamp}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTestCaseResultWithHttpInfo(@Param(value="fqn") String var1, @Param(value="timestamp") Long var2, Object var3);

    @RequestLine(value="PUT /v1/dataQuality/testCases/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestCase restore12(RestoreEntity var1);

    @RequestLine(value="PUT /v1/dataQuality/testCases/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestCase> restore12WithHttpInfo(RestoreEntity var1);

    public static class ListTestCasesFromSearchServiceQueryParams
    extends HashMap<String, Object> {
        public ListTestCasesFromSearchServiceQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams offset(String value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams entityLink(String value) {
            this.put("entityLink", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams testSuiteId(String value) {
            this.put("testSuiteId", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams includeAllTests(Boolean value) {
            this.put("includeAllTests", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams testCaseStatus(String value) {
            this.put("testCaseStatus", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams testCaseType(String value) {
            this.put("testCaseType", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams testPlatforms(String value) {
            this.put("testPlatforms", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams dataQualityDimension(String value) {
            this.put("dataQualityDimension", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams startTimestamp(Long value) {
            this.put("startTimestamp", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams endTimestamp(Long value) {
            this.put("endTimestamp", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams sortField(String value) {
            this.put("sortField", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams sortNestedPath(String value) {
            this.put("sortNestedPath", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams sortNestedMode(String value) {
            this.put("sortNestedMode", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams sortType(String value) {
            this.put("sortType", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams includeFields(String value) {
            this.put("includeFields", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams domain(String value) {
            this.put("domain", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams owner(String value) {
            this.put("owner", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams tags(String value) {
            this.put("tags", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams tier(String value) {
            this.put("tier", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams serviceName(String value) {
            this.put("serviceName", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesFromSearchServiceQueryParams q(String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListTestCasesQueryParams
    extends HashMap<String, Object> {
        public ListTestCasesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesQueryParams entityLink(String value) {
            this.put("entityLink", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesQueryParams testSuiteId(String value) {
            this.put("testSuiteId", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesQueryParams includeAllTests(Boolean value) {
            this.put("includeAllTests", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesQueryParams testCaseStatus(String value) {
            this.put("testCaseStatus", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCasesQueryParams testCaseType(String value) {
            this.put("testCaseType", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListTestCaseResultsQueryParams
    extends HashMap<String, Object> {
        public ListTestCaseResultsQueryParams startTs(BigDecimal value) {
            this.put("startTs", EncodingUtils.encode(value));
            return this;
        }

        public ListTestCaseResultsQueryParams endTs(BigDecimal value) {
            this.put("endTs", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTestCaseByNameQueryParams
    extends HashMap<String, Object> {
        public GetTestCaseByNameQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTestCaseByNameQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class Get3QueryParams
    extends HashMap<String, Object> {
        public Get3QueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public Get3QueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTestCaseByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteTestCaseByNameQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTestCaseByNameQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTestCaseQueryParams
    extends HashMap<String, Object> {
        public DeleteTestCaseQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTestCaseQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class AddFailedRowsSampleQueryParams
    extends HashMap<String, Object> {
        public AddFailedRowsSampleQueryParams validate(Boolean value) {
            this.put("validate", EncodingUtils.encode(value));
            return this;
        }
    }
}

