/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CreateTestSuite;
import org.openmetadata.client.model.DataQualityReport;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestSuite;
import org.openmetadata.client.model.TestSuiteList;
import org.openmetadata.client.model.TestSummary;

public interface TestSuitesApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/dataQuality/testSuites/executable")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestSuite createExecutableTestSuite(CreateTestSuite var1);

    @RequestLine(value="POST /v1/dataQuality/testSuites/executable")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestSuite> createExecutableTestSuiteWithHttpInfo(CreateTestSuite var1);

    @RequestLine(value="POST /v1/dataQuality/testSuites")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestSuite createLogicalTestSuite(CreateTestSuite var1);

    @RequestLine(value="POST /v1/dataQuality/testSuites")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestSuite> createLogicalTestSuiteWithHttpInfo(CreateTestSuite var1);

    @RequestLine(value="PUT /v1/dataQuality/testSuites/executable")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestSuite createOrUpdateExecutableTestSuite(CreateTestSuite var1);

    @RequestLine(value="PUT /v1/dataQuality/testSuites/executable")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestSuite> createOrUpdateExecutableTestSuiteWithHttpInfo(CreateTestSuite var1);

    @RequestLine(value="PUT /v1/dataQuality/testSuites")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestSuite createOrUpdateLogicalTestSuite(CreateTestSuite var1);

    @RequestLine(value="PUT /v1/dataQuality/testSuites")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestSuite> createOrUpdateLogicalTestSuiteWithHttpInfo(CreateTestSuite var1);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteLogicalTestSuite(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLogicalTestSuiteWithHttpInfo(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteLogicalTestSuite(@Param(value="name") String var1, @QueryMap(encoded=true) DeleteLogicalTestSuiteQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/name/{name}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLogicalTestSuiteWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) DeleteLogicalTestSuiteQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteLogicalTestSuite1(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLogicalTestSuite1WithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteLogicalTestSuite1(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteLogicalTestSuite1QueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLogicalTestSuite1WithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteLogicalTestSuite1QueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestSuite(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestSuiteWithHttpInfo(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestSuite(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteTestSuiteQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestSuiteWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteTestSuiteQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestSuiteByName(@Param(value="name") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestSuiteByNameWithHttpInfo(@Param(value="name") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteTestSuiteByName(@Param(value="name") String var1, @QueryMap(encoded=true) DeleteTestSuiteByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/dataQuality/testSuites/executable/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteTestSuiteByNameWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) DeleteTestSuiteByNameQueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestSuite get5(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuite> get5WithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestSuite get5(@Param(value="id") UUID var1, @QueryMap(encoded=true) Get5QueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuite> get5WithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) Get5QueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/dataQualityReport?q={q}&aggregationQuery={aggregationQuery}&index={index}")
    @Headers(value={"Accept: application/json"})
    public DataQualityReport getDataQualityReport(@Param(value="q") String var1, @Param(value="aggregationQuery") String var2, @Param(value="index") String var3);

    @RequestLine(value="GET /v1/dataQuality/testSuites/dataQualityReport?q={q}&aggregationQuery={aggregationQuery}&index={index}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataQualityReport> getDataQualityReportWithHttpInfo(@Param(value="q") String var1, @Param(value="aggregationQuery") String var2, @Param(value="index") String var3);

    @RequestLine(value="GET /v1/dataQuality/testSuites/dataQualityReport?q={q}&aggregationQuery={aggregationQuery}&index={index}")
    @Headers(value={"Accept: application/json"})
    public DataQualityReport getDataQualityReport(@QueryMap(encoded=true) GetDataQualityReportQueryParams var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/dataQualityReport?q={q}&aggregationQuery={aggregationQuery}&index={index}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataQualityReport> getDataQualityReportWithHttpInfo(@QueryMap(encoded=true) GetDataQualityReportQueryParams var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/executionSummary?testSuiteId={testSuiteId}")
    @Headers(value={"Accept: application/json"})
    public TestSummary getExecutionSummaryOfTestSuites(@Param(value="testSuiteId") UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/executionSummary?testSuiteId={testSuiteId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSummary> getExecutionSummaryOfTestSuitesWithHttpInfo(@Param(value="testSuiteId") UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/executionSummary?testSuiteId={testSuiteId}")
    @Headers(value={"Accept: application/json"})
    public TestSummary getExecutionSummaryOfTestSuites(@QueryMap(encoded=true) GetExecutionSummaryOfTestSuitesQueryParams var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/executionSummary?testSuiteId={testSuiteId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSummary> getExecutionSummaryOfTestSuitesWithHttpInfo(@QueryMap(encoded=true) GetExecutionSummaryOfTestSuitesQueryParams var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public TestSuite getSpecificTestSuiteVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuite> getSpecificTestSuiteVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestSuite getTestSuiteByName(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testSuites/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuite> getTestSuiteByNameWithHttpInfo(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dataQuality/testSuites/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestSuite getTestSuiteByName(@Param(value="name") String var1, @QueryMap(encoded=true) GetTestSuiteByNameQueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuite> getTestSuiteByNameWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) GetTestSuiteByNameQueryParams var2);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTestSuiteVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllTestSuiteVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/search/list?fields={fields}&limit={limit}&offset={offset}&testSuiteType={testSuiteType}&includeEmptyTestSuites={includeEmptyTestSuites}&fullyQualifiedName={fullyQualifiedName}&owner={owner}&include={include}&sortField={sortField}&sortNestedPath={sortNestedPath}&sortNestedMode={sortNestedMode}&sortType={sortType}&q={q}")
    @Headers(value={"Accept: application/json"})
    public TestSuiteList listTestSuiteFromSearchService(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="offset") String var3, @Param(value="testSuiteType") String var4, @Param(value="includeEmptyTestSuites") Boolean var5, @Param(value="fullyQualifiedName") String var6, @Param(value="owner") String var7, @Param(value="include") String var8, @Param(value="sortField") String var9, @Param(value="sortNestedPath") String var10, @Param(value="sortNestedMode") String var11, @Param(value="sortType") String var12, @Param(value="q") String var13);

    @RequestLine(value="GET /v1/dataQuality/testSuites/search/list?fields={fields}&limit={limit}&offset={offset}&testSuiteType={testSuiteType}&includeEmptyTestSuites={includeEmptyTestSuites}&fullyQualifiedName={fullyQualifiedName}&owner={owner}&include={include}&sortField={sortField}&sortNestedPath={sortNestedPath}&sortNestedMode={sortNestedMode}&sortType={sortType}&q={q}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuiteList> listTestSuiteFromSearchServiceWithHttpInfo(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="offset") String var3, @Param(value="testSuiteType") String var4, @Param(value="includeEmptyTestSuites") Boolean var5, @Param(value="fullyQualifiedName") String var6, @Param(value="owner") String var7, @Param(value="include") String var8, @Param(value="sortField") String var9, @Param(value="sortNestedPath") String var10, @Param(value="sortNestedMode") String var11, @Param(value="sortType") String var12, @Param(value="q") String var13);

    @RequestLine(value="GET /v1/dataQuality/testSuites/search/list?fields={fields}&limit={limit}&offset={offset}&testSuiteType={testSuiteType}&includeEmptyTestSuites={includeEmptyTestSuites}&fullyQualifiedName={fullyQualifiedName}&owner={owner}&include={include}&sortField={sortField}&sortNestedPath={sortNestedPath}&sortNestedMode={sortNestedMode}&sortType={sortType}&q={q}")
    @Headers(value={"Accept: application/json"})
    public TestSuiteList listTestSuiteFromSearchService(@QueryMap(encoded=true) ListTestSuiteFromSearchServiceQueryParams var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites/search/list?fields={fields}&limit={limit}&offset={offset}&testSuiteType={testSuiteType}&includeEmptyTestSuites={includeEmptyTestSuites}&fullyQualifiedName={fullyQualifiedName}&owner={owner}&include={include}&sortField={sortField}&sortNestedPath={sortNestedPath}&sortNestedMode={sortNestedMode}&sortType={sortType}&q={q}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuiteList> listTestSuiteFromSearchServiceWithHttpInfo(@QueryMap(encoded=true) ListTestSuiteFromSearchServiceQueryParams var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites?fields={fields}&limit={limit}&testSuiteType={testSuiteType}&includeEmptyTestSuites={includeEmptyTestSuites}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestSuiteList listTestSuites(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="testSuiteType") String var3, @Param(value="includeEmptyTestSuites") Boolean var4, @Param(value="before") String var5, @Param(value="after") String var6, @Param(value="include") String var7);

    @RequestLine(value="GET /v1/dataQuality/testSuites?fields={fields}&limit={limit}&testSuiteType={testSuiteType}&includeEmptyTestSuites={includeEmptyTestSuites}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuiteList> listTestSuitesWithHttpInfo(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="testSuiteType") String var3, @Param(value="includeEmptyTestSuites") Boolean var4, @Param(value="before") String var5, @Param(value="after") String var6, @Param(value="include") String var7);

    @RequestLine(value="GET /v1/dataQuality/testSuites?fields={fields}&limit={limit}&testSuiteType={testSuiteType}&includeEmptyTestSuites={includeEmptyTestSuites}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TestSuiteList listTestSuites(@QueryMap(encoded=true) ListTestSuitesQueryParams var1);

    @RequestLine(value="GET /v1/dataQuality/testSuites?fields={fields}&limit={limit}&testSuiteType={testSuiteType}&includeEmptyTestSuites={includeEmptyTestSuites}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TestSuiteList> listTestSuitesWithHttpInfo(@QueryMap(encoded=true) ListTestSuitesQueryParams var1);

    @RequestLine(value="PATCH /v1/dataQuality/testSuites/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTestSuite(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/dataQuality/testSuites/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchTestSuiteWithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/dataQuality/testSuites/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TestSuite restore14(RestoreEntity var1);

    @RequestLine(value="PUT /v1/dataQuality/testSuites/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<TestSuite> restore14WithHttpInfo(RestoreEntity var1);

    public static class ListTestSuitesQueryParams
    extends HashMap<String, Object> {
        public ListTestSuitesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuitesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuitesQueryParams testSuiteType(String value) {
            this.put("testSuiteType", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuitesQueryParams includeEmptyTestSuites(Boolean value) {
            this.put("includeEmptyTestSuites", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuitesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuitesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuitesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListTestSuiteFromSearchServiceQueryParams
    extends HashMap<String, Object> {
        public ListTestSuiteFromSearchServiceQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams offset(String value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams testSuiteType(String value) {
            this.put("testSuiteType", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams includeEmptyTestSuites(Boolean value) {
            this.put("includeEmptyTestSuites", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams fullyQualifiedName(String value) {
            this.put("fullyQualifiedName", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams owner(String value) {
            this.put("owner", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams sortField(String value) {
            this.put("sortField", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams sortNestedPath(String value) {
            this.put("sortNestedPath", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams sortNestedMode(String value) {
            this.put("sortNestedMode", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams sortType(String value) {
            this.put("sortType", EncodingUtils.encode(value));
            return this;
        }

        public ListTestSuiteFromSearchServiceQueryParams q(String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTestSuiteByNameQueryParams
    extends HashMap<String, Object> {
        public GetTestSuiteByNameQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTestSuiteByNameQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetExecutionSummaryOfTestSuitesQueryParams
    extends HashMap<String, Object> {
        public GetExecutionSummaryOfTestSuitesQueryParams testSuiteId(UUID value) {
            this.put("testSuiteId", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDataQualityReportQueryParams
    extends HashMap<String, Object> {
        public GetDataQualityReportQueryParams q(String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }

        public GetDataQualityReportQueryParams aggregationQuery(String value) {
            this.put("aggregationQuery", EncodingUtils.encode(value));
            return this;
        }

        public GetDataQualityReportQueryParams index(String value) {
            this.put("index", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class Get5QueryParams
    extends HashMap<String, Object> {
        public Get5QueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public Get5QueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTestSuiteByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteTestSuiteByNameQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTestSuiteByNameQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTestSuiteQueryParams
    extends HashMap<String, Object> {
        public DeleteTestSuiteQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteTestSuiteQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteLogicalTestSuite1QueryParams
    extends HashMap<String, Object> {
        public DeleteLogicalTestSuite1QueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteLogicalTestSuiteQueryParams
    extends HashMap<String, Object> {
        public DeleteLogicalTestSuiteQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

