/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.DailyCount;
import org.openmetadata.client.model.EntityUsage;

public interface UsageApi
extends ApiClient.Api {
    @RequestLine(value="GET /v1/usage/{entity}/name/{fqn}?days={days}&date={date}")
    @Headers(value={"Accept: application/json"})
    public EntityUsage getEntityUsageByFQN(@Param(value="entity") String var1, @Param(value="fqn") String var2, @Param(value="days") Integer var3, @Param(value="date") String var4);

    @RequestLine(value="GET /v1/usage/{entity}/name/{fqn}?days={days}&date={date}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityUsage> getEntityUsageByFQNWithHttpInfo(@Param(value="entity") String var1, @Param(value="fqn") String var2, @Param(value="days") Integer var3, @Param(value="date") String var4);

    @RequestLine(value="GET /v1/usage/{entity}/name/{fqn}?days={days}&date={date}")
    @Headers(value={"Accept: application/json"})
    public EntityUsage getEntityUsageByFQN(@Param(value="entity") String var1, @Param(value="fqn") String var2, @QueryMap(encoded=true) GetEntityUsageByFQNQueryParams var3);

    @RequestLine(value="GET /v1/usage/{entity}/name/{fqn}?days={days}&date={date}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityUsage> getEntityUsageByFQNWithHttpInfo(@Param(value="entity") String var1, @Param(value="fqn") String var2, @QueryMap(encoded=true) GetEntityUsageByFQNQueryParams var3);

    @RequestLine(value="GET /v1/usage/{entity}/{id}?days={days}&date={date}")
    @Headers(value={"Accept: application/json"})
    public EntityUsage getEntityUsageByID(@Param(value="entity") String var1, @Param(value="id") String var2, @Param(value="days") Integer var3, @Param(value="date") String var4);

    @RequestLine(value="GET /v1/usage/{entity}/{id}?days={days}&date={date}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityUsage> getEntityUsageByIDWithHttpInfo(@Param(value="entity") String var1, @Param(value="id") String var2, @Param(value="days") Integer var3, @Param(value="date") String var4);

    @RequestLine(value="GET /v1/usage/{entity}/{id}?days={days}&date={date}")
    @Headers(value={"Accept: application/json"})
    public EntityUsage getEntityUsageByID(@Param(value="entity") String var1, @Param(value="id") String var2, @QueryMap(encoded=true) GetEntityUsageByIDQueryParams var3);

    @RequestLine(value="GET /v1/usage/{entity}/{id}?days={days}&date={date}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityUsage> getEntityUsageByIDWithHttpInfo(@Param(value="entity") String var1, @Param(value="id") String var2, @QueryMap(encoded=true) GetEntityUsageByIDQueryParams var3);

    @RequestLine(value="POST /v1/usage/{entity}/name/{fqn}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public EntityUsage reportEntityUsageWithFQN(@Param(value="entity") String var1, @Param(value="fqn") String var2, DailyCount var3);

    @RequestLine(value="POST /v1/usage/{entity}/name/{fqn}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<EntityUsage> reportEntityUsageWithFQNWithHttpInfo(@Param(value="entity") String var1, @Param(value="fqn") String var2, DailyCount var3);

    @RequestLine(value="PUT /v1/usage/{entity}/name/{fqn}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public EntityUsage reportEntityUsageWithFQN1(@Param(value="entity") String var1, @Param(value="fqn") String var2, DailyCount var3);

    @RequestLine(value="PUT /v1/usage/{entity}/name/{fqn}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<EntityUsage> reportEntityUsageWithFQN1WithHttpInfo(@Param(value="entity") String var1, @Param(value="fqn") String var2, DailyCount var3);

    @RequestLine(value="POST /v1/usage/{entity}/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public EntityUsage reportEntityUsageWithID(@Param(value="entity") String var1, @Param(value="id") String var2, DailyCount var3);

    @RequestLine(value="POST /v1/usage/{entity}/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<EntityUsage> reportEntityUsageWithIDWithHttpInfo(@Param(value="entity") String var1, @Param(value="id") String var2, DailyCount var3);

    @RequestLine(value="PUT /v1/usage/{entity}/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public EntityUsage reportEntityUsageWithID1(@Param(value="entity") String var1, @Param(value="id") String var2, DailyCount var3);

    @RequestLine(value="PUT /v1/usage/{entity}/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<EntityUsage> reportEntityUsageWithID1WithHttpInfo(@Param(value="entity") String var1, @Param(value="id") String var2, DailyCount var3);

    public static class GetEntityUsageByIDQueryParams
    extends HashMap<String, Object> {
        public GetEntityUsageByIDQueryParams days(Integer value) {
            this.put("days", EncodingUtils.encode(value));
            return this;
        }

        public GetEntityUsageByIDQueryParams date(String value) {
            this.put("date", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetEntityUsageByFQNQueryParams
    extends HashMap<String, Object> {
        public GetEntityUsageByFQNQueryParams days(Integer value) {
            this.put("days", EncodingUtils.encode(value));
            return this;
        }

        public GetEntityUsageByFQNQueryParams date(String value) {
            this.put("date", EncodingUtils.encode(value));
            return this;
        }
    }
}

