/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.APISchema;
import org.openmetadata.client.model.ChangeDescription;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.Style;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.Votes;

@JsonPropertyOrder(value={"apiCollection", "changeDescription", "children", "dataProducts", "deleted", "description", "displayName", "domain", "endpointURL", "experts", "extension", "followers", "fullyQualifiedName", "href", "id", "lifeCycle", "name", "owners", "provider", "requestMethod", "requestSchema", "responseSchema", "reviewers", "service", "serviceType", "sourceHash", "style", "tags", "updatedAt", "updatedBy", "version", "votes"})
public class APIEndpoint {
    public static final String JSON_PROPERTY_API_COLLECTION = "apiCollection";
    private EntityReference apiCollection;
    public static final String JSON_PROPERTY_CHANGE_DESCRIPTION = "changeDescription";
    private ChangeDescription changeDescription;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    private List<EntityReference> children;
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    private List<EntityReference> dataProducts;
    public static final String JSON_PROPERTY_DELETED = "deleted";
    private Boolean deleted;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private EntityReference domain;
    public static final String JSON_PROPERTY_ENDPOINT_U_R_L = "endpointURL";
    private URI endpointURL;
    public static final String JSON_PROPERTY_EXPERTS = "experts";
    private List<EntityReference> experts;
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    private Object extension;
    public static final String JSON_PROPERTY_FOLLOWERS = "followers";
    private List<EntityReference> followers;
    public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
    private String fullyQualifiedName;
    public static final String JSON_PROPERTY_HREF = "href";
    private URI href;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OWNERS = "owners";
    private List<EntityReference> owners;
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    private ProviderEnum provider;
    public static final String JSON_PROPERTY_REQUEST_METHOD = "requestMethod";
    private RequestMethodEnum requestMethod;
    public static final String JSON_PROPERTY_REQUEST_SCHEMA = "requestSchema";
    private APISchema requestSchema;
    public static final String JSON_PROPERTY_RESPONSE_SCHEMA = "responseSchema";
    private APISchema responseSchema;
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    private List<EntityReference> reviewers;
    public static final String JSON_PROPERTY_SERVICE = "service";
    private EntityReference service;
    public static final String JSON_PROPERTY_SERVICE_TYPE = "serviceType";
    private ServiceTypeEnum serviceType;
    public static final String JSON_PROPERTY_SOURCE_HASH = "sourceHash";
    private String sourceHash;
    public static final String JSON_PROPERTY_STYLE = "style";
    private Style style;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<TagLabel> tags;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private Long updatedAt;
    public static final String JSON_PROPERTY_UPDATED_BY = "updatedBy";
    private String updatedBy;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Double version;
    public static final String JSON_PROPERTY_VOTES = "votes";
    private Votes votes;

    public APIEndpoint apiCollection(EntityReference apiCollection) {
        this.apiCollection = apiCollection;
        return this;
    }

    @Nullable
    @JsonProperty(value="apiCollection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getApiCollection() {
        return this.apiCollection;
    }

    @JsonProperty(value="apiCollection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApiCollection(EntityReference apiCollection) {
        this.apiCollection = apiCollection;
    }

    public APIEndpoint changeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @Nullable
    @JsonProperty(value="changeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @JsonProperty(value="changeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public APIEndpoint children(List<EntityReference> children) {
        this.children = children;
        return this;
    }

    public APIEndpoint addChildrenItem(EntityReference childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<EntityReference>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildren(List<EntityReference> children) {
        this.children = children;
    }

    public APIEndpoint dataProducts(List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public APIEndpoint addDataProductsItem(EntityReference dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<EntityReference>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public APIEndpoint deleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Nullable
    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public APIEndpoint description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public APIEndpoint displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public APIEndpoint domain(EntityReference domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomain(EntityReference domain) {
        this.domain = domain;
    }

    public APIEndpoint endpointURL(URI endpointURL) {
        this.endpointURL = endpointURL;
        return this;
    }

    @Nonnull
    @JsonProperty(value="endpointURL")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getEndpointURL() {
        return this.endpointURL;
    }

    @JsonProperty(value="endpointURL")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndpointURL(URI endpointURL) {
        this.endpointURL = endpointURL;
    }

    public APIEndpoint experts(List<EntityReference> experts) {
        this.experts = experts;
        return this;
    }

    public APIEndpoint addExpertsItem(EntityReference expertsItem) {
        if (this.experts == null) {
            this.experts = new ArrayList<EntityReference>();
        }
        this.experts.add(expertsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="experts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getExperts() {
        return this.experts;
    }

    @JsonProperty(value="experts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExperts(List<EntityReference> experts) {
        this.experts = experts;
    }

    public APIEndpoint extension(Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public APIEndpoint followers(List<EntityReference> followers) {
        this.followers = followers;
        return this;
    }

    public APIEndpoint addFollowersItem(EntityReference followersItem) {
        if (this.followers == null) {
            this.followers = new ArrayList<EntityReference>();
        }
        this.followers.add(followersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="followers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getFollowers() {
        return this.followers;
    }

    @JsonProperty(value="followers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFollowers(List<EntityReference> followers) {
        this.followers = followers;
    }

    public APIEndpoint fullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Nullable
    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public APIEndpoint href(URI href) {
        this.href = href;
        return this;
    }

    @Nullable
    @JsonProperty(value="href")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getHref() {
        return this.href;
    }

    @JsonProperty(value="href")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHref(URI href) {
        this.href = href;
    }

    public APIEndpoint id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(UUID id) {
        this.id = id;
    }

    public APIEndpoint lifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public APIEndpoint name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public APIEndpoint owners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public APIEndpoint addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public APIEndpoint provider(ProviderEnum provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProviderEnum getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(ProviderEnum provider) {
        this.provider = provider;
    }

    public APIEndpoint requestMethod(RequestMethodEnum requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    @Nullable
    @JsonProperty(value="requestMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RequestMethodEnum getRequestMethod() {
        return this.requestMethod;
    }

    @JsonProperty(value="requestMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestMethod(RequestMethodEnum requestMethod) {
        this.requestMethod = requestMethod;
    }

    public APIEndpoint requestSchema(APISchema requestSchema) {
        this.requestSchema = requestSchema;
        return this;
    }

    @Nullable
    @JsonProperty(value="requestSchema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public APISchema getRequestSchema() {
        return this.requestSchema;
    }

    @JsonProperty(value="requestSchema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestSchema(APISchema requestSchema) {
        this.requestSchema = requestSchema;
    }

    public APIEndpoint responseSchema(APISchema responseSchema) {
        this.responseSchema = responseSchema;
        return this;
    }

    @Nullable
    @JsonProperty(value="responseSchema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public APISchema getResponseSchema() {
        return this.responseSchema;
    }

    @JsonProperty(value="responseSchema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResponseSchema(APISchema responseSchema) {
        this.responseSchema = responseSchema;
    }

    public APIEndpoint reviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public APIEndpoint addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public APIEndpoint service(EntityReference service) {
        this.service = service;
        return this;
    }

    @Nonnull
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EntityReference getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setService(EntityReference service) {
        this.service = service;
    }

    public APIEndpoint serviceType(ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @Nullable
    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ServiceTypeEnum getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setServiceType(ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
    }

    public APIEndpoint sourceHash(String sourceHash) {
        this.sourceHash = sourceHash;
        return this;
    }

    @Nullable
    @JsonProperty(value="sourceHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceHash() {
        return this.sourceHash;
    }

    @JsonProperty(value="sourceHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceHash(String sourceHash) {
        this.sourceHash = sourceHash;
    }

    public APIEndpoint style(Style style) {
        this.style = style;
        return this;
    }

    @Nullable
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Style getStyle() {
        return this.style;
    }

    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStyle(Style style) {
        this.style = style;
    }

    public APIEndpoint tags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public APIEndpoint addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public APIEndpoint updatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public APIEndpoint updatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public APIEndpoint version(Double version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(Double version) {
        this.version = version;
    }

    public APIEndpoint votes(Votes votes) {
        this.votes = votes;
        return this;
    }

    @Nullable
    @JsonProperty(value="votes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Votes getVotes() {
        return this.votes;
    }

    @JsonProperty(value="votes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVotes(Votes votes) {
        this.votes = votes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIEndpoint apIEndpoint = (APIEndpoint)o;
        return Objects.equals(this.apiCollection, apIEndpoint.apiCollection) && Objects.equals(this.changeDescription, apIEndpoint.changeDescription) && Objects.equals(this.children, apIEndpoint.children) && Objects.equals(this.dataProducts, apIEndpoint.dataProducts) && Objects.equals(this.deleted, apIEndpoint.deleted) && Objects.equals(this.description, apIEndpoint.description) && Objects.equals(this.displayName, apIEndpoint.displayName) && Objects.equals(this.domain, apIEndpoint.domain) && Objects.equals(this.endpointURL, apIEndpoint.endpointURL) && Objects.equals(this.experts, apIEndpoint.experts) && Objects.equals(this.extension, apIEndpoint.extension) && Objects.equals(this.followers, apIEndpoint.followers) && Objects.equals(this.fullyQualifiedName, apIEndpoint.fullyQualifiedName) && Objects.equals(this.href, apIEndpoint.href) && Objects.equals(this.id, apIEndpoint.id) && Objects.equals(this.lifeCycle, apIEndpoint.lifeCycle) && Objects.equals(this.name, apIEndpoint.name) && Objects.equals(this.owners, apIEndpoint.owners) && Objects.equals((Object)this.provider, (Object)apIEndpoint.provider) && Objects.equals((Object)this.requestMethod, (Object)apIEndpoint.requestMethod) && Objects.equals(this.requestSchema, apIEndpoint.requestSchema) && Objects.equals(this.responseSchema, apIEndpoint.responseSchema) && Objects.equals(this.reviewers, apIEndpoint.reviewers) && Objects.equals(this.service, apIEndpoint.service) && Objects.equals((Object)this.serviceType, (Object)apIEndpoint.serviceType) && Objects.equals(this.sourceHash, apIEndpoint.sourceHash) && Objects.equals(this.style, apIEndpoint.style) && Objects.equals(this.tags, apIEndpoint.tags) && Objects.equals(this.updatedAt, apIEndpoint.updatedAt) && Objects.equals(this.updatedBy, apIEndpoint.updatedBy) && Objects.equals(this.version, apIEndpoint.version) && Objects.equals(this.votes, apIEndpoint.votes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiCollection, this.changeDescription, this.children, this.dataProducts, this.deleted, this.description, this.displayName, this.domain, this.endpointURL, this.experts, this.extension, this.followers, this.fullyQualifiedName, this.href, this.id, this.lifeCycle, this.name, this.owners, this.provider, this.requestMethod, this.requestSchema, this.responseSchema, this.reviewers, this.service, this.serviceType, this.sourceHash, this.style, this.tags, this.updatedAt, this.updatedBy, this.version, this.votes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class APIEndpoint {\n");
        sb.append("    apiCollection: ").append(this.toIndentedString(this.apiCollection)).append("\n");
        sb.append("    changeDescription: ").append(this.toIndentedString(this.changeDescription)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    endpointURL: ").append(this.toIndentedString(this.endpointURL)).append("\n");
        sb.append("    experts: ").append(this.toIndentedString(this.experts)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    followers: ").append(this.toIndentedString(this.followers)).append("\n");
        sb.append("    fullyQualifiedName: ").append(this.toIndentedString(this.fullyQualifiedName)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("    requestMethod: ").append(this.toIndentedString((Object)this.requestMethod)).append("\n");
        sb.append("    requestSchema: ").append(this.toIndentedString(this.requestSchema)).append("\n");
        sb.append("    responseSchema: ").append(this.toIndentedString(this.responseSchema)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString((Object)this.serviceType)).append("\n");
        sb.append("    sourceHash: ").append(this.toIndentedString(this.sourceHash)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    votes: ").append(this.toIndentedString(this.votes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProviderEnum {
        SYSTEM("system"),
        USER("user");

        private String value;

        private ProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProviderEnum fromValue(String value) {
            for (ProviderEnum b : ProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RequestMethodEnum {
        GET("GET"),
        POST("POST"),
        PUT("PUT"),
        PATCH("PATCH"),
        DELETE("DELETE"),
        HEAD("HEAD"),
        CONNECT("CONNECT"),
        OPTIONS("OPTIONS"),
        TRACE("TRACE");

        private String value;

        private RequestMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RequestMethodEnum fromValue(String value) {
            for (RequestMethodEnum b : RequestMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ServiceTypeEnum {
        REST("REST"),
        WEBHOOK("WEBHOOK");

        private String value;

        private ServiceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceTypeEnum fromValue(String value) {
            for (ServiceTypeEnum b : ServiceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

