/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.MessagingConnection;
import org.openmetadata.client.model.TagLabel;

@JsonPropertyOrder(value={"connection", "dataProducts", "description", "displayName", "domain", "extension", "lifeCycle", "name", "owners", "reviewers", "serviceType", "tags"})
public class CreateMessagingService {
    public static final String JSON_PROPERTY_CONNECTION = "connection";
    private MessagingConnection connection;
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    private List<String> dataProducts;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    private Object extension;
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OWNERS = "owners";
    private List<EntityReference> owners;
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    private List<EntityReference> reviewers;
    public static final String JSON_PROPERTY_SERVICE_TYPE = "serviceType";
    private ServiceTypeEnum serviceType;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<TagLabel> tags;

    public CreateMessagingService connection(MessagingConnection connection) {
        this.connection = connection;
        return this;
    }

    @Nullable
    @JsonProperty(value="connection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MessagingConnection getConnection() {
        return this.connection;
    }

    @JsonProperty(value="connection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConnection(MessagingConnection connection) {
        this.connection = connection;
    }

    public CreateMessagingService dataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public CreateMessagingService addDataProductsItem(String dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<String>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public CreateMessagingService description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateMessagingService displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateMessagingService domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CreateMessagingService extension(Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public CreateMessagingService lifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public CreateMessagingService name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateMessagingService owners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public CreateMessagingService addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateMessagingService reviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public CreateMessagingService addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public CreateMessagingService serviceType(ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ServiceTypeEnum getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setServiceType(ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
    }

    public CreateMessagingService tags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public CreateMessagingService addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMessagingService createMessagingService = (CreateMessagingService)o;
        return Objects.equals(this.connection, createMessagingService.connection) && Objects.equals(this.dataProducts, createMessagingService.dataProducts) && Objects.equals(this.description, createMessagingService.description) && Objects.equals(this.displayName, createMessagingService.displayName) && Objects.equals(this.domain, createMessagingService.domain) && Objects.equals(this.extension, createMessagingService.extension) && Objects.equals(this.lifeCycle, createMessagingService.lifeCycle) && Objects.equals(this.name, createMessagingService.name) && Objects.equals(this.owners, createMessagingService.owners) && Objects.equals(this.reviewers, createMessagingService.reviewers) && Objects.equals((Object)this.serviceType, (Object)createMessagingService.serviceType) && Objects.equals(this.tags, createMessagingService.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.connection, this.dataProducts, this.description, this.displayName, this.domain, this.extension, this.lifeCycle, this.name, this.owners, this.reviewers, this.serviceType, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateMessagingService {\n");
        sb.append("    connection: ").append(this.toIndentedString(this.connection)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString((Object)this.serviceType)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ServiceTypeEnum {
        KAFKA("Kafka"),
        REDPANDA("Redpanda"),
        KINESIS("Kinesis"),
        CUSTOMMESSAGING("CustomMessaging");

        private String value;

        private ServiceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceTypeEnum fromValue(String value) {
            for (ServiceTypeEnum b : ServiceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

