/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.Rule;

@JsonPropertyOrder(value={"access", "operation", "policy", "role", "rule"})
public class Permission {
    public static final String JSON_PROPERTY_ACCESS = "access";
    private AccessEnum access;
    public static final String JSON_PROPERTY_OPERATION = "operation";
    private OperationEnum operation;
    public static final String JSON_PROPERTY_POLICY = "policy";
    private String policy;
    public static final String JSON_PROPERTY_ROLE = "role";
    private String role;
    public static final String JSON_PROPERTY_RULE = "rule";
    private Rule rule;

    public Permission access(AccessEnum access) {
        this.access = access;
        return this;
    }

    @Nullable
    @JsonProperty(value="access")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccessEnum getAccess() {
        return this.access;
    }

    @JsonProperty(value="access")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccess(AccessEnum access) {
        this.access = access;
    }

    public Permission operation(OperationEnum operation) {
        this.operation = operation;
        return this;
    }

    @Nullable
    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OperationEnum getOperation() {
        return this.operation;
    }

    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperation(OperationEnum operation) {
        this.operation = operation;
    }

    public Permission policy(String policy) {
        this.policy = policy;
        return this;
    }

    @Nullable
    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPolicy() {
        return this.policy;
    }

    @JsonProperty(value="policy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public Permission role(String role) {
        this.role = role;
        return this;
    }

    @Nullable
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRole(String role) {
        this.role = role;
    }

    public Permission rule(Rule rule) {
        this.rule = rule;
        return this;
    }

    @Nullable
    @JsonProperty(value="rule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Rule getRule() {
        return this.rule;
    }

    @JsonProperty(value="rule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Permission permission = (Permission)o;
        return Objects.equals((Object)this.access, (Object)permission.access) && Objects.equals((Object)this.operation, (Object)permission.operation) && Objects.equals(this.policy, permission.policy) && Objects.equals(this.role, permission.role) && Objects.equals(this.rule, permission.rule);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.access, this.operation, this.policy, this.role, this.rule});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Permission {\n");
        sb.append("    access: ").append(this.toIndentedString((Object)this.access)).append("\n");
        sb.append("    operation: ").append(this.toIndentedString((Object)this.operation)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    rule: ").append(this.toIndentedString(this.rule)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AccessEnum {
        DENY("deny"),
        ALLOW("allow"),
        CONDITIONALDENY("conditionalDeny"),
        CONDITIONALALLOW("conditionalAllow"),
        NOTALLOW("notAllow");

        private String value;

        private AccessEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccessEnum fromValue(String value) {
            for (AccessEnum b : AccessEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum OperationEnum {
        ALL("All"),
        CREATE("Create"),
        CREATEINGESTIONPIPELINEAUTOMATOR("CreateIngestionPipelineAutomator"),
        DELETE("Delete"),
        VIEWALL("ViewAll"),
        VIEWBASIC("ViewBasic"),
        VIEWUSAGE("ViewUsage"),
        VIEWTESTS("ViewTests"),
        VIEWQUERIES("ViewQueries"),
        VIEWDATAPROFILE("ViewDataProfile"),
        VIEWSAMPLEDATA("ViewSampleData"),
        VIEWTESTCASEFAILEDROWSSAMPLE("ViewTestCaseFailedRowsSample"),
        EDITALL("EditAll"),
        EDITCUSTOMFIELDS("EditCustomFields"),
        EDITDATAPROFILE("EditDataProfile"),
        EDITDESCRIPTION("EditDescription"),
        EDITDISPLAYNAME("EditDisplayName"),
        EDITLINEAGE("EditLineage"),
        EDITPOLICY("EditPolicy"),
        EDITOWNERS("EditOwners"),
        EDITQUERIES("EditQueries"),
        EDITREVIEWERS("EditReviewers"),
        EDITROLE("EditRole"),
        EDITSAMPLEDATA("EditSampleData"),
        EDITSTATUS("EditStatus"),
        EDITTAGS("EditTags"),
        EDITTEAMS("EditTeams"),
        EDITTIER("EditTier"),
        EDITTESTS("EditTests"),
        EDITUSAGE("EditUsage"),
        EDITUSERS("EditUsers"),
        EDITLIFECYCLE("EditLifeCycle"),
        EDITKNOWLEDGEPANEL("EditKnowledgePanel"),
        EDITPAGE("EditPage"),
        EDITINGESTIONPIPELINESTATUS("EditIngestionPipelineStatus"),
        DELETETESTCASEFAILEDROWSSAMPLE("DeleteTestCaseFailedRowsSample"),
        DEPLOY("Deploy"),
        TRIGGER("Trigger"),
        KILL("Kill"),
        GENERATETOKEN("GenerateToken");

        private String value;

        private OperationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperationEnum fromValue(String value) {
            for (OperationEnum b : OperationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

