/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"expiryDate", "jwtToken", "token", "tokenName", "tokenType", "userId"})
public class PersonalAccessToken {
    public static final String JSON_PROPERTY_EXPIRY_DATE = "expiryDate";
    private Long expiryDate;
    public static final String JSON_PROPERTY_JWT_TOKEN = "jwtToken";
    private String jwtToken;
    public static final String JSON_PROPERTY_TOKEN = "token";
    private UUID token;
    public static final String JSON_PROPERTY_TOKEN_NAME = "tokenName";
    private String tokenName;
    public static final String JSON_PROPERTY_TOKEN_TYPE = "tokenType";
    private TokenTypeEnum tokenType;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private UUID userId;

    public PersonalAccessToken expiryDate(Long expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    @Nonnull
    @JsonProperty(value="expiryDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getExpiryDate() {
        return this.expiryDate;
    }

    @JsonProperty(value="expiryDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExpiryDate(Long expiryDate) {
        this.expiryDate = expiryDate;
    }

    public PersonalAccessToken jwtToken(String jwtToken) {
        this.jwtToken = jwtToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="jwtToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getJwtToken() {
        return this.jwtToken;
    }

    @JsonProperty(value="jwtToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJwtToken(String jwtToken) {
        this.jwtToken = jwtToken;
    }

    public PersonalAccessToken token(UUID token) {
        this.token = token;
        return this;
    }

    @Nonnull
    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getToken() {
        return this.token;
    }

    @JsonProperty(value="token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setToken(UUID token) {
        this.token = token;
    }

    public PersonalAccessToken tokenName(String tokenName) {
        this.tokenName = tokenName;
        return this;
    }

    @Nullable
    @JsonProperty(value="tokenName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTokenName() {
        return this.tokenName;
    }

    @JsonProperty(value="tokenName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public PersonalAccessToken tokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Nullable
    @JsonProperty(value="tokenType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TokenTypeEnum getTokenType() {
        return this.tokenType;
    }

    @JsonProperty(value="tokenType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenType(TokenTypeEnum tokenType) {
        this.tokenType = tokenType;
    }

    public PersonalAccessToken userId(UUID userId) {
        this.userId = userId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersonalAccessToken personalAccessToken = (PersonalAccessToken)o;
        return Objects.equals(this.expiryDate, personalAccessToken.expiryDate) && Objects.equals(this.jwtToken, personalAccessToken.jwtToken) && Objects.equals(this.token, personalAccessToken.token) && Objects.equals(this.tokenName, personalAccessToken.tokenName) && Objects.equals((Object)this.tokenType, (Object)personalAccessToken.tokenType) && Objects.equals(this.userId, personalAccessToken.userId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expiryDate, this.jwtToken, this.token, this.tokenName, this.tokenType, this.userId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PersonalAccessToken {\n");
        sb.append("    expiryDate: ").append(this.toIndentedString(this.expiryDate)).append("\n");
        sb.append("    jwtToken: ").append(this.toIndentedString(this.jwtToken)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    tokenName: ").append(this.toIndentedString(this.tokenName)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString((Object)this.tokenType)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TokenTypeEnum {
        REFRESH_TOKEN("REFRESH_TOKEN"),
        EMAIL_VERIFICATION("EMAIL_VERIFICATION"),
        PASSWORD_RESET("PASSWORD_RESET"),
        PERSONAL_ACCESS_TOKEN("PERSONAL_ACCESS_TOKEN");

        private String value;

        private TokenTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TokenTypeEnum fromValue(String value) {
            for (TokenTypeEnum b : TokenTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

