/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.openmetadata.client.model.EntityReference;

@JsonPropertyOrder(value={"reactionType", "user"})
public class Reaction {
    public static final String JSON_PROPERTY_REACTION_TYPE = "reactionType";
    private ReactionTypeEnum reactionType;
    public static final String JSON_PROPERTY_USER = "user";
    private EntityReference user;

    public Reaction reactionType(ReactionTypeEnum reactionType) {
        this.reactionType = reactionType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="reactionType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ReactionTypeEnum getReactionType() {
        return this.reactionType;
    }

    @JsonProperty(value="reactionType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setReactionType(ReactionTypeEnum reactionType) {
        this.reactionType = reactionType;
    }

    public Reaction user(EntityReference user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EntityReference getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(EntityReference user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reaction reaction = (Reaction)o;
        return Objects.equals((Object)this.reactionType, (Object)reaction.reactionType) && Objects.equals(this.user, reaction.user);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reactionType, this.user});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Reaction {\n");
        sb.append("    reactionType: ").append(this.toIndentedString((Object)this.reactionType)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ReactionTypeEnum {
        THUMBSUP("thumbsUp"),
        THUMBSDOWN("thumbsDown"),
        HOORAY("hooray"),
        LAUGH("laugh"),
        CONFUSED("confused"),
        HEART("heart"),
        ROCKET("rocket"),
        EYES("eyes");

        private String value;

        private ReactionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReactionTypeEnum fromValue(String value) {
            for (ReactionTypeEnum b : ReactionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

