/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CSVExportResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateDatabaseSchema;
import org.openmetadata.client.model.CsvImportResult;
import org.openmetadata.client.model.DatabaseSchema;
import org.openmetadata.client.model.DatabaseSchemaList;
import org.openmetadata.client.model.DatabaseSchemaProfilerConfig;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.SearchResponse;
import org.openmetadata.client.model.VoteRequest;

public interface DatabaseSchemasApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/databaseSchemas/{id}/databaseSchemaProfilerConfig")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseSchema addDataProfilerConfig1(@Param(value="id") UUID var1, DatabaseSchemaProfilerConfig var2);

    @RequestLine(value="PUT /v1/databaseSchemas/{id}/databaseSchemaProfilerConfig")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DatabaseSchema> addDataProfilerConfig1WithHttpInfo(@Param(value="id") UUID var1, DatabaseSchemaProfilerConfig var2);

    @RequestLine(value="PUT /v1/databaseSchemas/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToDatabaseSchema(@Param(value="id") UUID var1, String var2);

    @RequestLine(value="PUT /v1/databaseSchemas/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToDatabaseSchemaWithHttpInfo(@Param(value="id") UUID var1, String var2);

    @RequestLine(value="POST /v1/databaseSchemas")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseSchema createDBSchema(CreateDatabaseSchema var1);

    @RequestLine(value="POST /v1/databaseSchemas")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DatabaseSchema> createDBSchemaWithHttpInfo(CreateDatabaseSchema var1);

    @RequestLine(value="PUT /v1/databaseSchemas")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseSchema createOrUpdateDBSchema(CreateDatabaseSchema var1);

    @RequestLine(value="PUT /v1/databaseSchemas")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DatabaseSchema> createOrUpdateDBSchemaWithHttpInfo(CreateDatabaseSchema var1);

    @RequestLine(value="DELETE /v1/databaseSchemas/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDBSchema(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/databaseSchemas/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDBSchemaWithHttpInfo(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/databaseSchemas/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDBSchema(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteDBSchemaQueryParams var2);

    @RequestLine(value="DELETE /v1/databaseSchemas/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDBSchemaWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteDBSchemaQueryParams var2);

    @RequestLine(value="DELETE /v1/databaseSchemas/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDBSchemaAsync(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/databaseSchemas/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDBSchemaAsyncWithHttpInfo(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/databaseSchemas/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDBSchemaAsync(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteDBSchemaAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/databaseSchemas/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDBSchemaAsyncWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteDBSchemaAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/databaseSchemas/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDBSchemaByFQN(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/databaseSchemas/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDBSchemaByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/databaseSchemas/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDBSchemaByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteDBSchemaByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/databaseSchemas/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDBSchemaByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteDBSchemaByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/databaseSchemas/{id}/databaseSchemaProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchema deleteDataProfilerConfig1(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/databaseSchemas/{id}/databaseSchemaProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseSchema> deleteDataProfilerConfig1WithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/databaseSchemas/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower2(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/databaseSchemas/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower2WithHttpInfo(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public String exportDatabaseSchema(@Param(value="name") String var1, @Param(value="recursive") Boolean var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportDatabaseSchemaWithHttpInfo(@Param(value="name") String var1, @Param(value="recursive") Boolean var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public String exportDatabaseSchema(@Param(value="name") String var1, @QueryMap(encoded=true) ExportDatabaseSchemaQueryParams var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportDatabaseSchemaWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) ExportDatabaseSchemaQueryParams var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{name}/exportAsync?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public CSVExportResponse exportDatabaseSchema1(@Param(value="name") String var1, @Param(value="recursive") Boolean var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{name}/exportAsync?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CSVExportResponse> exportDatabaseSchema1WithHttpInfo(@Param(value="name") String var1, @Param(value="recursive") Boolean var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{name}/exportAsync?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public CSVExportResponse exportDatabaseSchema1(@Param(value="name") String var1, @QueryMap(encoded=true) ExportDatabaseSchema1QueryParams var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{name}/exportAsync?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CSVExportResponse> exportDatabaseSchema1WithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) ExportDatabaseSchema1QueryParams var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchema getDBSchemaByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/databaseSchemas/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseSchema> getDBSchemaByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/databaseSchemas/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchema getDBSchemaByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetDBSchemaByFQNQueryParams var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseSchema> getDBSchemaByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetDBSchemaByFQNQueryParams var2);

    @RequestLine(value="GET /v1/databaseSchemas/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchema getDBSchemaByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/databaseSchemas/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseSchema> getDBSchemaByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/databaseSchemas/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchema getDBSchemaByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetDBSchemaByIDQueryParams var2);

    @RequestLine(value="GET /v1/databaseSchemas/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseSchema> getDBSchemaByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetDBSchemaByIDQueryParams var2);

    @RequestLine(value="GET /v1/databaseSchemas/{id}/databaseSchemaProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchema getDataProfilerConfig1(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/databaseSchemas/{id}/databaseSchemaProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseSchema> getDataProfilerConfig1WithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/databaseSchemas/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchema getSpecificDBSchemaVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/databaseSchemas/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseSchema> getSpecificDBSchemaVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="PUT /v1/databaseSchemas/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset&#x3D;UTF-8", "Accept: application/json"})
    public CsvImportResult importDatabaseSchema(@Param(value="name") String var1, @Param(value="dryRun") Boolean var2, @Param(value="recursive") Boolean var3, String var4);

    @RequestLine(value="PUT /v1/databaseSchemas/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset&#x3D;UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDatabaseSchemaWithHttpInfo(@Param(value="name") String var1, @Param(value="dryRun") Boolean var2, @Param(value="recursive") Boolean var3, String var4);

    @RequestLine(value="PUT /v1/databaseSchemas/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset&#x3D;UTF-8", "Accept: application/json"})
    public CsvImportResult importDatabaseSchema(@Param(value="name") String var1, String var2, @QueryMap(encoded=true) ImportDatabaseSchemaQueryParams var3);

    @RequestLine(value="PUT /v1/databaseSchemas/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset&#x3D;UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDatabaseSchemaWithHttpInfo(@Param(value="name") String var1, String var2, @QueryMap(encoded=true) ImportDatabaseSchemaQueryParams var3);

    @RequestLine(value="PUT /v1/databaseSchemas/name/{name}/importAsync?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset&#x3D;UTF-8", "Accept: application/json"})
    public CsvImportResult importDatabaseSchemaAsync(@Param(value="name") String var1, @Param(value="dryRun") Boolean var2, @Param(value="recursive") Boolean var3, String var4);

    @RequestLine(value="PUT /v1/databaseSchemas/name/{name}/importAsync?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset&#x3D;UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDatabaseSchemaAsyncWithHttpInfo(@Param(value="name") String var1, @Param(value="dryRun") Boolean var2, @Param(value="recursive") Boolean var3, String var4);

    @RequestLine(value="PUT /v1/databaseSchemas/name/{name}/importAsync?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset&#x3D;UTF-8", "Accept: application/json"})
    public CsvImportResult importDatabaseSchemaAsync(@Param(value="name") String var1, String var2, @QueryMap(encoded=true) ImportDatabaseSchemaAsyncQueryParams var3);

    @RequestLine(value="PUT /v1/databaseSchemas/name/{name}/importAsync?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset&#x3D;UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDatabaseSchemaAsyncWithHttpInfo(@Param(value="name") String var1, String var2, @QueryMap(encoded=true) ImportDatabaseSchemaAsyncQueryParams var3);

    @RequestLine(value="GET /v1/databaseSchemas/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllDBSchemaVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/databaseSchemas/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllDBSchemaVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/databaseSchemas?fields={fields}&database={database}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchemaList listDBSchemas(@Param(value="fields") String var1, @Param(value="database") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/databaseSchemas?fields={fields}&database={database}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseSchemaList> listDBSchemasWithHttpInfo(@Param(value="fields") String var1, @Param(value="database") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/databaseSchemas?fields={fields}&database={database}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchemaList listDBSchemas(@QueryMap(encoded=true) ListDBSchemasQueryParams var1);

    @RequestLine(value="GET /v1/databaseSchemas?fields={fields}&database={database}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseSchemaList> listDBSchemasWithHttpInfo(@QueryMap(encoded=true) ListDBSchemasQueryParams var1);

    @RequestLine(value="PATCH /v1/databaseSchemas/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDBSchema(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/databaseSchemas/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDBSchemaWithHttpInfo(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/databaseSchemas/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDBSchema1(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/databaseSchemas/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDBSchema1WithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/databaseSchemas/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseSchema restore8(RestoreEntity var1);

    @RequestLine(value="PUT /v1/databaseSchemas/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DatabaseSchema> restore8WithHttpInfo(RestoreEntity var1);

    @RequestLine(value="GET /v1/databaseSchemas/entityRelationship?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchSchemaEntityRelationship(@Param(value="fqn") String var1, @Param(value="upstreamDepth") Integer var2, @Param(value="downstreamDepth") Integer var3, @Param(value="queryFilter") String var4, @Param(value="includeDeleted") Boolean var5);

    @RequestLine(value="GET /v1/databaseSchemas/entityRelationship?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchSchemaEntityRelationshipWithHttpInfo(@Param(value="fqn") String var1, @Param(value="upstreamDepth") Integer var2, @Param(value="downstreamDepth") Integer var3, @Param(value="queryFilter") String var4, @Param(value="includeDeleted") Boolean var5);

    @RequestLine(value="GET /v1/databaseSchemas/entityRelationship?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchSchemaEntityRelationship(@QueryMap(encoded=true) SearchSchemaEntityRelationshipQueryParams var1);

    @RequestLine(value="GET /v1/databaseSchemas/entityRelationship?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchSchemaEntityRelationshipWithHttpInfo(@QueryMap(encoded=true) SearchSchemaEntityRelationshipQueryParams var1);

    @RequestLine(value="PUT /v1/databaseSchemas/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity3(@Param(value="id") UUID var1, VoteRequest var2);

    @RequestLine(value="PUT /v1/databaseSchemas/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity3WithHttpInfo(@Param(value="id") UUID var1, VoteRequest var2);

    public static class SearchSchemaEntityRelationshipQueryParams
    extends HashMap<String, Object> {
        public SearchSchemaEntityRelationshipQueryParams fqn(String value) {
            this.put("fqn", EncodingUtils.encode(value));
            return this;
        }

        public SearchSchemaEntityRelationshipQueryParams upstreamDepth(Integer value) {
            this.put("upstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public SearchSchemaEntityRelationshipQueryParams downstreamDepth(Integer value) {
            this.put("downstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public SearchSchemaEntityRelationshipQueryParams queryFilter(String value) {
            this.put("query_filter", EncodingUtils.encode(value));
            return this;
        }

        public SearchSchemaEntityRelationshipQueryParams includeDeleted(Boolean value) {
            this.put("includeDeleted", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListDBSchemasQueryParams
    extends HashMap<String, Object> {
        public ListDBSchemasQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDBSchemasQueryParams database(String value) {
            this.put("database", EncodingUtils.encode(value));
            return this;
        }

        public ListDBSchemasQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDBSchemasQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDBSchemasQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListDBSchemasQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportDatabaseSchemaAsyncQueryParams
    extends HashMap<String, Object> {
        public ImportDatabaseSchemaAsyncQueryParams dryRun(Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }

        public ImportDatabaseSchemaAsyncQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportDatabaseSchemaQueryParams
    extends HashMap<String, Object> {
        public ImportDatabaseSchemaQueryParams dryRun(Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }

        public ImportDatabaseSchemaQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDBSchemaByIDQueryParams
    extends HashMap<String, Object> {
        public GetDBSchemaByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDBSchemaByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDBSchemaByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDBSchemaByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDBSchemaByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ExportDatabaseSchema1QueryParams
    extends HashMap<String, Object> {
        public ExportDatabaseSchema1QueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ExportDatabaseSchemaQueryParams
    extends HashMap<String, Object> {
        public ExportDatabaseSchemaQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDBSchemaByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteDBSchemaByFQNQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDBSchemaByFQNQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDBSchemaAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteDBSchemaAsyncQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDBSchemaAsyncQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDBSchemaQueryParams
    extends HashMap<String, Object> {
        public DeleteDBSchemaQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDBSchemaQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

