/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.gateway;

import com.fasterxml.jackson.annotation.JsonInclude;
import feign.Client;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;
import java.util.Objects;
import lombok.Generated;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.api.SystemApi;
import org.openmetadata.client.model.OpenMetadataServerVersion;
import org.openmetadata.client.security.factory.AuthenticationProviderFactory;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.schema.utils.VersionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenMetadata {
    @Generated
    private static final Logger LOG = LoggerFactory.getLogger(OpenMetadata.class);
    private static final org.openmetadata.schema.api.OpenMetadataServerVersion OPENMETADATA_VERSION_CLIENT = VersionUtils.getOpenMetadataServerVersion((String)"/catalog/VERSION");
    private ApiClient apiClient;
    private static final String REQUEST_INTERCEPTOR_KEY = "custom";

    public OpenMetadata(OpenMetadataConnection config) {
        this.initClient(config);
        this.validateVersion();
    }

    public OpenMetadata(OpenMetadataConnection config, boolean validateVersion) {
        this.initClient(config);
        if (validateVersion) {
            this.validateVersion();
        }
    }

    public void initClient(OpenMetadataConnection config) {
        this.apiClient = new ApiClient();
        Feign.Builder builder = Feign.builder().encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(this.apiClient.getObjectMapper()))).decoder((Decoder)new JacksonDecoder(this.apiClient.getObjectMapper())).logger((feign.Logger)new Slf4jLogger()).client((Client)new OkHttpClient());
        this.initClient(config, builder);
    }

    public void initClient(OpenMetadataConnection config, Feign.Builder builder) {
        if (Objects.isNull(this.apiClient)) {
            this.apiClient = new ApiClient();
        }
        this.apiClient.setFeignBuilder(builder);
        AuthenticationProviderFactory factory = new AuthenticationProviderFactory();
        this.apiClient.addAuthorization("oauth", factory.getAuthProvider(config));
        String basePath = config.getHostPort() + "/";
        this.apiClient.setBasePath(basePath);
        this.apiClient.getObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public <T extends ApiClient.Api> T buildClient(Class<T> clientClass) {
        return this.apiClient.buildClient(clientClass);
    }

    public void validateVersion() {
        String[] clientVersion = this.getClientVersion();
        String[] serverVersion = this.getServerVersion();
        if (serverVersion[0].equals(clientVersion[0]) && serverVersion[1].equals(clientVersion[1]) && serverVersion[2].equals(clientVersion[2])) {
            LOG.debug("OpenMetaData Client Initialized successfully.");
        } else {
            LOG.error("OpenMetaData Client Failed to be Initialized successfully. Version mismatch between CLient and Server issue");
        }
    }

    public String[] getServerVersion() {
        SystemApi api = this.apiClient.buildClient(SystemApi.class);
        OpenMetadataServerVersion serverVersion = api.getCatalogVersion();
        return VersionUtils.getVersionFromString((String)serverVersion.getVersion());
    }

    public String[] getClientVersion() {
        return VersionUtils.getVersionFromString((String)OPENMETADATA_VERSION_CLIENT.getVersion());
    }
}

