/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.APISchema;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.TagLabel;

@JsonPropertyOrder(value={"apiCollection", "dataProducts", "description", "displayName", "domain", "endpointURL", "extension", "lifeCycle", "name", "owners", "requestMethod", "requestSchema", "responseSchema", "reviewers", "sourceHash", "sourceUrl", "tags"})
public class CreateAPIEndpoint {
    public static final String JSON_PROPERTY_API_COLLECTION = "apiCollection";
    private String apiCollection;
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    private List<String> dataProducts;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;
    public static final String JSON_PROPERTY_ENDPOINT_U_R_L = "endpointURL";
    private URI endpointURL;
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    private Object extension;
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OWNERS = "owners";
    private List<EntityReference> owners;
    public static final String JSON_PROPERTY_REQUEST_METHOD = "requestMethod";
    private RequestMethodEnum requestMethod;
    public static final String JSON_PROPERTY_REQUEST_SCHEMA = "requestSchema";
    private APISchema requestSchema;
    public static final String JSON_PROPERTY_RESPONSE_SCHEMA = "responseSchema";
    private APISchema responseSchema;
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    private List<EntityReference> reviewers;
    public static final String JSON_PROPERTY_SOURCE_HASH = "sourceHash";
    private String sourceHash;
    public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
    private String sourceUrl;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<TagLabel> tags;

    public CreateAPIEndpoint apiCollection(String apiCollection) {
        this.apiCollection = apiCollection;
        return this;
    }

    @Nonnull
    @JsonProperty(value="apiCollection")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getApiCollection() {
        return this.apiCollection;
    }

    @JsonProperty(value="apiCollection")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setApiCollection(String apiCollection) {
        this.apiCollection = apiCollection;
    }

    public CreateAPIEndpoint dataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public CreateAPIEndpoint addDataProductsItem(String dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<String>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public CreateAPIEndpoint description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateAPIEndpoint displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateAPIEndpoint domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CreateAPIEndpoint endpointURL(URI endpointURL) {
        this.endpointURL = endpointURL;
        return this;
    }

    @Nonnull
    @JsonProperty(value="endpointURL")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getEndpointURL() {
        return this.endpointURL;
    }

    @JsonProperty(value="endpointURL")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndpointURL(URI endpointURL) {
        this.endpointURL = endpointURL;
    }

    public CreateAPIEndpoint extension(Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public CreateAPIEndpoint lifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public CreateAPIEndpoint name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateAPIEndpoint owners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public CreateAPIEndpoint addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateAPIEndpoint requestMethod(RequestMethodEnum requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    @Nullable
    @JsonProperty(value="requestMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RequestMethodEnum getRequestMethod() {
        return this.requestMethod;
    }

    @JsonProperty(value="requestMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestMethod(RequestMethodEnum requestMethod) {
        this.requestMethod = requestMethod;
    }

    public CreateAPIEndpoint requestSchema(APISchema requestSchema) {
        this.requestSchema = requestSchema;
        return this;
    }

    @Nullable
    @JsonProperty(value="requestSchema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public APISchema getRequestSchema() {
        return this.requestSchema;
    }

    @JsonProperty(value="requestSchema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestSchema(APISchema requestSchema) {
        this.requestSchema = requestSchema;
    }

    public CreateAPIEndpoint responseSchema(APISchema responseSchema) {
        this.responseSchema = responseSchema;
        return this;
    }

    @Nullable
    @JsonProperty(value="responseSchema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public APISchema getResponseSchema() {
        return this.responseSchema;
    }

    @JsonProperty(value="responseSchema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResponseSchema(APISchema responseSchema) {
        this.responseSchema = responseSchema;
    }

    public CreateAPIEndpoint reviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public CreateAPIEndpoint addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public CreateAPIEndpoint sourceHash(String sourceHash) {
        this.sourceHash = sourceHash;
        return this;
    }

    @Nullable
    @JsonProperty(value="sourceHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceHash() {
        return this.sourceHash;
    }

    @JsonProperty(value="sourceHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceHash(String sourceHash) {
        this.sourceHash = sourceHash;
    }

    public CreateAPIEndpoint sourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @JsonProperty(value="sourceUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public CreateAPIEndpoint tags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public CreateAPIEndpoint addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAPIEndpoint createAPIEndpoint = (CreateAPIEndpoint)o;
        return Objects.equals(this.apiCollection, createAPIEndpoint.apiCollection) && Objects.equals(this.dataProducts, createAPIEndpoint.dataProducts) && Objects.equals(this.description, createAPIEndpoint.description) && Objects.equals(this.displayName, createAPIEndpoint.displayName) && Objects.equals(this.domain, createAPIEndpoint.domain) && Objects.equals(this.endpointURL, createAPIEndpoint.endpointURL) && Objects.equals(this.extension, createAPIEndpoint.extension) && Objects.equals(this.lifeCycle, createAPIEndpoint.lifeCycle) && Objects.equals(this.name, createAPIEndpoint.name) && Objects.equals(this.owners, createAPIEndpoint.owners) && Objects.equals((Object)this.requestMethod, (Object)createAPIEndpoint.requestMethod) && Objects.equals(this.requestSchema, createAPIEndpoint.requestSchema) && Objects.equals(this.responseSchema, createAPIEndpoint.responseSchema) && Objects.equals(this.reviewers, createAPIEndpoint.reviewers) && Objects.equals(this.sourceHash, createAPIEndpoint.sourceHash) && Objects.equals(this.sourceUrl, createAPIEndpoint.sourceUrl) && Objects.equals(this.tags, createAPIEndpoint.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiCollection, this.dataProducts, this.description, this.displayName, this.domain, this.endpointURL, this.extension, this.lifeCycle, this.name, this.owners, this.requestMethod, this.requestSchema, this.responseSchema, this.reviewers, this.sourceHash, this.sourceUrl, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateAPIEndpoint {\n");
        sb.append("    apiCollection: ").append(this.toIndentedString(this.apiCollection)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    endpointURL: ").append(this.toIndentedString(this.endpointURL)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    requestMethod: ").append(this.toIndentedString((Object)this.requestMethod)).append("\n");
        sb.append("    requestSchema: ").append(this.toIndentedString(this.requestSchema)).append("\n");
        sb.append("    responseSchema: ").append(this.toIndentedString(this.responseSchema)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("    sourceHash: ").append(this.toIndentedString(this.sourceHash)).append("\n");
        sb.append("    sourceUrl: ").append(this.toIndentedString(this.sourceUrl)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RequestMethodEnum {
        GET("GET"),
        POST("POST"),
        PUT("PUT"),
        PATCH("PATCH"),
        DELETE("DELETE"),
        HEAD("HEAD"),
        CONNECT("CONNECT"),
        OPTIONS("OPTIONS"),
        TRACE("TRACE");

        private String value;

        private RequestMethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RequestMethodEnum fromValue(String value) {
            for (RequestMethodEnum b : RequestMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

