/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.TestCaseParameter;

@JsonPropertyOrder(value={"dataProducts", "description", "displayName", "domain", "entityType", "extension", "lifeCycle", "name", "owners", "parameterDefinition", "provider", "reviewers", "supportedDataTypes", "tags", "testPlatforms"})
public class CreateTestDefinition {
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    private List<String> dataProducts;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;
    public static final String JSON_PROPERTY_ENTITY_TYPE = "entityType";
    private EntityTypeEnum entityType;
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    private Object extension;
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OWNERS = "owners";
    private List<EntityReference> owners;
    public static final String JSON_PROPERTY_PARAMETER_DEFINITION = "parameterDefinition";
    private List<TestCaseParameter> parameterDefinition;
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    private ProviderEnum provider;
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    private List<EntityReference> reviewers;
    public static final String JSON_PROPERTY_SUPPORTED_DATA_TYPES = "supportedDataTypes";
    private List<SupportedDataTypesEnum> supportedDataTypes;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<TagLabel> tags;
    public static final String JSON_PROPERTY_TEST_PLATFORMS = "testPlatforms";
    private List<TestPlatformsEnum> testPlatforms = new ArrayList<TestPlatformsEnum>();

    public CreateTestDefinition dataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public CreateTestDefinition addDataProductsItem(String dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<String>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public CreateTestDefinition description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateTestDefinition displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateTestDefinition domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CreateTestDefinition entityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public EntityTypeEnum getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEntityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
    }

    public CreateTestDefinition extension(Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public CreateTestDefinition lifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public CreateTestDefinition name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateTestDefinition owners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public CreateTestDefinition addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateTestDefinition parameterDefinition(List<TestCaseParameter> parameterDefinition) {
        this.parameterDefinition = parameterDefinition;
        return this;
    }

    public CreateTestDefinition addParameterDefinitionItem(TestCaseParameter parameterDefinitionItem) {
        if (this.parameterDefinition == null) {
            this.parameterDefinition = new ArrayList<TestCaseParameter>();
        }
        this.parameterDefinition.add(parameterDefinitionItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="parameterDefinition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TestCaseParameter> getParameterDefinition() {
        return this.parameterDefinition;
    }

    @JsonProperty(value="parameterDefinition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParameterDefinition(List<TestCaseParameter> parameterDefinition) {
        this.parameterDefinition = parameterDefinition;
    }

    public CreateTestDefinition provider(ProviderEnum provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProviderEnum getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(ProviderEnum provider) {
        this.provider = provider;
    }

    public CreateTestDefinition reviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public CreateTestDefinition addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public CreateTestDefinition supportedDataTypes(List<SupportedDataTypesEnum> supportedDataTypes) {
        this.supportedDataTypes = supportedDataTypes;
        return this;
    }

    public CreateTestDefinition addSupportedDataTypesItem(SupportedDataTypesEnum supportedDataTypesItem) {
        if (this.supportedDataTypes == null) {
            this.supportedDataTypes = new ArrayList<SupportedDataTypesEnum>();
        }
        this.supportedDataTypes.add(supportedDataTypesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="supportedDataTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SupportedDataTypesEnum> getSupportedDataTypes() {
        return this.supportedDataTypes;
    }

    @JsonProperty(value="supportedDataTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupportedDataTypes(List<SupportedDataTypesEnum> supportedDataTypes) {
        this.supportedDataTypes = supportedDataTypes;
    }

    public CreateTestDefinition tags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public CreateTestDefinition addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateTestDefinition testPlatforms(List<TestPlatformsEnum> testPlatforms) {
        this.testPlatforms = testPlatforms;
        return this;
    }

    public CreateTestDefinition addTestPlatformsItem(TestPlatformsEnum testPlatformsItem) {
        if (this.testPlatforms == null) {
            this.testPlatforms = new ArrayList<TestPlatformsEnum>();
        }
        this.testPlatforms.add(testPlatformsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="testPlatforms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TestPlatformsEnum> getTestPlatforms() {
        return this.testPlatforms;
    }

    @JsonProperty(value="testPlatforms")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTestPlatforms(List<TestPlatformsEnum> testPlatforms) {
        this.testPlatforms = testPlatforms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTestDefinition createTestDefinition = (CreateTestDefinition)o;
        return Objects.equals(this.dataProducts, createTestDefinition.dataProducts) && Objects.equals(this.description, createTestDefinition.description) && Objects.equals(this.displayName, createTestDefinition.displayName) && Objects.equals(this.domain, createTestDefinition.domain) && Objects.equals((Object)this.entityType, (Object)createTestDefinition.entityType) && Objects.equals(this.extension, createTestDefinition.extension) && Objects.equals(this.lifeCycle, createTestDefinition.lifeCycle) && Objects.equals(this.name, createTestDefinition.name) && Objects.equals(this.owners, createTestDefinition.owners) && Objects.equals(this.parameterDefinition, createTestDefinition.parameterDefinition) && Objects.equals((Object)this.provider, (Object)createTestDefinition.provider) && Objects.equals(this.reviewers, createTestDefinition.reviewers) && Objects.equals(this.supportedDataTypes, createTestDefinition.supportedDataTypes) && Objects.equals(this.tags, createTestDefinition.tags) && Objects.equals(this.testPlatforms, createTestDefinition.testPlatforms);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataProducts, this.description, this.displayName, this.domain, this.entityType, this.extension, this.lifeCycle, this.name, this.owners, this.parameterDefinition, this.provider, this.reviewers, this.supportedDataTypes, this.tags, this.testPlatforms});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTestDefinition {\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString((Object)this.entityType)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    parameterDefinition: ").append(this.toIndentedString(this.parameterDefinition)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("    supportedDataTypes: ").append(this.toIndentedString(this.supportedDataTypes)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    testPlatforms: ").append(this.toIndentedString(this.testPlatforms)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EntityTypeEnum {
        TABLE("TABLE"),
        COLUMN("COLUMN");

        private String value;

        private EntityTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EntityTypeEnum fromValue(String value) {
            for (EntityTypeEnum b : EntityTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ProviderEnum {
        SYSTEM("system"),
        USER("user");

        private String value;

        private ProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProviderEnum fromValue(String value) {
            for (ProviderEnum b : ProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TestPlatformsEnum {
        OPENMETADATA("OpenMetadata"),
        GREATEXPECTATIONS("GreatExpectations"),
        DBT("DBT"),
        DEEQU("Deequ"),
        SODA("Soda"),
        OTHER("Other");

        private String value;

        private TestPlatformsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TestPlatformsEnum fromValue(String value) {
            for (TestPlatformsEnum b : TestPlatformsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SupportedDataTypesEnum {
        NUMBER("NUMBER"),
        TINYINT("TINYINT"),
        SMALLINT("SMALLINT"),
        INT("INT"),
        BIGINT("BIGINT"),
        BYTEINT("BYTEINT"),
        BYTES("BYTES"),
        FLOAT("FLOAT"),
        DOUBLE("DOUBLE"),
        DECIMAL("DECIMAL"),
        NUMERIC("NUMERIC"),
        TIMESTAMP("TIMESTAMP"),
        TIMESTAMPZ("TIMESTAMPZ"),
        TIME("TIME"),
        DATE("DATE"),
        DATETIME("DATETIME"),
        INTERVAL("INTERVAL"),
        STRING("STRING"),
        MEDIUMTEXT("MEDIUMTEXT"),
        TEXT("TEXT"),
        CHAR("CHAR"),
        LONG("LONG"),
        VARCHAR("VARCHAR"),
        BOOLEAN("BOOLEAN"),
        BINARY("BINARY"),
        VARBINARY("VARBINARY"),
        ARRAY("ARRAY"),
        BLOB("BLOB"),
        LONGBLOB("LONGBLOB"),
        MEDIUMBLOB("MEDIUMBLOB"),
        MAP("MAP"),
        STRUCT("STRUCT"),
        UNION("UNION"),
        SET("SET"),
        GEOGRAPHY("GEOGRAPHY"),
        ENUM("ENUM"),
        JSON("JSON"),
        UUID("UUID"),
        VARIANT("VARIANT"),
        GEOMETRY("GEOMETRY"),
        BYTEA("BYTEA"),
        AGGREGATEFUNCTION("AGGREGATEFUNCTION"),
        ERROR("ERROR"),
        FIXED("FIXED"),
        RECORD("RECORD"),
        NULL("NULL"),
        SUPER("SUPER"),
        HLLSKETCH("HLLSKETCH"),
        PG_LSN("PG_LSN"),
        PG_SNAPSHOT("PG_SNAPSHOT"),
        TSQUERY("TSQUERY"),
        TXID_SNAPSHOT("TXID_SNAPSHOT"),
        XML("XML"),
        MACADDR("MACADDR"),
        TSVECTOR("TSVECTOR"),
        UNKNOWN("UNKNOWN"),
        CIDR("CIDR"),
        INET("INET"),
        CLOB("CLOB"),
        ROWID("ROWID"),
        LOWCARDINALITY("LOWCARDINALITY"),
        YEAR("YEAR"),
        POINT("POINT"),
        POLYGON("POLYGON"),
        TUPLE("TUPLE"),
        SPATIAL("SPATIAL"),
        TABLE("TABLE"),
        NTEXT("NTEXT"),
        IMAGE("IMAGE"),
        IPV4("IPV4"),
        IPV6("IPV6"),
        DATETIMERANGE("DATETIMERANGE"),
        HLL("HLL"),
        LARGEINT("LARGEINT"),
        QUANTILE_STATE("QUANTILE_STATE"),
        AGG_STATE("AGG_STATE"),
        BITMAP("BITMAP"),
        UINT("UINT"),
        BIT("BIT"),
        MONEY("MONEY"),
        MEASURE_HIDDEN("MEASURE HIDDEN"),
        MEASURE_VISIBLE("MEASURE VISIBLE");

        private String value;

        private SupportedDataTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SupportedDataTypesEnum fromValue(String value) {
            for (SupportedDataTypesEnum b : SupportedDataTypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

