/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.TagLabel;

@JsonPropertyOrder(value={"dataSource", "dataType", "description", "fullyQualifiedName", "name", "tags"})
public class MlFeatureSource {
    public static final String JSON_PROPERTY_DATA_SOURCE = "dataSource";
    private EntityReference dataSource;
    public static final String JSON_PROPERTY_DATA_TYPE = "dataType";
    private DataTypeEnum dataType;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
    private String fullyQualifiedName;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<TagLabel> tags;

    public MlFeatureSource dataSource(EntityReference dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    @Nullable
    @JsonProperty(value="dataSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getDataSource() {
        return this.dataSource;
    }

    @JsonProperty(value="dataSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataSource(EntityReference dataSource) {
        this.dataSource = dataSource;
    }

    public MlFeatureSource dataType(DataTypeEnum dataType) {
        this.dataType = dataType;
        return this;
    }

    @Nullable
    @JsonProperty(value="dataType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DataTypeEnum getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="dataType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataType(DataTypeEnum dataType) {
        this.dataType = dataType;
    }

    public MlFeatureSource description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public MlFeatureSource fullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Nullable
    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public MlFeatureSource name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public MlFeatureSource tags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public MlFeatureSource addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MlFeatureSource mlFeatureSource = (MlFeatureSource)o;
        return Objects.equals(this.dataSource, mlFeatureSource.dataSource) && Objects.equals((Object)this.dataType, (Object)mlFeatureSource.dataType) && Objects.equals(this.description, mlFeatureSource.description) && Objects.equals(this.fullyQualifiedName, mlFeatureSource.fullyQualifiedName) && Objects.equals(this.name, mlFeatureSource.name) && Objects.equals(this.tags, mlFeatureSource.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataSource, this.dataType, this.description, this.fullyQualifiedName, this.name, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MlFeatureSource {\n");
        sb.append("    dataSource: ").append(this.toIndentedString(this.dataSource)).append("\n");
        sb.append("    dataType: ").append(this.toIndentedString((Object)this.dataType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    fullyQualifiedName: ").append(this.toIndentedString(this.fullyQualifiedName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DataTypeEnum {
        INTEGER("integer"),
        NUMBER("number"),
        STRING("string"),
        ARRAY("array"),
        DATE("date"),
        TIMESTAMP("timestamp"),
        OBJECT("object"),
        BOOLEAN("boolean");

        private String value;

        private DataTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DataTypeEnum fromValue(String value) {
            for (DataTypeEnum b : DataTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

