/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"endedAt", "name", "startedAt", "tasks", "variables"})
public class Stage {
    public static final String JSON_PROPERTY_ENDED_AT = "endedAt";
    private Long endedAt;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_STARTED_AT = "startedAt";
    private Long startedAt;
    public static final String JSON_PROPERTY_TASKS = "tasks";
    private List<UUID> tasks;
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    private Map<String, Object> variables = new HashMap<String, Object>();

    public Stage endedAt(Long endedAt) {
        this.endedAt = endedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="endedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getEndedAt() {
        return this.endedAt;
    }

    @JsonProperty(value="endedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndedAt(Long endedAt) {
        this.endedAt = endedAt;
    }

    public Stage name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public Stage startedAt(Long startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="startedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getStartedAt() {
        return this.startedAt;
    }

    @JsonProperty(value="startedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartedAt(Long startedAt) {
        this.startedAt = startedAt;
    }

    public Stage tasks(List<UUID> tasks) {
        this.tasks = tasks;
        return this;
    }

    public Stage addTasksItem(UUID tasksItem) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<UUID>();
        }
        this.tasks.add(tasksItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tasks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UUID> getTasks() {
        return this.tasks;
    }

    @JsonProperty(value="tasks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTasks(List<UUID> tasks) {
        this.tasks = tasks;
    }

    public Stage variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public Stage putVariablesItem(String key, Object variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stage stage = (Stage)o;
        return Objects.equals(this.endedAt, stage.endedAt) && Objects.equals(this.name, stage.name) && Objects.equals(this.startedAt, stage.startedAt) && Objects.equals(this.tasks, stage.tasks) && Objects.equals(this.variables, stage.variables);
    }

    public int hashCode() {
        return Objects.hash(this.endedAt, this.name, this.startedAt, this.tasks, this.variables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Stage {\n");
        sb.append("    endedAt: ").append(this.toIndentedString(this.endedAt)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    tasks: ").append(this.toIndentedString(this.tasks)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

