/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.TestResultValue;

@JsonPropertyOrder(value={"failedRows", "failedRowsPercentage", "id", "incidentId", "maxBound", "minBound", "passedRows", "passedRowsPercentage", "result", "sampleData", "testCase", "testCaseFQN", "testCaseStatus", "testDefinition", "testResultValue", "timestamp"})
public class TestCaseResult {
    public static final String JSON_PROPERTY_FAILED_ROWS = "failedRows";
    private Integer failedRows;
    public static final String JSON_PROPERTY_FAILED_ROWS_PERCENTAGE = "failedRowsPercentage";
    private Double failedRowsPercentage;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_INCIDENT_ID = "incidentId";
    private UUID incidentId;
    public static final String JSON_PROPERTY_MAX_BOUND = "maxBound";
    private Double maxBound;
    public static final String JSON_PROPERTY_MIN_BOUND = "minBound";
    private Double minBound;
    public static final String JSON_PROPERTY_PASSED_ROWS = "passedRows";
    private Integer passedRows;
    public static final String JSON_PROPERTY_PASSED_ROWS_PERCENTAGE = "passedRowsPercentage";
    private Double passedRowsPercentage;
    public static final String JSON_PROPERTY_RESULT = "result";
    private String result;
    public static final String JSON_PROPERTY_SAMPLE_DATA = "sampleData";
    private String sampleData;
    public static final String JSON_PROPERTY_TEST_CASE = "testCase";
    private EntityReference testCase;
    public static final String JSON_PROPERTY_TEST_CASE_F_Q_N = "testCaseFQN";
    private String testCaseFQN;
    public static final String JSON_PROPERTY_TEST_CASE_STATUS = "testCaseStatus";
    private TestCaseStatusEnum testCaseStatus;
    public static final String JSON_PROPERTY_TEST_DEFINITION = "testDefinition";
    private EntityReference testDefinition;
    public static final String JSON_PROPERTY_TEST_RESULT_VALUE = "testResultValue";
    private List<TestResultValue> testResultValue;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private Long timestamp;

    public TestCaseResult failedRows(Integer failedRows) {
        this.failedRows = failedRows;
        return this;
    }

    @Nullable
    @JsonProperty(value="failedRows")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFailedRows() {
        return this.failedRows;
    }

    @JsonProperty(value="failedRows")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailedRows(Integer failedRows) {
        this.failedRows = failedRows;
    }

    public TestCaseResult failedRowsPercentage(Double failedRowsPercentage) {
        this.failedRowsPercentage = failedRowsPercentage;
        return this;
    }

    @Nullable
    @JsonProperty(value="failedRowsPercentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getFailedRowsPercentage() {
        return this.failedRowsPercentage;
    }

    @JsonProperty(value="failedRowsPercentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailedRowsPercentage(Double failedRowsPercentage) {
        this.failedRowsPercentage = failedRowsPercentage;
    }

    public TestCaseResult id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(UUID id) {
        this.id = id;
    }

    public TestCaseResult incidentId(UUID incidentId) {
        this.incidentId = incidentId;
        return this;
    }

    @Nullable
    @JsonProperty(value="incidentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIncidentId() {
        return this.incidentId;
    }

    @JsonProperty(value="incidentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncidentId(UUID incidentId) {
        this.incidentId = incidentId;
    }

    public TestCaseResult maxBound(Double maxBound) {
        this.maxBound = maxBound;
        return this;
    }

    @Nullable
    @JsonProperty(value="maxBound")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getMaxBound() {
        return this.maxBound;
    }

    @JsonProperty(value="maxBound")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxBound(Double maxBound) {
        this.maxBound = maxBound;
    }

    public TestCaseResult minBound(Double minBound) {
        this.minBound = minBound;
        return this;
    }

    @Nullable
    @JsonProperty(value="minBound")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getMinBound() {
        return this.minBound;
    }

    @JsonProperty(value="minBound")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinBound(Double minBound) {
        this.minBound = minBound;
    }

    public TestCaseResult passedRows(Integer passedRows) {
        this.passedRows = passedRows;
        return this;
    }

    @Nullable
    @JsonProperty(value="passedRows")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPassedRows() {
        return this.passedRows;
    }

    @JsonProperty(value="passedRows")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassedRows(Integer passedRows) {
        this.passedRows = passedRows;
    }

    public TestCaseResult passedRowsPercentage(Double passedRowsPercentage) {
        this.passedRowsPercentage = passedRowsPercentage;
        return this;
    }

    @Nullable
    @JsonProperty(value="passedRowsPercentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getPassedRowsPercentage() {
        return this.passedRowsPercentage;
    }

    @JsonProperty(value="passedRowsPercentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassedRowsPercentage(Double passedRowsPercentage) {
        this.passedRowsPercentage = passedRowsPercentage;
    }

    public TestCaseResult result(String result) {
        this.result = result;
        return this;
    }

    @Nullable
    @JsonProperty(value="result")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResult() {
        return this.result;
    }

    @JsonProperty(value="result")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResult(String result) {
        this.result = result;
    }

    public TestCaseResult sampleData(String sampleData) {
        this.sampleData = sampleData;
        return this;
    }

    @Nullable
    @JsonProperty(value="sampleData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSampleData() {
        return this.sampleData;
    }

    @JsonProperty(value="sampleData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSampleData(String sampleData) {
        this.sampleData = sampleData;
    }

    public TestCaseResult testCase(EntityReference testCase) {
        this.testCase = testCase;
        return this;
    }

    @Nullable
    @JsonProperty(value="testCase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getTestCase() {
        return this.testCase;
    }

    @JsonProperty(value="testCase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestCase(EntityReference testCase) {
        this.testCase = testCase;
    }

    public TestCaseResult testCaseFQN(String testCaseFQN) {
        this.testCaseFQN = testCaseFQN;
        return this;
    }

    @Nullable
    @JsonProperty(value="testCaseFQN")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTestCaseFQN() {
        return this.testCaseFQN;
    }

    @JsonProperty(value="testCaseFQN")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestCaseFQN(String testCaseFQN) {
        this.testCaseFQN = testCaseFQN;
    }

    public TestCaseResult testCaseStatus(TestCaseStatusEnum testCaseStatus) {
        this.testCaseStatus = testCaseStatus;
        return this;
    }

    @Nullable
    @JsonProperty(value="testCaseStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TestCaseStatusEnum getTestCaseStatus() {
        return this.testCaseStatus;
    }

    @JsonProperty(value="testCaseStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestCaseStatus(TestCaseStatusEnum testCaseStatus) {
        this.testCaseStatus = testCaseStatus;
    }

    public TestCaseResult testDefinition(EntityReference testDefinition) {
        this.testDefinition = testDefinition;
        return this;
    }

    @Nullable
    @JsonProperty(value="testDefinition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getTestDefinition() {
        return this.testDefinition;
    }

    @JsonProperty(value="testDefinition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestDefinition(EntityReference testDefinition) {
        this.testDefinition = testDefinition;
    }

    public TestCaseResult testResultValue(List<TestResultValue> testResultValue) {
        this.testResultValue = testResultValue;
        return this;
    }

    public TestCaseResult addTestResultValueItem(TestResultValue testResultValueItem) {
        if (this.testResultValue == null) {
            this.testResultValue = new ArrayList<TestResultValue>();
        }
        this.testResultValue.add(testResultValueItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="testResultValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TestResultValue> getTestResultValue() {
        return this.testResultValue;
    }

    @JsonProperty(value="testResultValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestResultValue(List<TestResultValue> testResultValue) {
        this.testResultValue = testResultValue;
    }

    public TestCaseResult timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nonnull
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestCaseResult testCaseResult = (TestCaseResult)o;
        return Objects.equals(this.failedRows, testCaseResult.failedRows) && Objects.equals(this.failedRowsPercentage, testCaseResult.failedRowsPercentage) && Objects.equals(this.id, testCaseResult.id) && Objects.equals(this.incidentId, testCaseResult.incidentId) && Objects.equals(this.maxBound, testCaseResult.maxBound) && Objects.equals(this.minBound, testCaseResult.minBound) && Objects.equals(this.passedRows, testCaseResult.passedRows) && Objects.equals(this.passedRowsPercentage, testCaseResult.passedRowsPercentage) && Objects.equals(this.result, testCaseResult.result) && Objects.equals(this.sampleData, testCaseResult.sampleData) && Objects.equals(this.testCase, testCaseResult.testCase) && Objects.equals(this.testCaseFQN, testCaseResult.testCaseFQN) && Objects.equals((Object)this.testCaseStatus, (Object)testCaseResult.testCaseStatus) && Objects.equals(this.testDefinition, testCaseResult.testDefinition) && Objects.equals(this.testResultValue, testCaseResult.testResultValue) && Objects.equals(this.timestamp, testCaseResult.timestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.failedRows, this.failedRowsPercentage, this.id, this.incidentId, this.maxBound, this.minBound, this.passedRows, this.passedRowsPercentage, this.result, this.sampleData, this.testCase, this.testCaseFQN, this.testCaseStatus, this.testDefinition, this.testResultValue, this.timestamp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestCaseResult {\n");
        sb.append("    failedRows: ").append(this.toIndentedString(this.failedRows)).append("\n");
        sb.append("    failedRowsPercentage: ").append(this.toIndentedString(this.failedRowsPercentage)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    incidentId: ").append(this.toIndentedString(this.incidentId)).append("\n");
        sb.append("    maxBound: ").append(this.toIndentedString(this.maxBound)).append("\n");
        sb.append("    minBound: ").append(this.toIndentedString(this.minBound)).append("\n");
        sb.append("    passedRows: ").append(this.toIndentedString(this.passedRows)).append("\n");
        sb.append("    passedRowsPercentage: ").append(this.toIndentedString(this.passedRowsPercentage)).append("\n");
        sb.append("    result: ").append(this.toIndentedString(this.result)).append("\n");
        sb.append("    sampleData: ").append(this.toIndentedString(this.sampleData)).append("\n");
        sb.append("    testCase: ").append(this.toIndentedString(this.testCase)).append("\n");
        sb.append("    testCaseFQN: ").append(this.toIndentedString(this.testCaseFQN)).append("\n");
        sb.append("    testCaseStatus: ").append(this.toIndentedString((Object)this.testCaseStatus)).append("\n");
        sb.append("    testDefinition: ").append(this.toIndentedString(this.testDefinition)).append("\n");
        sb.append("    testResultValue: ").append(this.toIndentedString(this.testResultValue)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TestCaseStatusEnum {
        SUCCESS("Success"),
        FAILED("Failed"),
        ABORTED("Aborted"),
        QUEUED("Queued");

        private String value;

        private TestCaseStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TestCaseStatusEnum fromValue(String value) {
            for (TestCaseStatusEnum b : TestCaseStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

