/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"endedAt", "exception", "id", "startedAt", "status", "timestamp", "variables", "workflowDefinitionId"})
public class WorkflowInstance {
    public static final String JSON_PROPERTY_ENDED_AT = "endedAt";
    private Long endedAt;
    public static final String JSON_PROPERTY_EXCEPTION = "exception";
    private String exception;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_STARTED_AT = "startedAt";
    private Long startedAt;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private Long timestamp;
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    private Map<String, Object> variables = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_WORKFLOW_DEFINITION_ID = "workflowDefinitionId";
    private UUID workflowDefinitionId;

    public WorkflowInstance endedAt(Long endedAt) {
        this.endedAt = endedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="endedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getEndedAt() {
        return this.endedAt;
    }

    @JsonProperty(value="endedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndedAt(Long endedAt) {
        this.endedAt = endedAt;
    }

    public WorkflowInstance exception(String exception) {
        this.exception = exception;
        return this;
    }

    @Nullable
    @JsonProperty(value="exception")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getException() {
        return this.exception;
    }

    @JsonProperty(value="exception")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setException(String exception) {
        this.exception = exception;
    }

    public WorkflowInstance id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(UUID id) {
        this.id = id;
    }

    public WorkflowInstance startedAt(Long startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="startedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getStartedAt() {
        return this.startedAt;
    }

    @JsonProperty(value="startedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartedAt(Long startedAt) {
        this.startedAt = startedAt;
    }

    public WorkflowInstance status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public WorkflowInstance timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public WorkflowInstance variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public WorkflowInstance putVariablesItem(String key, Object variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public WorkflowInstance workflowDefinitionId(UUID workflowDefinitionId) {
        this.workflowDefinitionId = workflowDefinitionId;
        return this;
    }

    @Nullable
    @JsonProperty(value="workflowDefinitionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getWorkflowDefinitionId() {
        return this.workflowDefinitionId;
    }

    @JsonProperty(value="workflowDefinitionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWorkflowDefinitionId(UUID workflowDefinitionId) {
        this.workflowDefinitionId = workflowDefinitionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowInstance workflowInstance = (WorkflowInstance)o;
        return Objects.equals(this.endedAt, workflowInstance.endedAt) && Objects.equals(this.exception, workflowInstance.exception) && Objects.equals(this.id, workflowInstance.id) && Objects.equals(this.startedAt, workflowInstance.startedAt) && Objects.equals((Object)this.status, (Object)workflowInstance.status) && Objects.equals(this.timestamp, workflowInstance.timestamp) && Objects.equals(this.variables, workflowInstance.variables) && Objects.equals(this.workflowDefinitionId, workflowInstance.workflowDefinitionId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.endedAt, this.exception, this.id, this.startedAt, this.status, this.timestamp, this.variables, this.workflowDefinitionId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowInstance {\n");
        sb.append("    endedAt: ").append(this.toIndentedString(this.endedAt)).append("\n");
        sb.append("    exception: ").append(this.toIndentedString(this.exception)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    workflowDefinitionId: ").append(this.toIndentedString(this.workflowDefinitionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        RUNNING("RUNNING"),
        FINISHED("FINISHED"),
        FAILURE("FAILURE"),
        EXCEPTION("EXCEPTION");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

