/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.Chart;
import org.openmetadata.client.model.ChartList;
import org.openmetadata.client.model.CreateChart;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;

public interface ChartsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/charts/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void addFollowerToChart(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="PUT /v1/charts/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> addFollowerToChartWithHttpInfo(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="POST /v1/charts")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Chart createChart(CreateChart var1);

    @RequestLine(value="POST /v1/charts")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Chart> createChartWithHttpInfo(CreateChart var1);

    @RequestLine(value="PUT /v1/charts")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Chart createOrUpdateChart(CreateChart var1);

    @RequestLine(value="PUT /v1/charts")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Chart> createOrUpdateChartWithHttpInfo(CreateChart var1);

    @RequestLine(value="DELETE /v1/charts/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteChart(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/charts/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteChartWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/charts/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteChart(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteChartQueryParams var2);

    @RequestLine(value="DELETE /v1/charts/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteChartWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteChartQueryParams var2);

    @RequestLine(value="DELETE /v1/charts/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteChartAsync(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/charts/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteChartAsyncWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/charts/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteChartAsync(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteChartAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/charts/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteChartAsyncWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteChartAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/charts/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteChartByFQN(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/charts/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteChartByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/charts/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteChartByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteChartByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/charts/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteChartByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteChartByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/charts/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public void deleteFollowerFromChart(@Param(value="id") UUID var1, @Param(value="userId") UUID var2);

    @RequestLine(value="DELETE /v1/charts/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteFollowerFromChartWithHttpInfo(@Param(value="id") UUID var1, @Param(value="userId") UUID var2);

    @RequestLine(value="GET /v1/charts/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Chart getChartByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/charts/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Chart> getChartByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/charts/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Chart getChartByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetChartByFQNQueryParams var2);

    @RequestLine(value="GET /v1/charts/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Chart> getChartByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetChartByFQNQueryParams var2);

    @RequestLine(value="GET /v1/charts/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Chart getChartByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/charts/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Chart> getChartByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/charts/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Chart getChartByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetChartByIDQueryParams var2);

    @RequestLine(value="GET /v1/charts/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Chart> getChartByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetChartByIDQueryParams var2);

    @RequestLine(value="GET /v1/charts/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Chart getSpecificChartVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/charts/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Chart> getSpecificChartVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/charts/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllChartVersions(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/charts/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllChartVersionsWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/charts?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ChartList listCharts(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/charts?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChartList> listChartsWithHttpInfo(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/charts?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ChartList listCharts(@QueryMap(encoded=true) ListChartsQueryParams var1);

    @RequestLine(value="GET /v1/charts?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChartList> listChartsWithHttpInfo(@QueryMap(encoded=true) ListChartsQueryParams var1);

    @RequestLine(value="PATCH /v1/charts/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchChart(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/charts/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchChartWithHttpInfo(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/charts/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchChart1(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/charts/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchChart1WithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/charts/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Chart restore5(RestoreEntity var1);

    @RequestLine(value="PUT /v1/charts/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Chart> restore5WithHttpInfo(RestoreEntity var1);

    @RequestLine(value="PUT /v1/charts/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity(@Param(value="id") UUID var1, VoteRequest var2);

    @RequestLine(value="PUT /v1/charts/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntityWithHttpInfo(@Param(value="id") UUID var1, VoteRequest var2);

    public static class ListChartsQueryParams
    extends HashMap<String, Object> {
        public ListChartsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListChartsQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListChartsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListChartsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListChartsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListChartsQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetChartByIDQueryParams
    extends HashMap<String, Object> {
        public GetChartByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetChartByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetChartByFQNQueryParams
    extends HashMap<String, Object> {
        public GetChartByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetChartByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteChartByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteChartByFQNQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteChartAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteChartAsyncQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteChartQueryParams
    extends HashMap<String, Object> {
        public DeleteChartQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

