/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.Container;
import org.openmetadata.client.model.ContainerList;
import org.openmetadata.client.model.CreateContainer;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;

public interface ContainersApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/containers/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower7(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="PUT /v1/containers/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollower7WithHttpInfo(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="POST /v1/containers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Container createContainer(CreateContainer var1);

    @RequestLine(value="POST /v1/containers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Container> createContainerWithHttpInfo(CreateContainer var1);

    @RequestLine(value="PUT /v1/containers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Container createOrUpdateContainer(CreateContainer var1);

    @RequestLine(value="PUT /v1/containers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Container> createOrUpdateContainerWithHttpInfo(CreateContainer var1);

    @RequestLine(value="DELETE /v1/containers/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteContainer(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/containers/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteContainerWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/containers/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteContainer(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteContainerQueryParams var2);

    @RequestLine(value="DELETE /v1/containers/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteContainerWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteContainerQueryParams var2);

    @RequestLine(value="DELETE /v1/containers/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteContainerAsync(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/containers/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteContainerAsyncWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/containers/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteContainerAsync(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteContainerAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/containers/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteContainerAsyncWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteContainerAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/containers/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteContainerByFQN(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/containers/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteContainerByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/containers/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteContainerByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteContainerByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/containers/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteContainerByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteContainerByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/containers/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower20(@Param(value="id") String var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/containers/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower20WithHttpInfo(@Param(value="id") String var1, @Param(value="userId") String var2);

    @RequestLine(value="GET /v1/containers/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Container getContainerByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/containers/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Container> getContainerByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/containers/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Container getContainerByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetContainerByFQNQueryParams var2);

    @RequestLine(value="GET /v1/containers/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Container> getContainerByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetContainerByFQNQueryParams var2);

    @RequestLine(value="GET /v1/containers/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Container getContainerByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/containers/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Container> getContainerByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/containers/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Container getContainerByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetContainerByIDQueryParams var2);

    @RequestLine(value="GET /v1/containers/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Container> getContainerByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetContainerByIDQueryParams var2);

    @RequestLine(value="GET /v1/containers/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Container getSpecificContainerVersion(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/containers/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Container> getSpecificContainerVersionWithHttpInfo(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/containers/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllContainerVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/containers/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllContainerVersionWithHttpInfo(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/containers/name/{fqn}/children?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public ContainerList listContainerChildren(@Param(value="fqn") String var1, @Param(value="limit") Integer var2, @Param(value="offset") Integer var3);

    @RequestLine(value="GET /v1/containers/name/{fqn}/children?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ContainerList> listContainerChildrenWithHttpInfo(@Param(value="fqn") String var1, @Param(value="limit") Integer var2, @Param(value="offset") Integer var3);

    @RequestLine(value="GET /v1/containers/name/{fqn}/children?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public ContainerList listContainerChildren(@Param(value="fqn") String var1, @QueryMap(encoded=true) ListContainerChildrenQueryParams var2);

    @RequestLine(value="GET /v1/containers/name/{fqn}/children?limit={limit}&offset={offset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ContainerList> listContainerChildrenWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) ListContainerChildrenQueryParams var2);

    @RequestLine(value="GET /v1/containers?fields={fields}&service={service}&root={root}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ContainerList listContainers(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="root") Boolean var3, @Param(value="limit") Integer var4, @Param(value="before") String var5, @Param(value="after") String var6, @Param(value="include") String var7);

    @RequestLine(value="GET /v1/containers?fields={fields}&service={service}&root={root}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ContainerList> listContainersWithHttpInfo(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="root") Boolean var3, @Param(value="limit") Integer var4, @Param(value="before") String var5, @Param(value="after") String var6, @Param(value="include") String var7);

    @RequestLine(value="GET /v1/containers?fields={fields}&service={service}&root={root}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ContainerList listContainers(@QueryMap(encoded=true) ListContainersQueryParams var1);

    @RequestLine(value="GET /v1/containers?fields={fields}&service={service}&root={root}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ContainerList> listContainersWithHttpInfo(@QueryMap(encoded=true) ListContainersQueryParams var1);

    @RequestLine(value="PATCH /v1/containers/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchContainer(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/containers/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchContainerWithHttpInfo(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/containers/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchContainer1(@Param(value="id") String var1, Object var2);

    @RequestLine(value="PATCH /v1/containers/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchContainer1WithHttpInfo(@Param(value="id") String var1, Object var2);

    @RequestLine(value="PUT /v1/containers/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Container restore34(RestoreEntity var1);

    @RequestLine(value="PUT /v1/containers/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Container> restore34WithHttpInfo(RestoreEntity var1);

    @RequestLine(value="PUT /v1/containers/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity14(@Param(value="id") UUID var1, VoteRequest var2);

    @RequestLine(value="PUT /v1/containers/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity14WithHttpInfo(@Param(value="id") UUID var1, VoteRequest var2);

    public static class ListContainersQueryParams
    extends HashMap<String, Object> {
        public ListContainersQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListContainersQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListContainersQueryParams root(Boolean value) {
            this.put("root", EncodingUtils.encode(value));
            return this;
        }

        public ListContainersQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListContainersQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListContainersQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListContainersQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListContainerChildrenQueryParams
    extends HashMap<String, Object> {
        public ListContainerChildrenQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListContainerChildrenQueryParams offset(Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetContainerByIDQueryParams
    extends HashMap<String, Object> {
        public GetContainerByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetContainerByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetContainerByFQNQueryParams
    extends HashMap<String, Object> {
        public GetContainerByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetContainerByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteContainerByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteContainerByFQNQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteContainerAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteContainerAsyncQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteContainerAsyncQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteContainerQueryParams
    extends HashMap<String, Object> {
        public DeleteContainerQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteContainerQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }
}

