/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import feign.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;

public interface ElasticSearchApi
extends ApiClient.Api {
    @RequestLine(value="GET /v1/search/aggregate?index={index}&field={field}&size={size}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public Response getAggregateFields(@Param(value="index") String var1, @Param(value="field") String var2, @Param(value="size") Integer var3, @Param(value="deleted") String var4);

    @RequestLine(value="GET /v1/search/aggregate?index={index}&field={field}&size={size}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public Response getAggregateFieldsWithHttpInfo(@Param(value="index") String var1, @Param(value="field") String var2, @Param(value="size") Integer var3, @Param(value="deleted") String var4);

    @RequestLine(value="GET /v1/search/aggregate?index={index}&field={field}&size={size}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public Response getAggregateFields(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/search/aggregate?index={index}&field={field}&size={size}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public Response getAggregateFieldsWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/search/suggest?q={q}&index={index}&field={field}&size={size}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public Response getSuggestedEntities(@Param(value="q") String var1, @Param(value="index") String var2, @Param(value="field") String var3, @Param(value="size") Integer var4, @Param(value="fetchSource") Boolean var5, @Param(value="includeSourceFields") List<String> var6, @Param(value="deleted") String var7);

    @RequestLine(value="GET /v1/search/suggest?q={q}&index={index}&field={field}&size={size}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public Response getSuggestedEntitiesWithHttpInfo(@Param(value="q") String var1, @Param(value="index") String var2, @Param(value="field") String var3, @Param(value="size") Integer var4, @Param(value="fetchSource") Boolean var5, @Param(value="includeSourceFields") List<String> var6, @Param(value="deleted") String var7);

    @RequestLine(value="GET /v1/search/suggest?q={q}&index={index}&field={field}&size={size}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public Response getSuggestedEntities(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/search/suggest?q={q}&index={index}&field={field}&size={size}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public Response getSuggestedEntitiesWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/search/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}")
    @Headers(value={"Accept: application/json"})
    public Response searchEntitiesWithQuery(@Param(value="q") String var1, @Param(value="index") String var2, @Param(value="deleted") Boolean var3, @Param(value="from") Integer var4, @Param(value="size") Integer var5, @Param(value="sortField") String var6, @Param(value="sortOrder") String var7, @Param(value="trackTotalHits") Boolean var8, @Param(value="queryFilter") String var9, @Param(value="postFilter") String var10, @Param(value="fetchSource") Boolean var11, @Param(value="includeSourceFields") List<String> var12);

    @RequestLine(value="GET /v1/search/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}")
    @Headers(value={"Accept: application/json"})
    public Response searchEntitiesWithQueryWithHttpInfo(@Param(value="q") String var1, @Param(value="index") String var2, @Param(value="deleted") Boolean var3, @Param(value="from") Integer var4, @Param(value="size") Integer var5, @Param(value="sortField") String var6, @Param(value="sortOrder") String var7, @Param(value="trackTotalHits") Boolean var8, @Param(value="queryFilter") String var9, @Param(value="postFilter") String var10, @Param(value="fetchSource") Boolean var11, @Param(value="includeSourceFields") List<String> var12);

    @RequestLine(value="GET /v1/search/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}")
    @Headers(value={"Accept: application/json"})
    public Response searchEntitiesWithQuery(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/search/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}")
    @Headers(value={"Accept: application/json"})
    public Response searchEntitiesWithQueryWithHttpInfo(@QueryMap(encoded=true) Map<String, Object> var1);

    public static class SearchEntitiesWithQueryQueryParams
    extends HashMap<String, Object> {
        public SearchEntitiesWithQueryQueryParams q(String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams index(String value) {
            this.put("index", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams deleted(Boolean value) {
            this.put("deleted", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams from(Integer value) {
            this.put("from", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams size(Integer value) {
            this.put("size", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams sortField(String value) {
            this.put("sort_field", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams sortOrder(String value) {
            this.put("sort_order", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams trackTotalHits(Boolean value) {
            this.put("track_total_hits", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams queryFilter(String value) {
            this.put("query_filter", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams postFilter(String value) {
            this.put("post_filter", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams fetchSource(Boolean value) {
            this.put("fetch_source", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams includeSourceFields(List<String> value) {
            this.put("include_source_fields", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }
    }

    public static class GetSuggestedEntitiesQueryParams
    extends HashMap<String, Object> {
        public GetSuggestedEntitiesQueryParams q(String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }

        public GetSuggestedEntitiesQueryParams index(String value) {
            this.put("index", EncodingUtils.encode(value));
            return this;
        }

        public GetSuggestedEntitiesQueryParams field(String value) {
            this.put("field", EncodingUtils.encode(value));
            return this;
        }

        public GetSuggestedEntitiesQueryParams size(Integer value) {
            this.put("size", EncodingUtils.encode(value));
            return this;
        }

        public GetSuggestedEntitiesQueryParams fetchSource(Boolean value) {
            this.put("fetch_source", EncodingUtils.encode(value));
            return this;
        }

        public GetSuggestedEntitiesQueryParams includeSourceFields(List<String> value) {
            this.put("include_source_fields", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public GetSuggestedEntitiesQueryParams deleted(String value) {
            this.put("deleted", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetAggregateFieldsQueryParams
    extends HashMap<String, Object> {
        public GetAggregateFieldsQueryParams index(String value) {
            this.put("index", EncodingUtils.encode(value));
            return this;
        }

        public GetAggregateFieldsQueryParams field(String value) {
            this.put("field", EncodingUtils.encode(value));
            return this;
        }

        public GetAggregateFieldsQueryParams size(Integer value) {
            this.put("size", EncodingUtils.encode(value));
            return this;
        }

        public GetAggregateFieldsQueryParams deleted(String value) {
            this.put("deleted", EncodingUtils.encode(value));
            return this;
        }
    }
}

