/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.AddLineage;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CSVExportMessage;
import org.openmetadata.client.model.EntityLineage;
import org.openmetadata.client.model.SearchResponse;

public interface LineageApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/lineage")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void addLineageEdge(AddLineage var1);

    @RequestLine(value="PUT /v1/lineage")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> addLineageEdgeWithHttpInfo(AddLineage var1);

    @RequestLine(value="DELETE /v1/lineage/{fromEntity}/{fromId}/{toEntity}/{toId}")
    @Headers(value={"Accept: application/json"})
    public void deleteLineageEdge(@Param(value="fromEntity") String var1, @Param(value="fromId") String var2, @Param(value="toEntity") String var3, @Param(value="toId") String var4);

    @RequestLine(value="DELETE /v1/lineage/{fromEntity}/{fromId}/{toEntity}/{toId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLineageEdgeWithHttpInfo(@Param(value="fromEntity") String var1, @Param(value="fromId") String var2, @Param(value="toEntity") String var3, @Param(value="toId") String var4);

    @RequestLine(value="DELETE /v1/lineage/{fromEntity}/name/{fromFQN}/{toEntity}/name/{toFQN}")
    @Headers(value={"Accept: application/json"})
    public void deleteLineageEdgeByName(@Param(value="fromEntity") String var1, @Param(value="fromFQN") String var2, @Param(value="toEntity") String var3, @Param(value="toFQN") String var4);

    @RequestLine(value="DELETE /v1/lineage/{fromEntity}/name/{fromFQN}/{toEntity}/name/{toFQN}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLineageEdgeByNameWithHttpInfo(@Param(value="fromEntity") String var1, @Param(value="fromFQN") String var2, @Param(value="toEntity") String var3, @Param(value="toFQN") String var4);

    @RequestLine(value="DELETE /v1/lineage/{entityType}/{entityId}/type/{lineageSource}")
    @Headers(value={"Accept: application/json"})
    public void deleteLineageEdgeByType(@Param(value="entityType") String var1, @Param(value="entityId") String var2, @Param(value="lineageSource") String var3);

    @RequestLine(value="DELETE /v1/lineage/{entityType}/{entityId}/type/{lineageSource}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteLineageEdgeByTypeWithHttpInfo(@Param(value="entityType") String var1, @Param(value="entityId") String var2, @Param(value="lineageSource") String var3);

    @RequestLine(value="GET /v1/lineage/export?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&type={type}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse exportLineage(@Param(value="fqn") String var1, @Param(value="upstreamDepth") Integer var2, @Param(value="downstreamDepth") Integer var3, @Param(value="queryFilter") String var4, @Param(value="includeDeleted") Boolean var5, @Param(value="type") String var6);

    @RequestLine(value="GET /v1/lineage/export?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&type={type}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> exportLineageWithHttpInfo(@Param(value="fqn") String var1, @Param(value="upstreamDepth") Integer var2, @Param(value="downstreamDepth") Integer var3, @Param(value="queryFilter") String var4, @Param(value="includeDeleted") Boolean var5, @Param(value="type") String var6);

    @RequestLine(value="GET /v1/lineage/export?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&type={type}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse exportLineage(@QueryMap(encoded=true) ExportLineageQueryParams var1);

    @RequestLine(value="GET /v1/lineage/export?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&type={type}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> exportLineageWithHttpInfo(@QueryMap(encoded=true) ExportLineageQueryParams var1);

    @RequestLine(value="GET /v1/lineage/exportAsync?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&type={type}")
    @Headers(value={"Accept: application/json"})
    public CSVExportMessage exportLineage1(@Param(value="fqn") String var1, @Param(value="upstreamDepth") Integer var2, @Param(value="downstreamDepth") Integer var3, @Param(value="queryFilter") String var4, @Param(value="includeDeleted") Boolean var5, @Param(value="type") String var6);

    @RequestLine(value="GET /v1/lineage/exportAsync?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&type={type}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CSVExportMessage> exportLineage1WithHttpInfo(@Param(value="fqn") String var1, @Param(value="upstreamDepth") Integer var2, @Param(value="downstreamDepth") Integer var3, @Param(value="queryFilter") String var4, @Param(value="includeDeleted") Boolean var5, @Param(value="type") String var6);

    @RequestLine(value="GET /v1/lineage/exportAsync?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&type={type}")
    @Headers(value={"Accept: application/json"})
    public CSVExportMessage exportLineage1(@QueryMap(encoded=true) ExportLineage1QueryParams var1);

    @RequestLine(value="GET /v1/lineage/exportAsync?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&type={type}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CSVExportMessage> exportLineage1WithHttpInfo(@QueryMap(encoded=true) ExportLineage1QueryParams var1);

    @RequestLine(value="GET /v1/lineage/{entity}/{id}?upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}")
    @Headers(value={"Accept: application/json"})
    public EntityLineage getLineage(@Param(value="entity") String var1, @Param(value="id") String var2, @Param(value="upstreamDepth") Integer var3, @Param(value="downstreamDepth") Integer var4);

    @RequestLine(value="GET /v1/lineage/{entity}/{id}?upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityLineage> getLineageWithHttpInfo(@Param(value="entity") String var1, @Param(value="id") String var2, @Param(value="upstreamDepth") Integer var3, @Param(value="downstreamDepth") Integer var4);

    @RequestLine(value="GET /v1/lineage/{entity}/{id}?upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}")
    @Headers(value={"Accept: application/json"})
    public EntityLineage getLineage(@Param(value="entity") String var1, @Param(value="id") String var2, @QueryMap(encoded=true) GetLineageQueryParams var3);

    @RequestLine(value="GET /v1/lineage/{entity}/{id}?upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityLineage> getLineageWithHttpInfo(@Param(value="entity") String var1, @Param(value="id") String var2, @QueryMap(encoded=true) GetLineageQueryParams var3);

    @RequestLine(value="GET /v1/lineage/{entity}/name/{fqn}?upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}")
    @Headers(value={"Accept: application/json"})
    public EntityLineage getLineageByFQN(@Param(value="entity") String var1, @Param(value="fqn") String var2, @Param(value="upstreamDepth") Integer var3, @Param(value="downstreamDepth") Integer var4);

    @RequestLine(value="GET /v1/lineage/{entity}/name/{fqn}?upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityLineage> getLineageByFQNWithHttpInfo(@Param(value="entity") String var1, @Param(value="fqn") String var2, @Param(value="upstreamDepth") Integer var3, @Param(value="downstreamDepth") Integer var4);

    @RequestLine(value="GET /v1/lineage/{entity}/name/{fqn}?upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}")
    @Headers(value={"Accept: application/json"})
    public EntityLineage getLineageByFQN(@Param(value="entity") String var1, @Param(value="fqn") String var2, @QueryMap(encoded=true) GetLineageByFQNQueryParams var3);

    @RequestLine(value="GET /v1/lineage/{entity}/name/{fqn}?upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityLineage> getLineageByFQNWithHttpInfo(@Param(value="entity") String var1, @Param(value="fqn") String var2, @QueryMap(encoded=true) GetLineageByFQNQueryParams var3);

    @RequestLine(value="GET /v1/lineage/getLineageEdge/{fromId}/{toId}")
    @Headers(value={"Accept: application/json"})
    public void getLineageEdge(@Param(value="fromId") String var1, @Param(value="toId") String var2);

    @RequestLine(value="GET /v1/lineage/getLineageEdge/{fromId}/{toId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getLineageEdgeWithHttpInfo(@Param(value="fromId") String var1, @Param(value="toId") String var2);

    @RequestLine(value="GET /v1/lineage/getPlatformLineage?view={view}&query_filter={queryFilter}&includeDeleted={includeDeleted}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse getPlatformLineage(@Param(value="view") String var1, @Param(value="queryFilter") String var2, @Param(value="includeDeleted") Boolean var3);

    @RequestLine(value="GET /v1/lineage/getPlatformLineage?view={view}&query_filter={queryFilter}&includeDeleted={includeDeleted}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> getPlatformLineageWithHttpInfo(@Param(value="view") String var1, @Param(value="queryFilter") String var2, @Param(value="includeDeleted") Boolean var3);

    @RequestLine(value="GET /v1/lineage/getPlatformLineage?view={view}&query_filter={queryFilter}&includeDeleted={includeDeleted}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse getPlatformLineage(@QueryMap(encoded=true) GetPlatformLineageQueryParams var1);

    @RequestLine(value="GET /v1/lineage/getPlatformLineage?view={view}&query_filter={queryFilter}&includeDeleted={includeDeleted}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> getPlatformLineageWithHttpInfo(@QueryMap(encoded=true) GetPlatformLineageQueryParams var1);

    @RequestLine(value="PATCH /v1/lineage/{fromEntity}/{fromId}/{toEntity}/{toId}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchLineageEdge(@Param(value="fromEntity") String var1, @Param(value="fromId") String var2, @Param(value="toEntity") String var3, @Param(value="toId") String var4, Object var5);

    @RequestLine(value="PATCH /v1/lineage/{fromEntity}/{fromId}/{toEntity}/{toId}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchLineageEdgeWithHttpInfo(@Param(value="fromEntity") String var1, @Param(value="fromId") String var2, @Param(value="toEntity") String var3, @Param(value="toId") String var4, Object var5);

    @RequestLine(value="GET /v1/lineage/getDataQualityLineage?fqn={fqn}&upstreamDepth={upstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchDataQualityLineage(@Param(value="fqn") String var1, @Param(value="upstreamDepth") Integer var2, @Param(value="queryFilter") String var3, @Param(value="includeDeleted") Boolean var4);

    @RequestLine(value="GET /v1/lineage/getDataQualityLineage?fqn={fqn}&upstreamDepth={upstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchDataQualityLineageWithHttpInfo(@Param(value="fqn") String var1, @Param(value="upstreamDepth") Integer var2, @Param(value="queryFilter") String var3, @Param(value="includeDeleted") Boolean var4);

    @RequestLine(value="GET /v1/lineage/getDataQualityLineage?fqn={fqn}&upstreamDepth={upstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchDataQualityLineage(@QueryMap(encoded=true) SearchDataQualityLineageQueryParams var1);

    @RequestLine(value="GET /v1/lineage/getDataQualityLineage?fqn={fqn}&upstreamDepth={upstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchDataQualityLineageWithHttpInfo(@QueryMap(encoded=true) SearchDataQualityLineageQueryParams var1);

    @RequestLine(value="GET /v1/lineage/getLineage?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&fields={fields}&type={type}&from={from}&size={size}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchLineage(@Param(value="fqn") String var1, @Param(value="upstreamDepth") Integer var2, @Param(value="downstreamDepth") Integer var3, @Param(value="queryFilter") String var4, @Param(value="includeDeleted") Boolean var5, @Param(value="fields") String var6, @Param(value="type") String var7, @Param(value="from") Integer var8, @Param(value="size") Integer var9);

    @RequestLine(value="GET /v1/lineage/getLineage?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&fields={fields}&type={type}&from={from}&size={size}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchLineageWithHttpInfo(@Param(value="fqn") String var1, @Param(value="upstreamDepth") Integer var2, @Param(value="downstreamDepth") Integer var3, @Param(value="queryFilter") String var4, @Param(value="includeDeleted") Boolean var5, @Param(value="fields") String var6, @Param(value="type") String var7, @Param(value="from") Integer var8, @Param(value="size") Integer var9);

    @RequestLine(value="GET /v1/lineage/getLineage?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&fields={fields}&type={type}&from={from}&size={size}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchLineage(@QueryMap(encoded=true) SearchLineageQueryParams var1);

    @RequestLine(value="GET /v1/lineage/getLineage?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&fields={fields}&type={type}&from={from}&size={size}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchLineageWithHttpInfo(@QueryMap(encoded=true) SearchLineageQueryParams var1);

    @RequestLine(value="GET /v1/lineage/getLineage/{direction}?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&fields={fields}&type={type}&from={from}&size={size}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchLineageWithDirection(@Param(value="direction") String var1, @Param(value="fqn") String var2, @Param(value="upstreamDepth") Integer var3, @Param(value="downstreamDepth") Integer var4, @Param(value="queryFilter") String var5, @Param(value="includeDeleted") Boolean var6, @Param(value="fields") String var7, @Param(value="type") String var8, @Param(value="from") Integer var9, @Param(value="size") Integer var10);

    @RequestLine(value="GET /v1/lineage/getLineage/{direction}?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&fields={fields}&type={type}&from={from}&size={size}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchLineageWithDirectionWithHttpInfo(@Param(value="direction") String var1, @Param(value="fqn") String var2, @Param(value="upstreamDepth") Integer var3, @Param(value="downstreamDepth") Integer var4, @Param(value="queryFilter") String var5, @Param(value="includeDeleted") Boolean var6, @Param(value="fields") String var7, @Param(value="type") String var8, @Param(value="from") Integer var9, @Param(value="size") Integer var10);

    @RequestLine(value="GET /v1/lineage/getLineage/{direction}?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&fields={fields}&type={type}&from={from}&size={size}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchLineageWithDirection(@Param(value="direction") String var1, @QueryMap(encoded=true) SearchLineageWithDirectionQueryParams var2);

    @RequestLine(value="GET /v1/lineage/getLineage/{direction}?fqn={fqn}&upstreamDepth={upstreamDepth}&downstreamDepth={downstreamDepth}&query_filter={queryFilter}&includeDeleted={includeDeleted}&fields={fields}&type={type}&from={from}&size={size}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchLineageWithDirectionWithHttpInfo(@Param(value="direction") String var1, @QueryMap(encoded=true) SearchLineageWithDirectionQueryParams var2);

    public static class SearchLineageWithDirectionQueryParams
    extends HashMap<String, Object> {
        public SearchLineageWithDirectionQueryParams fqn(String value) {
            this.put("fqn", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageWithDirectionQueryParams upstreamDepth(Integer value) {
            this.put("upstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageWithDirectionQueryParams downstreamDepth(Integer value) {
            this.put("downstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageWithDirectionQueryParams queryFilter(String value) {
            this.put("query_filter", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageWithDirectionQueryParams includeDeleted(Boolean value) {
            this.put("includeDeleted", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageWithDirectionQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageWithDirectionQueryParams type(String value) {
            this.put("type", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageWithDirectionQueryParams from(Integer value) {
            this.put("from", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageWithDirectionQueryParams size(Integer value) {
            this.put("size", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class SearchLineageQueryParams
    extends HashMap<String, Object> {
        public SearchLineageQueryParams fqn(String value) {
            this.put("fqn", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageQueryParams upstreamDepth(Integer value) {
            this.put("upstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageQueryParams downstreamDepth(Integer value) {
            this.put("downstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageQueryParams queryFilter(String value) {
            this.put("query_filter", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageQueryParams includeDeleted(Boolean value) {
            this.put("includeDeleted", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageQueryParams type(String value) {
            this.put("type", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageQueryParams from(Integer value) {
            this.put("from", EncodingUtils.encode(value));
            return this;
        }

        public SearchLineageQueryParams size(Integer value) {
            this.put("size", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class SearchDataQualityLineageQueryParams
    extends HashMap<String, Object> {
        public SearchDataQualityLineageQueryParams fqn(String value) {
            this.put("fqn", EncodingUtils.encode(value));
            return this;
        }

        public SearchDataQualityLineageQueryParams upstreamDepth(Integer value) {
            this.put("upstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public SearchDataQualityLineageQueryParams queryFilter(String value) {
            this.put("query_filter", EncodingUtils.encode(value));
            return this;
        }

        public SearchDataQualityLineageQueryParams includeDeleted(Boolean value) {
            this.put("includeDeleted", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPlatformLineageQueryParams
    extends HashMap<String, Object> {
        public GetPlatformLineageQueryParams view(String value) {
            this.put("view", EncodingUtils.encode(value));
            return this;
        }

        public GetPlatformLineageQueryParams queryFilter(String value) {
            this.put("query_filter", EncodingUtils.encode(value));
            return this;
        }

        public GetPlatformLineageQueryParams includeDeleted(Boolean value) {
            this.put("includeDeleted", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetLineageByFQNQueryParams
    extends HashMap<String, Object> {
        public GetLineageByFQNQueryParams upstreamDepth(Integer value) {
            this.put("upstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public GetLineageByFQNQueryParams downstreamDepth(Integer value) {
            this.put("downstreamDepth", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetLineageQueryParams
    extends HashMap<String, Object> {
        public GetLineageQueryParams upstreamDepth(Integer value) {
            this.put("upstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public GetLineageQueryParams downstreamDepth(Integer value) {
            this.put("downstreamDepth", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ExportLineage1QueryParams
    extends HashMap<String, Object> {
        public ExportLineage1QueryParams fqn(String value) {
            this.put("fqn", EncodingUtils.encode(value));
            return this;
        }

        public ExportLineage1QueryParams upstreamDepth(Integer value) {
            this.put("upstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public ExportLineage1QueryParams downstreamDepth(Integer value) {
            this.put("downstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public ExportLineage1QueryParams queryFilter(String value) {
            this.put("query_filter", EncodingUtils.encode(value));
            return this;
        }

        public ExportLineage1QueryParams includeDeleted(Boolean value) {
            this.put("includeDeleted", EncodingUtils.encode(value));
            return this;
        }

        public ExportLineage1QueryParams type(String value) {
            this.put("type", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ExportLineageQueryParams
    extends HashMap<String, Object> {
        public ExportLineageQueryParams fqn(String value) {
            this.put("fqn", EncodingUtils.encode(value));
            return this;
        }

        public ExportLineageQueryParams upstreamDepth(Integer value) {
            this.put("upstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public ExportLineageQueryParams downstreamDepth(Integer value) {
            this.put("downstreamDepth", EncodingUtils.encode(value));
            return this;
        }

        public ExportLineageQueryParams queryFilter(String value) {
            this.put("query_filter", EncodingUtils.encode(value));
            return this;
        }

        public ExportLineageQueryParams includeDeleted(Boolean value) {
            this.put("includeDeleted", EncodingUtils.encode(value));
            return this;
        }

        public ExportLineageQueryParams type(String value) {
            this.put("type", EncodingUtils.encode(value));
            return this;
        }
    }
}

