/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateMetric;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.Metric;
import org.openmetadata.client.model.MetricsList;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;

public interface MetricsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/metrics/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower2(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="PUT /v1/metrics/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollower2WithHttpInfo(@Param(value="id") UUID var1, UUID var2);

    @RequestLine(value="POST /v1/metrics")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Metric createMetric(CreateMetric var1);

    @RequestLine(value="POST /v1/metrics")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Metric> createMetricWithHttpInfo(CreateMetric var1);

    @RequestLine(value="PUT /v1/metrics")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Metric createOrUpdateMetric(CreateMetric var1);

    @RequestLine(value="PUT /v1/metrics")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Metric> createOrUpdateMetricWithHttpInfo(CreateMetric var1);

    @RequestLine(value="DELETE /v1/metrics/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPIEndpointByFQN1(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/metrics/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPIEndpointByFQN1WithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/metrics/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPIEndpointByFQN1(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteAPIEndpointByFQN1QueryParams var2);

    @RequestLine(value="DELETE /v1/metrics/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPIEndpointByFQN1WithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteAPIEndpointByFQN1QueryParams var2);

    @RequestLine(value="DELETE /v1/metrics/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower5(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/metrics/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower5WithHttpInfo(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/metrics/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMetric(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/metrics/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMetricWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/metrics/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMetric(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteMetricQueryParams var2);

    @RequestLine(value="DELETE /v1/metrics/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMetricWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteMetricQueryParams var2);

    @RequestLine(value="DELETE /v1/metrics/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMetricAsync(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/metrics/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMetricAsyncWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/metrics/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMetricAsync(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteMetricAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/metrics/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMetricAsyncWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteMetricAsyncQueryParams var2);

    @RequestLine(value="GET /v1/metrics/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Metric getMetricByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/metrics/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Metric> getMetricByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/metrics/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Metric getMetricByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetMetricByFQNQueryParams var2);

    @RequestLine(value="GET /v1/metrics/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Metric> getMetricByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetMetricByFQNQueryParams var2);

    @RequestLine(value="GET /v1/metrics/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Metric getMetricByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/metrics/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Metric> getMetricByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/metrics/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Metric getMetricByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetMetricByIDQueryParams var2);

    @RequestLine(value="GET /v1/metrics/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Metric> getMetricByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetMetricByIDQueryParams var2);

    @RequestLine(value="GET /v1/metrics/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Metric getSpecificEndpointVersion1(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/metrics/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Metric> getSpecificEndpointVersion1WithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/metrics/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllMetricVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/metrics/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllMetricVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/metrics?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MetricsList listMetrics(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="include") String var5);

    @RequestLine(value="GET /v1/metrics?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MetricsList> listMetricsWithHttpInfo(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="include") String var5);

    @RequestLine(value="GET /v1/metrics?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MetricsList listMetrics(@QueryMap(encoded=true) ListMetricsQueryParams var1);

    @RequestLine(value="GET /v1/metrics?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MetricsList> listMetricsWithHttpInfo(@QueryMap(encoded=true) ListMetricsQueryParams var1);

    @RequestLine(value="PATCH /v1/metrics/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchMetric(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/metrics/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchMetricWithHttpInfo(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/metrics/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchMetric1(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/metrics/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchMetric1WithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/metrics/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Metric restore18(RestoreEntity var1);

    @RequestLine(value="PUT /v1/metrics/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Metric> restore18WithHttpInfo(RestoreEntity var1);

    @RequestLine(value="PUT /v1/metrics/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForMetric(@Param(value="id") UUID var1, VoteRequest var2);

    @RequestLine(value="PUT /v1/metrics/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForMetricWithHttpInfo(@Param(value="id") UUID var1, VoteRequest var2);

    public static class ListMetricsQueryParams
    extends HashMap<String, Object> {
        public ListMetricsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListMetricsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListMetricsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListMetricsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListMetricsQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetMetricByIDQueryParams
    extends HashMap<String, Object> {
        public GetMetricByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetMetricByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetMetricByFQNQueryParams
    extends HashMap<String, Object> {
        public GetMetricByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetMetricByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMetricAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteMetricAsyncQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMetricQueryParams
    extends HashMap<String, Object> {
        public DeleteMetricQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteAPIEndpointByFQN1QueryParams
    extends HashMap<String, Object> {
        public DeleteAPIEndpointByFQN1QueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

