/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.Report;
import org.openmetadata.client.model.ReportList;
import org.openmetadata.client.model.VoteRequest;

public interface ReportsBetaApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/reports")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Report createOrUpdateReport(Report var1);

    @RequestLine(value="PUT /v1/reports")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Report> createOrUpdateReportWithHttpInfo(Report var1);

    @RequestLine(value="POST /v1/reports")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Report getReportByFQN(Report var1);

    @RequestLine(value="POST /v1/reports")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Report> getReportByFQNWithHttpInfo(Report var1);

    @RequestLine(value="GET /v1/reports/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Report getReportByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/reports/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Report> getReportByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/reports/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Report getReportByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetReportByIDQueryParams var2);

    @RequestLine(value="GET /v1/reports/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Report> getReportByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetReportByIDQueryParams var2);

    @RequestLine(value="GET /v1/reports?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ReportList listReports(@Param(value="fields") String var1);

    @RequestLine(value="GET /v1/reports?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ReportList> listReportsWithHttpInfo(@Param(value="fields") String var1);

    @RequestLine(value="GET /v1/reports?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ReportList listReports(@QueryMap(encoded=true) ListReportsQueryParams var1);

    @RequestLine(value="GET /v1/reports?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ReportList> listReportsWithHttpInfo(@QueryMap(encoded=true) ListReportsQueryParams var1);

    @RequestLine(value="PUT /v1/reports/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity12(@Param(value="id") UUID var1, VoteRequest var2);

    @RequestLine(value="PUT /v1/reports/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity12WithHttpInfo(@Param(value="id") UUID var1, VoteRequest var2);

    public static class ListReportsQueryParams
    extends HashMap<String, Object> {
        public ListReportsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetReportByIDQueryParams
    extends HashMap<String, Object> {
        public GetReportByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetReportByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }
}

