/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.MetricExpression;
import org.openmetadata.client.model.TagLabel;

@JsonPropertyOrder(value={"dataProducts", "description", "displayName", "domain", "extension", "granularity", "lifeCycle", "metricExpression", "metricType", "name", "owners", "relatedMetrics", "reviewers", "tags", "unitOfMeasurement"})
public class CreateMetric {
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    private List<String> dataProducts;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    private Object extension;
    public static final String JSON_PROPERTY_GRANULARITY = "granularity";
    private GranularityEnum granularity;
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_METRIC_EXPRESSION = "metricExpression";
    private MetricExpression metricExpression;
    public static final String JSON_PROPERTY_METRIC_TYPE = "metricType";
    private MetricTypeEnum metricType;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OWNERS = "owners";
    private List<EntityReference> owners;
    public static final String JSON_PROPERTY_RELATED_METRICS = "relatedMetrics";
    private List<String> relatedMetrics;
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    private List<EntityReference> reviewers;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<TagLabel> tags;
    public static final String JSON_PROPERTY_UNIT_OF_MEASUREMENT = "unitOfMeasurement";
    private UnitOfMeasurementEnum unitOfMeasurement;

    public CreateMetric dataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public CreateMetric addDataProductsItem(String dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<String>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(List<String> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public CreateMetric description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateMetric displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateMetric domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public CreateMetric extension(Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public CreateMetric granularity(GranularityEnum granularity) {
        this.granularity = granularity;
        return this;
    }

    @Nullable
    @JsonProperty(value="granularity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GranularityEnum getGranularity() {
        return this.granularity;
    }

    @JsonProperty(value="granularity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGranularity(GranularityEnum granularity) {
        this.granularity = granularity;
    }

    public CreateMetric lifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public CreateMetric metricExpression(MetricExpression metricExpression) {
        this.metricExpression = metricExpression;
        return this;
    }

    @Nullable
    @JsonProperty(value="metricExpression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MetricExpression getMetricExpression() {
        return this.metricExpression;
    }

    @JsonProperty(value="metricExpression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetricExpression(MetricExpression metricExpression) {
        this.metricExpression = metricExpression;
    }

    public CreateMetric metricType(MetricTypeEnum metricType) {
        this.metricType = metricType;
        return this;
    }

    @Nullable
    @JsonProperty(value="metricType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MetricTypeEnum getMetricType() {
        return this.metricType;
    }

    @JsonProperty(value="metricType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetricType(MetricTypeEnum metricType) {
        this.metricType = metricType;
    }

    public CreateMetric name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateMetric owners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public CreateMetric addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public CreateMetric relatedMetrics(List<String> relatedMetrics) {
        this.relatedMetrics = relatedMetrics;
        return this;
    }

    public CreateMetric addRelatedMetricsItem(String relatedMetricsItem) {
        if (this.relatedMetrics == null) {
            this.relatedMetrics = new ArrayList<String>();
        }
        this.relatedMetrics.add(relatedMetricsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="relatedMetrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRelatedMetrics() {
        return this.relatedMetrics;
    }

    @JsonProperty(value="relatedMetrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelatedMetrics(List<String> relatedMetrics) {
        this.relatedMetrics = relatedMetrics;
    }

    public CreateMetric reviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public CreateMetric addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public CreateMetric tags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public CreateMetric addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public CreateMetric unitOfMeasurement(UnitOfMeasurementEnum unitOfMeasurement) {
        this.unitOfMeasurement = unitOfMeasurement;
        return this;
    }

    @Nullable
    @JsonProperty(value="unitOfMeasurement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UnitOfMeasurementEnum getUnitOfMeasurement() {
        return this.unitOfMeasurement;
    }

    @JsonProperty(value="unitOfMeasurement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnitOfMeasurement(UnitOfMeasurementEnum unitOfMeasurement) {
        this.unitOfMeasurement = unitOfMeasurement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMetric createMetric = (CreateMetric)o;
        return Objects.equals(this.dataProducts, createMetric.dataProducts) && Objects.equals(this.description, createMetric.description) && Objects.equals(this.displayName, createMetric.displayName) && Objects.equals(this.domain, createMetric.domain) && Objects.equals(this.extension, createMetric.extension) && Objects.equals((Object)this.granularity, (Object)createMetric.granularity) && Objects.equals(this.lifeCycle, createMetric.lifeCycle) && Objects.equals(this.metricExpression, createMetric.metricExpression) && Objects.equals((Object)this.metricType, (Object)createMetric.metricType) && Objects.equals(this.name, createMetric.name) && Objects.equals(this.owners, createMetric.owners) && Objects.equals(this.relatedMetrics, createMetric.relatedMetrics) && Objects.equals(this.reviewers, createMetric.reviewers) && Objects.equals(this.tags, createMetric.tags) && Objects.equals((Object)this.unitOfMeasurement, (Object)createMetric.unitOfMeasurement);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataProducts, this.description, this.displayName, this.domain, this.extension, this.granularity, this.lifeCycle, this.metricExpression, this.metricType, this.name, this.owners, this.relatedMetrics, this.reviewers, this.tags, this.unitOfMeasurement});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateMetric {\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString((Object)this.granularity)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    metricExpression: ").append(this.toIndentedString(this.metricExpression)).append("\n");
        sb.append("    metricType: ").append(this.toIndentedString((Object)this.metricType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    relatedMetrics: ").append(this.toIndentedString(this.relatedMetrics)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    unitOfMeasurement: ").append(this.toIndentedString((Object)this.unitOfMeasurement)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum GranularityEnum {
        SECOND("SECOND"),
        MINUTE("MINUTE"),
        HOUR("HOUR"),
        DAY("DAY"),
        WEEK("WEEK"),
        MONTH("MONTH"),
        QUARTER("QUARTER"),
        YEAR("YEAR");

        private String value;

        private GranularityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GranularityEnum fromValue(String value) {
            for (GranularityEnum b : GranularityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum MetricTypeEnum {
        COUNT("COUNT"),
        SUM("SUM"),
        AVERAGE("AVERAGE"),
        RATIO("RATIO"),
        PERCENTAGE("PERCENTAGE"),
        MIN("MIN"),
        MAX("MAX"),
        MEDIAN("MEDIAN"),
        MODE("MODE"),
        STANDARD_DEVIATION("STANDARD_DEVIATION"),
        VARIANCE("VARIANCE"),
        OTHER("OTHER");

        private String value;

        private MetricTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MetricTypeEnum fromValue(String value) {
            for (MetricTypeEnum b : MetricTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum UnitOfMeasurementEnum {
        COUNT("COUNT"),
        DOLLARS("DOLLARS"),
        PERCENTAGE("PERCENTAGE"),
        TIMESTAMP("TIMESTAMP"),
        SIZE("SIZE"),
        REQUESTS("REQUESTS"),
        EVENTS("EVENTS"),
        TRANSACTIONS("TRANSACTIONS");

        private String value;

        private UnitOfMeasurementEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UnitOfMeasurementEnum fromValue(String value) {
            for (UnitOfMeasurementEnum b : UnitOfMeasurementEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

