/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.TestResultValue;

@JsonPropertyOrder(value={"failedRows", "failedRowsPercentage", "fqn", "incidentId", "maxBound", "minBound", "passedRows", "passedRowsPercentage", "result", "sampleData", "testCaseStatus", "testResultValue", "timestamp"})
public class CreateTestCaseResult {
    public static final String JSON_PROPERTY_FAILED_ROWS = "failedRows";
    private Integer failedRows;
    public static final String JSON_PROPERTY_FAILED_ROWS_PERCENTAGE = "failedRowsPercentage";
    private Double failedRowsPercentage;
    public static final String JSON_PROPERTY_FQN = "fqn";
    private String fqn;
    public static final String JSON_PROPERTY_INCIDENT_ID = "incidentId";
    private UUID incidentId;
    public static final String JSON_PROPERTY_MAX_BOUND = "maxBound";
    private Double maxBound;
    public static final String JSON_PROPERTY_MIN_BOUND = "minBound";
    private Double minBound;
    public static final String JSON_PROPERTY_PASSED_ROWS = "passedRows";
    private Integer passedRows;
    public static final String JSON_PROPERTY_PASSED_ROWS_PERCENTAGE = "passedRowsPercentage";
    private Double passedRowsPercentage;
    public static final String JSON_PROPERTY_RESULT = "result";
    private String result;
    public static final String JSON_PROPERTY_SAMPLE_DATA = "sampleData";
    private String sampleData;
    public static final String JSON_PROPERTY_TEST_CASE_STATUS = "testCaseStatus";
    private TestCaseStatusEnum testCaseStatus;
    public static final String JSON_PROPERTY_TEST_RESULT_VALUE = "testResultValue";
    private List<TestResultValue> testResultValue = new ArrayList<TestResultValue>();
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private Long timestamp;

    public CreateTestCaseResult failedRows(Integer failedRows) {
        this.failedRows = failedRows;
        return this;
    }

    @Nullable
    @JsonProperty(value="failedRows")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFailedRows() {
        return this.failedRows;
    }

    @JsonProperty(value="failedRows")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailedRows(Integer failedRows) {
        this.failedRows = failedRows;
    }

    public CreateTestCaseResult failedRowsPercentage(Double failedRowsPercentage) {
        this.failedRowsPercentage = failedRowsPercentage;
        return this;
    }

    @Nullable
    @JsonProperty(value="failedRowsPercentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getFailedRowsPercentage() {
        return this.failedRowsPercentage;
    }

    @JsonProperty(value="failedRowsPercentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailedRowsPercentage(Double failedRowsPercentage) {
        this.failedRowsPercentage = failedRowsPercentage;
    }

    public CreateTestCaseResult fqn(String fqn) {
        this.fqn = fqn;
        return this;
    }

    @Nullable
    @JsonProperty(value="fqn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFqn() {
        return this.fqn;
    }

    @JsonProperty(value="fqn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFqn(String fqn) {
        this.fqn = fqn;
    }

    public CreateTestCaseResult incidentId(UUID incidentId) {
        this.incidentId = incidentId;
        return this;
    }

    @Nullable
    @JsonProperty(value="incidentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIncidentId() {
        return this.incidentId;
    }

    @JsonProperty(value="incidentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncidentId(UUID incidentId) {
        this.incidentId = incidentId;
    }

    public CreateTestCaseResult maxBound(Double maxBound) {
        this.maxBound = maxBound;
        return this;
    }

    @Nullable
    @JsonProperty(value="maxBound")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getMaxBound() {
        return this.maxBound;
    }

    @JsonProperty(value="maxBound")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxBound(Double maxBound) {
        this.maxBound = maxBound;
    }

    public CreateTestCaseResult minBound(Double minBound) {
        this.minBound = minBound;
        return this;
    }

    @Nullable
    @JsonProperty(value="minBound")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getMinBound() {
        return this.minBound;
    }

    @JsonProperty(value="minBound")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinBound(Double minBound) {
        this.minBound = minBound;
    }

    public CreateTestCaseResult passedRows(Integer passedRows) {
        this.passedRows = passedRows;
        return this;
    }

    @Nullable
    @JsonProperty(value="passedRows")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPassedRows() {
        return this.passedRows;
    }

    @JsonProperty(value="passedRows")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassedRows(Integer passedRows) {
        this.passedRows = passedRows;
    }

    public CreateTestCaseResult passedRowsPercentage(Double passedRowsPercentage) {
        this.passedRowsPercentage = passedRowsPercentage;
        return this;
    }

    @Nullable
    @JsonProperty(value="passedRowsPercentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getPassedRowsPercentage() {
        return this.passedRowsPercentage;
    }

    @JsonProperty(value="passedRowsPercentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassedRowsPercentage(Double passedRowsPercentage) {
        this.passedRowsPercentage = passedRowsPercentage;
    }

    public CreateTestCaseResult result(String result) {
        this.result = result;
        return this;
    }

    @Nullable
    @JsonProperty(value="result")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResult() {
        return this.result;
    }

    @JsonProperty(value="result")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResult(String result) {
        this.result = result;
    }

    public CreateTestCaseResult sampleData(String sampleData) {
        this.sampleData = sampleData;
        return this;
    }

    @Nullable
    @JsonProperty(value="sampleData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSampleData() {
        return this.sampleData;
    }

    @JsonProperty(value="sampleData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSampleData(String sampleData) {
        this.sampleData = sampleData;
    }

    public CreateTestCaseResult testCaseStatus(TestCaseStatusEnum testCaseStatus) {
        this.testCaseStatus = testCaseStatus;
        return this;
    }

    @Nonnull
    @JsonProperty(value="testCaseStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TestCaseStatusEnum getTestCaseStatus() {
        return this.testCaseStatus;
    }

    @JsonProperty(value="testCaseStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTestCaseStatus(TestCaseStatusEnum testCaseStatus) {
        this.testCaseStatus = testCaseStatus;
    }

    public CreateTestCaseResult testResultValue(List<TestResultValue> testResultValue) {
        this.testResultValue = testResultValue;
        return this;
    }

    public CreateTestCaseResult addTestResultValueItem(TestResultValue testResultValueItem) {
        if (this.testResultValue == null) {
            this.testResultValue = new ArrayList<TestResultValue>();
        }
        this.testResultValue.add(testResultValueItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="testResultValue")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TestResultValue> getTestResultValue() {
        return this.testResultValue;
    }

    @JsonProperty(value="testResultValue")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTestResultValue(List<TestResultValue> testResultValue) {
        this.testResultValue = testResultValue;
    }

    public CreateTestCaseResult timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nonnull
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTestCaseResult createTestCaseResult = (CreateTestCaseResult)o;
        return Objects.equals(this.failedRows, createTestCaseResult.failedRows) && Objects.equals(this.failedRowsPercentage, createTestCaseResult.failedRowsPercentage) && Objects.equals(this.fqn, createTestCaseResult.fqn) && Objects.equals(this.incidentId, createTestCaseResult.incidentId) && Objects.equals(this.maxBound, createTestCaseResult.maxBound) && Objects.equals(this.minBound, createTestCaseResult.minBound) && Objects.equals(this.passedRows, createTestCaseResult.passedRows) && Objects.equals(this.passedRowsPercentage, createTestCaseResult.passedRowsPercentage) && Objects.equals(this.result, createTestCaseResult.result) && Objects.equals(this.sampleData, createTestCaseResult.sampleData) && Objects.equals((Object)this.testCaseStatus, (Object)createTestCaseResult.testCaseStatus) && Objects.equals(this.testResultValue, createTestCaseResult.testResultValue) && Objects.equals(this.timestamp, createTestCaseResult.timestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.failedRows, this.failedRowsPercentage, this.fqn, this.incidentId, this.maxBound, this.minBound, this.passedRows, this.passedRowsPercentage, this.result, this.sampleData, this.testCaseStatus, this.testResultValue, this.timestamp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTestCaseResult {\n");
        sb.append("    failedRows: ").append(this.toIndentedString(this.failedRows)).append("\n");
        sb.append("    failedRowsPercentage: ").append(this.toIndentedString(this.failedRowsPercentage)).append("\n");
        sb.append("    fqn: ").append(this.toIndentedString(this.fqn)).append("\n");
        sb.append("    incidentId: ").append(this.toIndentedString(this.incidentId)).append("\n");
        sb.append("    maxBound: ").append(this.toIndentedString(this.maxBound)).append("\n");
        sb.append("    minBound: ").append(this.toIndentedString(this.minBound)).append("\n");
        sb.append("    passedRows: ").append(this.toIndentedString(this.passedRows)).append("\n");
        sb.append("    passedRowsPercentage: ").append(this.toIndentedString(this.passedRowsPercentage)).append("\n");
        sb.append("    result: ").append(this.toIndentedString(this.result)).append("\n");
        sb.append("    sampleData: ").append(this.toIndentedString(this.sampleData)).append("\n");
        sb.append("    testCaseStatus: ").append(this.toIndentedString((Object)this.testCaseStatus)).append("\n");
        sb.append("    testResultValue: ").append(this.toIndentedString(this.testResultValue)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TestCaseStatusEnum {
        SUCCESS("Success"),
        FAILED("Failed"),
        ABORTED("Aborted"),
        QUEUED("Queued");

        private String value;

        private TestCaseStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TestCaseStatusEnum fromValue(String value) {
            for (TestCaseStatusEnum b : TestCaseStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

