/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.AssetCertification;
import org.openmetadata.client.model.ChangeDescription;
import org.openmetadata.client.model.DatabaseConnection;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.LifeCycle;
import org.openmetadata.client.model.Style;
import org.openmetadata.client.model.TagLabel;
import org.openmetadata.client.model.TestConnectionResult;
import org.openmetadata.client.model.UsageDetails;
import org.openmetadata.client.model.Votes;

@JsonPropertyOrder(value={"certification", "changeDescription", "children", "connection", "dataProducts", "deleted", "description", "displayName", "domain", "experts", "extension", "followers", "fullyQualifiedName", "href", "id", "incrementalChangeDescription", "ingestionRunner", "lifeCycle", "name", "owners", "pipelines", "provider", "reviewers", "service", "serviceType", "style", "tags", "testConnectionResult", "updatedAt", "updatedBy", "usageSummary", "version", "votes"})
public class DatabaseService {
    public static final String JSON_PROPERTY_CERTIFICATION = "certification";
    private AssetCertification certification;
    public static final String JSON_PROPERTY_CHANGE_DESCRIPTION = "changeDescription";
    private ChangeDescription changeDescription;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    private List<EntityReference> children;
    public static final String JSON_PROPERTY_CONNECTION = "connection";
    private DatabaseConnection connection;
    public static final String JSON_PROPERTY_DATA_PRODUCTS = "dataProducts";
    private List<EntityReference> dataProducts;
    public static final String JSON_PROPERTY_DELETED = "deleted";
    private Boolean deleted;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private EntityReference domain;
    public static final String JSON_PROPERTY_EXPERTS = "experts";
    private List<EntityReference> experts;
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    private Object extension;
    public static final String JSON_PROPERTY_FOLLOWERS = "followers";
    private List<EntityReference> followers;
    public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
    private String fullyQualifiedName;
    public static final String JSON_PROPERTY_HREF = "href";
    private URI href;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_INCREMENTAL_CHANGE_DESCRIPTION = "incrementalChangeDescription";
    private ChangeDescription incrementalChangeDescription;
    public static final String JSON_PROPERTY_INGESTION_RUNNER = "ingestionRunner";
    private EntityReference ingestionRunner;
    public static final String JSON_PROPERTY_LIFE_CYCLE = "lifeCycle";
    private LifeCycle lifeCycle;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OWNERS = "owners";
    private List<EntityReference> owners;
    public static final String JSON_PROPERTY_PIPELINES = "pipelines";
    private List<EntityReference> pipelines;
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    private ProviderEnum provider;
    public static final String JSON_PROPERTY_REVIEWERS = "reviewers";
    private List<EntityReference> reviewers;
    public static final String JSON_PROPERTY_SERVICE = "service";
    private EntityReference service;
    public static final String JSON_PROPERTY_SERVICE_TYPE = "serviceType";
    private ServiceTypeEnum serviceType;
    public static final String JSON_PROPERTY_STYLE = "style";
    private Style style;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<TagLabel> tags;
    public static final String JSON_PROPERTY_TEST_CONNECTION_RESULT = "testConnectionResult";
    private TestConnectionResult testConnectionResult;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private Long updatedAt;
    public static final String JSON_PROPERTY_UPDATED_BY = "updatedBy";
    private String updatedBy;
    public static final String JSON_PROPERTY_USAGE_SUMMARY = "usageSummary";
    private UsageDetails usageSummary;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Double version;
    public static final String JSON_PROPERTY_VOTES = "votes";
    private Votes votes;

    public DatabaseService certification(AssetCertification certification) {
        this.certification = certification;
        return this;
    }

    @Nullable
    @JsonProperty(value="certification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AssetCertification getCertification() {
        return this.certification;
    }

    @JsonProperty(value="certification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCertification(AssetCertification certification) {
        this.certification = certification;
    }

    public DatabaseService changeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
        return this;
    }

    @Nullable
    @JsonProperty(value="changeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    @JsonProperty(value="changeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChangeDescription(ChangeDescription changeDescription) {
        this.changeDescription = changeDescription;
    }

    public DatabaseService children(List<EntityReference> children) {
        this.children = children;
        return this;
    }

    public DatabaseService addChildrenItem(EntityReference childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<EntityReference>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildren(List<EntityReference> children) {
        this.children = children;
    }

    public DatabaseService connection(DatabaseConnection connection) {
        this.connection = connection;
        return this;
    }

    @Nullable
    @JsonProperty(value="connection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DatabaseConnection getConnection() {
        return this.connection;
    }

    @JsonProperty(value="connection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConnection(DatabaseConnection connection) {
        this.connection = connection;
    }

    public DatabaseService dataProducts(List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
        return this;
    }

    public DatabaseService addDataProductsItem(EntityReference dataProductsItem) {
        if (this.dataProducts == null) {
            this.dataProducts = new ArrayList<EntityReference>();
        }
        this.dataProducts.add(dataProductsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getDataProducts() {
        return this.dataProducts;
    }

    @JsonProperty(value="dataProducts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataProducts(List<EntityReference> dataProducts) {
        this.dataProducts = dataProducts;
    }

    public DatabaseService deleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Nullable
    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public DatabaseService description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public DatabaseService displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public DatabaseService domain(EntityReference domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomain(EntityReference domain) {
        this.domain = domain;
    }

    public DatabaseService experts(List<EntityReference> experts) {
        this.experts = experts;
        return this;
    }

    public DatabaseService addExpertsItem(EntityReference expertsItem) {
        if (this.experts == null) {
            this.experts = new ArrayList<EntityReference>();
        }
        this.experts.add(expertsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="experts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getExperts() {
        return this.experts;
    }

    @JsonProperty(value="experts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExperts(List<EntityReference> experts) {
        this.experts = experts;
    }

    public DatabaseService extension(Object extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public DatabaseService followers(List<EntityReference> followers) {
        this.followers = followers;
        return this;
    }

    public DatabaseService addFollowersItem(EntityReference followersItem) {
        if (this.followers == null) {
            this.followers = new ArrayList<EntityReference>();
        }
        this.followers.add(followersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="followers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getFollowers() {
        return this.followers;
    }

    @JsonProperty(value="followers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFollowers(List<EntityReference> followers) {
        this.followers = followers;
    }

    public DatabaseService fullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Nullable
    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public DatabaseService href(URI href) {
        this.href = href;
        return this;
    }

    @Nullable
    @JsonProperty(value="href")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getHref() {
        return this.href;
    }

    @JsonProperty(value="href")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHref(URI href) {
        this.href = href;
    }

    public DatabaseService id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(UUID id) {
        this.id = id;
    }

    public DatabaseService incrementalChangeDescription(ChangeDescription incrementalChangeDescription) {
        this.incrementalChangeDescription = incrementalChangeDescription;
        return this;
    }

    @Nullable
    @JsonProperty(value="incrementalChangeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChangeDescription getIncrementalChangeDescription() {
        return this.incrementalChangeDescription;
    }

    @JsonProperty(value="incrementalChangeDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncrementalChangeDescription(ChangeDescription incrementalChangeDescription) {
        this.incrementalChangeDescription = incrementalChangeDescription;
    }

    public DatabaseService ingestionRunner(EntityReference ingestionRunner) {
        this.ingestionRunner = ingestionRunner;
        return this;
    }

    @Nullable
    @JsonProperty(value="ingestionRunner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getIngestionRunner() {
        return this.ingestionRunner;
    }

    @JsonProperty(value="ingestionRunner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIngestionRunner(EntityReference ingestionRunner) {
        this.ingestionRunner = ingestionRunner;
    }

    public DatabaseService lifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    @JsonProperty(value="lifeCycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public DatabaseService name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public DatabaseService owners(List<EntityReference> owners) {
        this.owners = owners;
        return this;
    }

    public DatabaseService addOwnersItem(EntityReference ownersItem) {
        if (this.owners == null) {
            this.owners = new ArrayList<EntityReference>();
        }
        this.owners.add(ownersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getOwners() {
        return this.owners;
    }

    @JsonProperty(value="owners")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwners(List<EntityReference> owners) {
        this.owners = owners;
    }

    public DatabaseService pipelines(List<EntityReference> pipelines) {
        this.pipelines = pipelines;
        return this;
    }

    public DatabaseService addPipelinesItem(EntityReference pipelinesItem) {
        if (this.pipelines == null) {
            this.pipelines = new ArrayList<EntityReference>();
        }
        this.pipelines.add(pipelinesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="pipelines")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getPipelines() {
        return this.pipelines;
    }

    @JsonProperty(value="pipelines")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPipelines(List<EntityReference> pipelines) {
        this.pipelines = pipelines;
    }

    public DatabaseService provider(ProviderEnum provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProviderEnum getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(ProviderEnum provider) {
        this.provider = provider;
    }

    public DatabaseService reviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public DatabaseService addReviewersItem(EntityReference reviewersItem) {
        if (this.reviewers == null) {
            this.reviewers = new ArrayList<EntityReference>();
        }
        this.reviewers.add(reviewersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getReviewers() {
        return this.reviewers;
    }

    @JsonProperty(value="reviewers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReviewers(List<EntityReference> reviewers) {
        this.reviewers = reviewers;
    }

    public DatabaseService service(EntityReference service) {
        this.service = service;
        return this;
    }

    @Nullable
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setService(EntityReference service) {
        this.service = service;
    }

    public DatabaseService serviceType(ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ServiceTypeEnum getServiceType() {
        return this.serviceType;
    }

    @JsonProperty(value="serviceType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setServiceType(ServiceTypeEnum serviceType) {
        this.serviceType = serviceType;
    }

    public DatabaseService style(Style style) {
        this.style = style;
        return this;
    }

    @Nullable
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Style getStyle() {
        return this.style;
    }

    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStyle(Style style) {
        this.style = style;
    }

    public DatabaseService tags(List<TagLabel> tags) {
        this.tags = tags;
        return this;
    }

    public DatabaseService addTagsItem(TagLabel tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<TagLabel>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TagLabel> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(List<TagLabel> tags) {
        this.tags = tags;
    }

    public DatabaseService testConnectionResult(TestConnectionResult testConnectionResult) {
        this.testConnectionResult = testConnectionResult;
        return this;
    }

    @Nullable
    @JsonProperty(value="testConnectionResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TestConnectionResult getTestConnectionResult() {
        return this.testConnectionResult;
    }

    @JsonProperty(value="testConnectionResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestConnectionResult(TestConnectionResult testConnectionResult) {
        this.testConnectionResult = testConnectionResult;
    }

    public DatabaseService updatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public DatabaseService updatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public DatabaseService usageSummary(UsageDetails usageSummary) {
        this.usageSummary = usageSummary;
        return this;
    }

    @Nullable
    @JsonProperty(value="usageSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UsageDetails getUsageSummary() {
        return this.usageSummary;
    }

    @JsonProperty(value="usageSummary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsageSummary(UsageDetails usageSummary) {
        this.usageSummary = usageSummary;
    }

    public DatabaseService version(Double version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(Double version) {
        this.version = version;
    }

    public DatabaseService votes(Votes votes) {
        this.votes = votes;
        return this;
    }

    @Nullable
    @JsonProperty(value="votes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Votes getVotes() {
        return this.votes;
    }

    @JsonProperty(value="votes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVotes(Votes votes) {
        this.votes = votes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseService databaseService = (DatabaseService)o;
        return Objects.equals(this.certification, databaseService.certification) && Objects.equals(this.changeDescription, databaseService.changeDescription) && Objects.equals(this.children, databaseService.children) && Objects.equals(this.connection, databaseService.connection) && Objects.equals(this.dataProducts, databaseService.dataProducts) && Objects.equals(this.deleted, databaseService.deleted) && Objects.equals(this.description, databaseService.description) && Objects.equals(this.displayName, databaseService.displayName) && Objects.equals(this.domain, databaseService.domain) && Objects.equals(this.experts, databaseService.experts) && Objects.equals(this.extension, databaseService.extension) && Objects.equals(this.followers, databaseService.followers) && Objects.equals(this.fullyQualifiedName, databaseService.fullyQualifiedName) && Objects.equals(this.href, databaseService.href) && Objects.equals(this.id, databaseService.id) && Objects.equals(this.incrementalChangeDescription, databaseService.incrementalChangeDescription) && Objects.equals(this.ingestionRunner, databaseService.ingestionRunner) && Objects.equals(this.lifeCycle, databaseService.lifeCycle) && Objects.equals(this.name, databaseService.name) && Objects.equals(this.owners, databaseService.owners) && Objects.equals(this.pipelines, databaseService.pipelines) && Objects.equals((Object)this.provider, (Object)databaseService.provider) && Objects.equals(this.reviewers, databaseService.reviewers) && Objects.equals(this.service, databaseService.service) && Objects.equals((Object)this.serviceType, (Object)databaseService.serviceType) && Objects.equals(this.style, databaseService.style) && Objects.equals(this.tags, databaseService.tags) && Objects.equals(this.testConnectionResult, databaseService.testConnectionResult) && Objects.equals(this.updatedAt, databaseService.updatedAt) && Objects.equals(this.updatedBy, databaseService.updatedBy) && Objects.equals(this.usageSummary, databaseService.usageSummary) && Objects.equals(this.version, databaseService.version) && Objects.equals(this.votes, databaseService.votes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.certification, this.changeDescription, this.children, this.connection, this.dataProducts, this.deleted, this.description, this.displayName, this.domain, this.experts, this.extension, this.followers, this.fullyQualifiedName, this.href, this.id, this.incrementalChangeDescription, this.ingestionRunner, this.lifeCycle, this.name, this.owners, this.pipelines, this.provider, this.reviewers, this.service, this.serviceType, this.style, this.tags, this.testConnectionResult, this.updatedAt, this.updatedBy, this.usageSummary, this.version, this.votes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DatabaseService {\n");
        sb.append("    certification: ").append(this.toIndentedString(this.certification)).append("\n");
        sb.append("    changeDescription: ").append(this.toIndentedString(this.changeDescription)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    connection: ").append(this.toIndentedString(this.connection)).append("\n");
        sb.append("    dataProducts: ").append(this.toIndentedString(this.dataProducts)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    experts: ").append(this.toIndentedString(this.experts)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    followers: ").append(this.toIndentedString(this.followers)).append("\n");
        sb.append("    fullyQualifiedName: ").append(this.toIndentedString(this.fullyQualifiedName)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    incrementalChangeDescription: ").append(this.toIndentedString(this.incrementalChangeDescription)).append("\n");
        sb.append("    ingestionRunner: ").append(this.toIndentedString(this.ingestionRunner)).append("\n");
        sb.append("    lifeCycle: ").append(this.toIndentedString(this.lifeCycle)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    owners: ").append(this.toIndentedString(this.owners)).append("\n");
        sb.append("    pipelines: ").append(this.toIndentedString(this.pipelines)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("    reviewers: ").append(this.toIndentedString(this.reviewers)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    serviceType: ").append(this.toIndentedString((Object)this.serviceType)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    testConnectionResult: ").append(this.toIndentedString(this.testConnectionResult)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    usageSummary: ").append(this.toIndentedString(this.usageSummary)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    votes: ").append(this.toIndentedString(this.votes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProviderEnum {
        SYSTEM("system"),
        USER("user"),
        AUTOMATION("automation");

        private String value;

        private ProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProviderEnum fromValue(String value) {
            for (ProviderEnum b : ProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ServiceTypeEnum {
        BIGQUERY("BigQuery"),
        BIGTABLE("BigTable"),
        MYSQL("Mysql"),
        REDSHIFT("Redshift"),
        SNOWFLAKE("Snowflake"),
        POSTGRES("Postgres"),
        MSSQL("Mssql"),
        ORACLE("Oracle"),
        ATHENA("Athena"),
        HIVE("Hive"),
        IMPALA("Impala"),
        PRESTO("Presto"),
        TRINO("Trino"),
        VERTICA("Vertica"),
        GLUE("Glue"),
        MARIADB("MariaDB"),
        DRUID("Druid"),
        DB2("Db2"),
        CLICKHOUSE("Clickhouse"),
        DATABRICKS("Databricks"),
        AZURESQL("AzureSQL"),
        DYNAMODB("DynamoDB"),
        SINGLESTORE("SingleStore"),
        SQLITE("SQLite"),
        DELTALAKE("DeltaLake"),
        SALESFORCE("Salesforce"),
        PINOTDB("PinotDB"),
        DATALAKE("Datalake"),
        DOMODATABASE("DomoDatabase"),
        QUERYLOG("QueryLog"),
        CUSTOMDATABASE("CustomDatabase"),
        DBT("Dbt"),
        SAPHANA("SapHana"),
        MONGODB("MongoDB"),
        CASSANDRA("Cassandra"),
        COUCHBASE("Couchbase"),
        GREENPLUM("Greenplum"),
        DORIS("Doris"),
        UNITYCATALOG("UnityCatalog"),
        SAS("SAS"),
        ICEBERG("Iceberg"),
        TERADATA("Teradata"),
        SAPERP("SapErp"),
        SYNAPSE("Synapse"),
        EXASOL("Exasol"),
        COCKROACH("Cockroach");

        private String value;

        private ServiceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceTypeEnum fromValue(String value) {
            for (ServiceTypeEnum b : ServiceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

