/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.ElasticsSearch;
import org.openmetadata.client.model.FilterPattern;
import org.openmetadata.client.model.OpenMetadataJWTClientConfig;

@JsonPropertyOrder(value={"apiVersion", "authProvider", "clusterName", "databaseFilterPattern", "elasticsSearch", "enableVersionValidation", "extraHeaders", "forceEntityOverwriting", "hostPort", "includeDashboards", "includeDatabaseServices", "includeGlossaryTerms", "includeMessagingServices", "includeMlModels", "includePipelineServices", "includePipelines", "includePolicy", "includeTables", "includeTags", "includeTeams", "includeTopics", "includeUsers", "limitRecords", "schemaFilterPattern", "secretsManagerLoader", "secretsManagerProvider", "securityConfig", "sslConfig", "storeServiceConnection", "supportsDataInsightExtraction", "supportsElasticSearchReindexingExtraction", "tableFilterPattern", "type", "verifySSL"})
public class OpenMetadataConnection {
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    private String apiVersion;
    public static final String JSON_PROPERTY_AUTH_PROVIDER = "authProvider";
    private AuthProviderEnum authProvider;
    public static final String JSON_PROPERTY_CLUSTER_NAME = "clusterName";
    private String clusterName;
    public static final String JSON_PROPERTY_DATABASE_FILTER_PATTERN = "databaseFilterPattern";
    private FilterPattern databaseFilterPattern;
    public static final String JSON_PROPERTY_ELASTICS_SEARCH = "elasticsSearch";
    private ElasticsSearch elasticsSearch;
    public static final String JSON_PROPERTY_ENABLE_VERSION_VALIDATION = "enableVersionValidation";
    private Boolean enableVersionValidation;
    public static final String JSON_PROPERTY_EXTRA_HEADERS = "extraHeaders";
    private Object extraHeaders;
    public static final String JSON_PROPERTY_FORCE_ENTITY_OVERWRITING = "forceEntityOverwriting";
    private Boolean forceEntityOverwriting;
    public static final String JSON_PROPERTY_HOST_PORT = "hostPort";
    private String hostPort;
    public static final String JSON_PROPERTY_INCLUDE_DASHBOARDS = "includeDashboards";
    private Boolean includeDashboards;
    public static final String JSON_PROPERTY_INCLUDE_DATABASE_SERVICES = "includeDatabaseServices";
    private Boolean includeDatabaseServices;
    public static final String JSON_PROPERTY_INCLUDE_GLOSSARY_TERMS = "includeGlossaryTerms";
    private Boolean includeGlossaryTerms;
    public static final String JSON_PROPERTY_INCLUDE_MESSAGING_SERVICES = "includeMessagingServices";
    private Boolean includeMessagingServices;
    public static final String JSON_PROPERTY_INCLUDE_ML_MODELS = "includeMlModels";
    private Boolean includeMlModels;
    public static final String JSON_PROPERTY_INCLUDE_PIPELINE_SERVICES = "includePipelineServices";
    private Boolean includePipelineServices;
    public static final String JSON_PROPERTY_INCLUDE_PIPELINES = "includePipelines";
    private Boolean includePipelines;
    public static final String JSON_PROPERTY_INCLUDE_POLICY = "includePolicy";
    private Boolean includePolicy;
    public static final String JSON_PROPERTY_INCLUDE_TABLES = "includeTables";
    private Boolean includeTables;
    public static final String JSON_PROPERTY_INCLUDE_TAGS = "includeTags";
    private Boolean includeTags;
    public static final String JSON_PROPERTY_INCLUDE_TEAMS = "includeTeams";
    private Boolean includeTeams;
    public static final String JSON_PROPERTY_INCLUDE_TOPICS = "includeTopics";
    private Boolean includeTopics;
    public static final String JSON_PROPERTY_INCLUDE_USERS = "includeUsers";
    private Boolean includeUsers;
    public static final String JSON_PROPERTY_LIMIT_RECORDS = "limitRecords";
    private Integer limitRecords;
    public static final String JSON_PROPERTY_SCHEMA_FILTER_PATTERN = "schemaFilterPattern";
    private FilterPattern schemaFilterPattern;
    public static final String JSON_PROPERTY_SECRETS_MANAGER_LOADER = "secretsManagerLoader";
    private SecretsManagerLoaderEnum secretsManagerLoader;
    public static final String JSON_PROPERTY_SECRETS_MANAGER_PROVIDER = "secretsManagerProvider";
    private SecretsManagerProviderEnum secretsManagerProvider;
    public static final String JSON_PROPERTY_SECURITY_CONFIG = "securityConfig";
    private OpenMetadataJWTClientConfig securityConfig;
    public static final String JSON_PROPERTY_SSL_CONFIG = "sslConfig";
    private Object sslConfig;
    public static final String JSON_PROPERTY_STORE_SERVICE_CONNECTION = "storeServiceConnection";
    private Boolean storeServiceConnection;
    public static final String JSON_PROPERTY_SUPPORTS_DATA_INSIGHT_EXTRACTION = "supportsDataInsightExtraction";
    private Boolean supportsDataInsightExtraction;
    public static final String JSON_PROPERTY_SUPPORTS_ELASTIC_SEARCH_REINDEXING_EXTRACTION = "supportsElasticSearchReindexingExtraction";
    private Boolean supportsElasticSearchReindexingExtraction;
    public static final String JSON_PROPERTY_TABLE_FILTER_PATTERN = "tableFilterPattern";
    private FilterPattern tableFilterPattern;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_VERIFY_S_S_L = "verifySSL";
    private VerifySSLEnum verifySSL;

    public OpenMetadataConnection apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public OpenMetadataConnection authProvider(AuthProviderEnum authProvider) {
        this.authProvider = authProvider;
        return this;
    }

    @Nullable
    @JsonProperty(value="authProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AuthProviderEnum getAuthProvider() {
        return this.authProvider;
    }

    @JsonProperty(value="authProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthProvider(AuthProviderEnum authProvider) {
        this.authProvider = authProvider;
    }

    public OpenMetadataConnection clusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    @Nullable
    @JsonProperty(value="clusterName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClusterName() {
        return this.clusterName;
    }

    @JsonProperty(value="clusterName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public OpenMetadataConnection databaseFilterPattern(FilterPattern databaseFilterPattern) {
        this.databaseFilterPattern = databaseFilterPattern;
        return this;
    }

    @Nullable
    @JsonProperty(value="databaseFilterPattern")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FilterPattern getDatabaseFilterPattern() {
        return this.databaseFilterPattern;
    }

    @JsonProperty(value="databaseFilterPattern")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDatabaseFilterPattern(FilterPattern databaseFilterPattern) {
        this.databaseFilterPattern = databaseFilterPattern;
    }

    public OpenMetadataConnection elasticsSearch(ElasticsSearch elasticsSearch) {
        this.elasticsSearch = elasticsSearch;
        return this;
    }

    @Nullable
    @JsonProperty(value="elasticsSearch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ElasticsSearch getElasticsSearch() {
        return this.elasticsSearch;
    }

    @JsonProperty(value="elasticsSearch")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setElasticsSearch(ElasticsSearch elasticsSearch) {
        this.elasticsSearch = elasticsSearch;
    }

    public OpenMetadataConnection enableVersionValidation(Boolean enableVersionValidation) {
        this.enableVersionValidation = enableVersionValidation;
        return this;
    }

    @Nullable
    @JsonProperty(value="enableVersionValidation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnableVersionValidation() {
        return this.enableVersionValidation;
    }

    @JsonProperty(value="enableVersionValidation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnableVersionValidation(Boolean enableVersionValidation) {
        this.enableVersionValidation = enableVersionValidation;
    }

    public OpenMetadataConnection extraHeaders(Object extraHeaders) {
        this.extraHeaders = extraHeaders;
        return this;
    }

    @Nullable
    @JsonProperty(value="extraHeaders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getExtraHeaders() {
        return this.extraHeaders;
    }

    @JsonProperty(value="extraHeaders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtraHeaders(Object extraHeaders) {
        this.extraHeaders = extraHeaders;
    }

    public OpenMetadataConnection forceEntityOverwriting(Boolean forceEntityOverwriting) {
        this.forceEntityOverwriting = forceEntityOverwriting;
        return this;
    }

    @Nullable
    @JsonProperty(value="forceEntityOverwriting")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getForceEntityOverwriting() {
        return this.forceEntityOverwriting;
    }

    @JsonProperty(value="forceEntityOverwriting")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setForceEntityOverwriting(Boolean forceEntityOverwriting) {
        this.forceEntityOverwriting = forceEntityOverwriting;
    }

    public OpenMetadataConnection hostPort(String hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @Nonnull
    @JsonProperty(value="hostPort")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHostPort() {
        return this.hostPort;
    }

    @JsonProperty(value="hostPort")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public OpenMetadataConnection includeDashboards(Boolean includeDashboards) {
        this.includeDashboards = includeDashboards;
        return this;
    }

    @Nullable
    @JsonProperty(value="includeDashboards")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeDashboards() {
        return this.includeDashboards;
    }

    @JsonProperty(value="includeDashboards")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeDashboards(Boolean includeDashboards) {
        this.includeDashboards = includeDashboards;
    }

    public OpenMetadataConnection includeDatabaseServices(Boolean includeDatabaseServices) {
        this.includeDatabaseServices = includeDatabaseServices;
        return this;
    }

    @Nullable
    @JsonProperty(value="includeDatabaseServices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeDatabaseServices() {
        return this.includeDatabaseServices;
    }

    @JsonProperty(value="includeDatabaseServices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeDatabaseServices(Boolean includeDatabaseServices) {
        this.includeDatabaseServices = includeDatabaseServices;
    }

    public OpenMetadataConnection includeGlossaryTerms(Boolean includeGlossaryTerms) {
        this.includeGlossaryTerms = includeGlossaryTerms;
        return this;
    }

    @Nullable
    @JsonProperty(value="includeGlossaryTerms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeGlossaryTerms() {
        return this.includeGlossaryTerms;
    }

    @JsonProperty(value="includeGlossaryTerms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeGlossaryTerms(Boolean includeGlossaryTerms) {
        this.includeGlossaryTerms = includeGlossaryTerms;
    }

    public OpenMetadataConnection includeMessagingServices(Boolean includeMessagingServices) {
        this.includeMessagingServices = includeMessagingServices;
        return this;
    }

    @Nullable
    @JsonProperty(value="includeMessagingServices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeMessagingServices() {
        return this.includeMessagingServices;
    }

    @JsonProperty(value="includeMessagingServices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeMessagingServices(Boolean includeMessagingServices) {
        this.includeMessagingServices = includeMessagingServices;
    }

    public OpenMetadataConnection includeMlModels(Boolean includeMlModels) {
        this.includeMlModels = includeMlModels;
        return this;
    }

    @Nullable
    @JsonProperty(value="includeMlModels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeMlModels() {
        return this.includeMlModels;
    }

    @JsonProperty(value="includeMlModels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeMlModels(Boolean includeMlModels) {
        this.includeMlModels = includeMlModels;
    }

    public OpenMetadataConnection includePipelineServices(Boolean includePipelineServices) {
        this.includePipelineServices = includePipelineServices;
        return this;
    }

    @Nullable
    @JsonProperty(value="includePipelineServices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludePipelineServices() {
        return this.includePipelineServices;
    }

    @JsonProperty(value="includePipelineServices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludePipelineServices(Boolean includePipelineServices) {
        this.includePipelineServices = includePipelineServices;
    }

    public OpenMetadataConnection includePipelines(Boolean includePipelines) {
        this.includePipelines = includePipelines;
        return this;
    }

    @Nullable
    @JsonProperty(value="includePipelines")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludePipelines() {
        return this.includePipelines;
    }

    @JsonProperty(value="includePipelines")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludePipelines(Boolean includePipelines) {
        this.includePipelines = includePipelines;
    }

    public OpenMetadataConnection includePolicy(Boolean includePolicy) {
        this.includePolicy = includePolicy;
        return this;
    }

    @Nullable
    @JsonProperty(value="includePolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludePolicy() {
        return this.includePolicy;
    }

    @JsonProperty(value="includePolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludePolicy(Boolean includePolicy) {
        this.includePolicy = includePolicy;
    }

    public OpenMetadataConnection includeTables(Boolean includeTables) {
        this.includeTables = includeTables;
        return this;
    }

    @Nullable
    @JsonProperty(value="includeTables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeTables() {
        return this.includeTables;
    }

    @JsonProperty(value="includeTables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeTables(Boolean includeTables) {
        this.includeTables = includeTables;
    }

    public OpenMetadataConnection includeTags(Boolean includeTags) {
        this.includeTags = includeTags;
        return this;
    }

    @Nullable
    @JsonProperty(value="includeTags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeTags() {
        return this.includeTags;
    }

    @JsonProperty(value="includeTags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
    }

    public OpenMetadataConnection includeTeams(Boolean includeTeams) {
        this.includeTeams = includeTeams;
        return this;
    }

    @Nullable
    @JsonProperty(value="includeTeams")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeTeams() {
        return this.includeTeams;
    }

    @JsonProperty(value="includeTeams")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeTeams(Boolean includeTeams) {
        this.includeTeams = includeTeams;
    }

    public OpenMetadataConnection includeTopics(Boolean includeTopics) {
        this.includeTopics = includeTopics;
        return this;
    }

    @Nullable
    @JsonProperty(value="includeTopics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeTopics() {
        return this.includeTopics;
    }

    @JsonProperty(value="includeTopics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeTopics(Boolean includeTopics) {
        this.includeTopics = includeTopics;
    }

    public OpenMetadataConnection includeUsers(Boolean includeUsers) {
        this.includeUsers = includeUsers;
        return this;
    }

    @Nullable
    @JsonProperty(value="includeUsers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeUsers() {
        return this.includeUsers;
    }

    @JsonProperty(value="includeUsers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeUsers(Boolean includeUsers) {
        this.includeUsers = includeUsers;
    }

    public OpenMetadataConnection limitRecords(Integer limitRecords) {
        this.limitRecords = limitRecords;
        return this;
    }

    @Nullable
    @JsonProperty(value="limitRecords")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLimitRecords() {
        return this.limitRecords;
    }

    @JsonProperty(value="limitRecords")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLimitRecords(Integer limitRecords) {
        this.limitRecords = limitRecords;
    }

    public OpenMetadataConnection schemaFilterPattern(FilterPattern schemaFilterPattern) {
        this.schemaFilterPattern = schemaFilterPattern;
        return this;
    }

    @Nullable
    @JsonProperty(value="schemaFilterPattern")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FilterPattern getSchemaFilterPattern() {
        return this.schemaFilterPattern;
    }

    @JsonProperty(value="schemaFilterPattern")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemaFilterPattern(FilterPattern schemaFilterPattern) {
        this.schemaFilterPattern = schemaFilterPattern;
    }

    public OpenMetadataConnection secretsManagerLoader(SecretsManagerLoaderEnum secretsManagerLoader) {
        this.secretsManagerLoader = secretsManagerLoader;
        return this;
    }

    @Nullable
    @JsonProperty(value="secretsManagerLoader")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecretsManagerLoaderEnum getSecretsManagerLoader() {
        return this.secretsManagerLoader;
    }

    @JsonProperty(value="secretsManagerLoader")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecretsManagerLoader(SecretsManagerLoaderEnum secretsManagerLoader) {
        this.secretsManagerLoader = secretsManagerLoader;
    }

    public OpenMetadataConnection secretsManagerProvider(SecretsManagerProviderEnum secretsManagerProvider) {
        this.secretsManagerProvider = secretsManagerProvider;
        return this;
    }

    @Nullable
    @JsonProperty(value="secretsManagerProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecretsManagerProviderEnum getSecretsManagerProvider() {
        return this.secretsManagerProvider;
    }

    @JsonProperty(value="secretsManagerProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecretsManagerProvider(SecretsManagerProviderEnum secretsManagerProvider) {
        this.secretsManagerProvider = secretsManagerProvider;
    }

    public OpenMetadataConnection securityConfig(OpenMetadataJWTClientConfig securityConfig) {
        this.securityConfig = securityConfig;
        return this;
    }

    @Nullable
    @JsonProperty(value="securityConfig")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OpenMetadataJWTClientConfig getSecurityConfig() {
        return this.securityConfig;
    }

    @JsonProperty(value="securityConfig")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecurityConfig(OpenMetadataJWTClientConfig securityConfig) {
        this.securityConfig = securityConfig;
    }

    public OpenMetadataConnection sslConfig(Object sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    @Nullable
    @JsonProperty(value="sslConfig")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getSslConfig() {
        return this.sslConfig;
    }

    @JsonProperty(value="sslConfig")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSslConfig(Object sslConfig) {
        this.sslConfig = sslConfig;
    }

    public OpenMetadataConnection storeServiceConnection(Boolean storeServiceConnection) {
        this.storeServiceConnection = storeServiceConnection;
        return this;
    }

    @Nullable
    @JsonProperty(value="storeServiceConnection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getStoreServiceConnection() {
        return this.storeServiceConnection;
    }

    @JsonProperty(value="storeServiceConnection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreServiceConnection(Boolean storeServiceConnection) {
        this.storeServiceConnection = storeServiceConnection;
    }

    public OpenMetadataConnection supportsDataInsightExtraction(Boolean supportsDataInsightExtraction) {
        this.supportsDataInsightExtraction = supportsDataInsightExtraction;
        return this;
    }

    @Nullable
    @JsonProperty(value="supportsDataInsightExtraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSupportsDataInsightExtraction() {
        return this.supportsDataInsightExtraction;
    }

    @JsonProperty(value="supportsDataInsightExtraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupportsDataInsightExtraction(Boolean supportsDataInsightExtraction) {
        this.supportsDataInsightExtraction = supportsDataInsightExtraction;
    }

    public OpenMetadataConnection supportsElasticSearchReindexingExtraction(Boolean supportsElasticSearchReindexingExtraction) {
        this.supportsElasticSearchReindexingExtraction = supportsElasticSearchReindexingExtraction;
        return this;
    }

    @Nullable
    @JsonProperty(value="supportsElasticSearchReindexingExtraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSupportsElasticSearchReindexingExtraction() {
        return this.supportsElasticSearchReindexingExtraction;
    }

    @JsonProperty(value="supportsElasticSearchReindexingExtraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSupportsElasticSearchReindexingExtraction(Boolean supportsElasticSearchReindexingExtraction) {
        this.supportsElasticSearchReindexingExtraction = supportsElasticSearchReindexingExtraction;
    }

    public OpenMetadataConnection tableFilterPattern(FilterPattern tableFilterPattern) {
        this.tableFilterPattern = tableFilterPattern;
        return this;
    }

    @Nullable
    @JsonProperty(value="tableFilterPattern")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FilterPattern getTableFilterPattern() {
        return this.tableFilterPattern;
    }

    @JsonProperty(value="tableFilterPattern")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTableFilterPattern(FilterPattern tableFilterPattern) {
        this.tableFilterPattern = tableFilterPattern;
    }

    public OpenMetadataConnection type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OpenMetadataConnection verifySSL(VerifySSLEnum verifySSL) {
        this.verifySSL = verifySSL;
        return this;
    }

    @Nullable
    @JsonProperty(value="verifySSL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public VerifySSLEnum getVerifySSL() {
        return this.verifySSL;
    }

    @JsonProperty(value="verifySSL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerifySSL(VerifySSLEnum verifySSL) {
        this.verifySSL = verifySSL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenMetadataConnection openMetadataConnection = (OpenMetadataConnection)o;
        return Objects.equals(this.apiVersion, openMetadataConnection.apiVersion) && Objects.equals((Object)this.authProvider, (Object)openMetadataConnection.authProvider) && Objects.equals(this.clusterName, openMetadataConnection.clusterName) && Objects.equals(this.databaseFilterPattern, openMetadataConnection.databaseFilterPattern) && Objects.equals(this.elasticsSearch, openMetadataConnection.elasticsSearch) && Objects.equals(this.enableVersionValidation, openMetadataConnection.enableVersionValidation) && Objects.equals(this.extraHeaders, openMetadataConnection.extraHeaders) && Objects.equals(this.forceEntityOverwriting, openMetadataConnection.forceEntityOverwriting) && Objects.equals(this.hostPort, openMetadataConnection.hostPort) && Objects.equals(this.includeDashboards, openMetadataConnection.includeDashboards) && Objects.equals(this.includeDatabaseServices, openMetadataConnection.includeDatabaseServices) && Objects.equals(this.includeGlossaryTerms, openMetadataConnection.includeGlossaryTerms) && Objects.equals(this.includeMessagingServices, openMetadataConnection.includeMessagingServices) && Objects.equals(this.includeMlModels, openMetadataConnection.includeMlModels) && Objects.equals(this.includePipelineServices, openMetadataConnection.includePipelineServices) && Objects.equals(this.includePipelines, openMetadataConnection.includePipelines) && Objects.equals(this.includePolicy, openMetadataConnection.includePolicy) && Objects.equals(this.includeTables, openMetadataConnection.includeTables) && Objects.equals(this.includeTags, openMetadataConnection.includeTags) && Objects.equals(this.includeTeams, openMetadataConnection.includeTeams) && Objects.equals(this.includeTopics, openMetadataConnection.includeTopics) && Objects.equals(this.includeUsers, openMetadataConnection.includeUsers) && Objects.equals(this.limitRecords, openMetadataConnection.limitRecords) && Objects.equals(this.schemaFilterPattern, openMetadataConnection.schemaFilterPattern) && Objects.equals((Object)this.secretsManagerLoader, (Object)openMetadataConnection.secretsManagerLoader) && Objects.equals((Object)this.secretsManagerProvider, (Object)openMetadataConnection.secretsManagerProvider) && Objects.equals(this.securityConfig, openMetadataConnection.securityConfig) && Objects.equals(this.sslConfig, openMetadataConnection.sslConfig) && Objects.equals(this.storeServiceConnection, openMetadataConnection.storeServiceConnection) && Objects.equals(this.supportsDataInsightExtraction, openMetadataConnection.supportsDataInsightExtraction) && Objects.equals(this.supportsElasticSearchReindexingExtraction, openMetadataConnection.supportsElasticSearchReindexingExtraction) && Objects.equals(this.tableFilterPattern, openMetadataConnection.tableFilterPattern) && Objects.equals((Object)this.type, (Object)openMetadataConnection.type) && Objects.equals((Object)this.verifySSL, (Object)openMetadataConnection.verifySSL);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiVersion, this.authProvider, this.clusterName, this.databaseFilterPattern, this.elasticsSearch, this.enableVersionValidation, this.extraHeaders, this.forceEntityOverwriting, this.hostPort, this.includeDashboards, this.includeDatabaseServices, this.includeGlossaryTerms, this.includeMessagingServices, this.includeMlModels, this.includePipelineServices, this.includePipelines, this.includePolicy, this.includeTables, this.includeTags, this.includeTeams, this.includeTopics, this.includeUsers, this.limitRecords, this.schemaFilterPattern, this.secretsManagerLoader, this.secretsManagerProvider, this.securityConfig, this.sslConfig, this.storeServiceConnection, this.supportsDataInsightExtraction, this.supportsElasticSearchReindexingExtraction, this.tableFilterPattern, this.type, this.verifySSL});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenMetadataConnection {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    authProvider: ").append(this.toIndentedString((Object)this.authProvider)).append("\n");
        sb.append("    clusterName: ").append(this.toIndentedString(this.clusterName)).append("\n");
        sb.append("    databaseFilterPattern: ").append(this.toIndentedString(this.databaseFilterPattern)).append("\n");
        sb.append("    elasticsSearch: ").append(this.toIndentedString(this.elasticsSearch)).append("\n");
        sb.append("    enableVersionValidation: ").append(this.toIndentedString(this.enableVersionValidation)).append("\n");
        sb.append("    extraHeaders: ").append(this.toIndentedString(this.extraHeaders)).append("\n");
        sb.append("    forceEntityOverwriting: ").append(this.toIndentedString(this.forceEntityOverwriting)).append("\n");
        sb.append("    hostPort: ").append(this.toIndentedString(this.hostPort)).append("\n");
        sb.append("    includeDashboards: ").append(this.toIndentedString(this.includeDashboards)).append("\n");
        sb.append("    includeDatabaseServices: ").append(this.toIndentedString(this.includeDatabaseServices)).append("\n");
        sb.append("    includeGlossaryTerms: ").append(this.toIndentedString(this.includeGlossaryTerms)).append("\n");
        sb.append("    includeMessagingServices: ").append(this.toIndentedString(this.includeMessagingServices)).append("\n");
        sb.append("    includeMlModels: ").append(this.toIndentedString(this.includeMlModels)).append("\n");
        sb.append("    includePipelineServices: ").append(this.toIndentedString(this.includePipelineServices)).append("\n");
        sb.append("    includePipelines: ").append(this.toIndentedString(this.includePipelines)).append("\n");
        sb.append("    includePolicy: ").append(this.toIndentedString(this.includePolicy)).append("\n");
        sb.append("    includeTables: ").append(this.toIndentedString(this.includeTables)).append("\n");
        sb.append("    includeTags: ").append(this.toIndentedString(this.includeTags)).append("\n");
        sb.append("    includeTeams: ").append(this.toIndentedString(this.includeTeams)).append("\n");
        sb.append("    includeTopics: ").append(this.toIndentedString(this.includeTopics)).append("\n");
        sb.append("    includeUsers: ").append(this.toIndentedString(this.includeUsers)).append("\n");
        sb.append("    limitRecords: ").append(this.toIndentedString(this.limitRecords)).append("\n");
        sb.append("    schemaFilterPattern: ").append(this.toIndentedString(this.schemaFilterPattern)).append("\n");
        sb.append("    secretsManagerLoader: ").append(this.toIndentedString((Object)this.secretsManagerLoader)).append("\n");
        sb.append("    secretsManagerProvider: ").append(this.toIndentedString((Object)this.secretsManagerProvider)).append("\n");
        sb.append("    securityConfig: ").append(this.toIndentedString(this.securityConfig)).append("\n");
        sb.append("    sslConfig: ").append(this.toIndentedString(this.sslConfig)).append("\n");
        sb.append("    storeServiceConnection: ").append(this.toIndentedString(this.storeServiceConnection)).append("\n");
        sb.append("    supportsDataInsightExtraction: ").append(this.toIndentedString(this.supportsDataInsightExtraction)).append("\n");
        sb.append("    supportsElasticSearchReindexingExtraction: ").append(this.toIndentedString(this.supportsElasticSearchReindexingExtraction)).append("\n");
        sb.append("    tableFilterPattern: ").append(this.toIndentedString(this.tableFilterPattern)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    verifySSL: ").append(this.toIndentedString((Object)this.verifySSL)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AuthProviderEnum {
        BASIC("basic"),
        AZURE("azure"),
        GOOGLE("google"),
        OKTA("okta"),
        AUTH0("auth0"),
        AWS_COGNITO("aws-cognito"),
        CUSTOM_OIDC("custom-oidc"),
        LDAP("ldap"),
        SAML("saml"),
        OPENMETADATA("openmetadata");

        private String value;

        private AuthProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AuthProviderEnum fromValue(String value) {
            for (AuthProviderEnum b : AuthProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SecretsManagerLoaderEnum {
        NOOP("noop"),
        AIRFLOW("airflow"),
        ENV("env");

        private String value;

        private SecretsManagerLoaderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SecretsManagerLoaderEnum fromValue(String value) {
            for (SecretsManagerLoaderEnum b : SecretsManagerLoaderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SecretsManagerProviderEnum {
        DB("db"),
        MANAGED_AWS("managed-aws"),
        AWS("aws"),
        MANAGED_AWS_SSM("managed-aws-ssm"),
        AWS_SSM("aws-ssm"),
        MANAGED_AZURE_KV("managed-azure-kv"),
        AZURE_KV("azure-kv"),
        IN_MEMORY("in-memory"),
        GCP("gcp");

        private String value;

        private SecretsManagerProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SecretsManagerProviderEnum fromValue(String value) {
            for (SecretsManagerProviderEnum b : SecretsManagerProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        OPENMETADATA("OpenMetadata");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum VerifySSLEnum {
        NO_SSL("no-ssl"),
        IGNORE("ignore"),
        VALIDATE("validate");

        private String value;

        private VerifySSLEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VerifySSLEnum fromValue(String value) {
            for (VerifySSLEnum b : VerifySSLEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

