/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.StepSummary;

@JsonPropertyOrder(value={"config", "endDate", "metadata", "pipelineState", "runId", "startDate", "status", "timestamp"})
public class PipelineStatus {
    public static final String JSON_PROPERTY_CONFIG = "config";
    private Map<String, Object> config = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    private Long endDate;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, Object> metadata = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_PIPELINE_STATE = "pipelineState";
    private PipelineStateEnum pipelineState;
    public static final String JSON_PROPERTY_RUN_ID = "runId";
    private String runId;
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    private Long startDate;
    public static final String JSON_PROPERTY_STATUS = "status";
    private List<StepSummary> status;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private Long timestamp;

    public PipelineStatus config(Map<String, Object> config) {
        this.config = config;
        return this;
    }

    public PipelineStatus putConfigItem(String key, Object configItem) {
        if (this.config == null) {
            this.config = new HashMap<String, Object>();
        }
        this.config.put(key, configItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    public PipelineStatus endDate(Long endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(Long endDate) {
        this.endDate = endDate;
    }

    public PipelineStatus metadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    public PipelineStatus putMetadataItem(String key, Object metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public PipelineStatus pipelineState(PipelineStateEnum pipelineState) {
        this.pipelineState = pipelineState;
        return this;
    }

    @Nullable
    @JsonProperty(value="pipelineState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PipelineStateEnum getPipelineState() {
        return this.pipelineState;
    }

    @JsonProperty(value="pipelineState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPipelineState(PipelineStateEnum pipelineState) {
        this.pipelineState = pipelineState;
    }

    public PipelineStatus runId(String runId) {
        this.runId = runId;
        return this;
    }

    @Nullable
    @JsonProperty(value="runId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRunId() {
        return this.runId;
    }

    @JsonProperty(value="runId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRunId(String runId) {
        this.runId = runId;
    }

    public PipelineStatus startDate(Long startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartDate(Long startDate) {
        this.startDate = startDate;
    }

    public PipelineStatus status(List<StepSummary> status) {
        this.status = status;
        return this;
    }

    public PipelineStatus addStatusItem(StepSummary statusItem) {
        if (this.status == null) {
            this.status = new ArrayList<StepSummary>();
        }
        this.status.add(statusItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<StepSummary> getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(List<StepSummary> status) {
        this.status = status;
    }

    public PipelineStatus timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineStatus pipelineStatus = (PipelineStatus)o;
        return Objects.equals(this.config, pipelineStatus.config) && Objects.equals(this.endDate, pipelineStatus.endDate) && Objects.equals(this.metadata, pipelineStatus.metadata) && Objects.equals((Object)this.pipelineState, (Object)pipelineStatus.pipelineState) && Objects.equals(this.runId, pipelineStatus.runId) && Objects.equals(this.startDate, pipelineStatus.startDate) && Objects.equals(this.status, pipelineStatus.status) && Objects.equals(this.timestamp, pipelineStatus.timestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.config, this.endDate, this.metadata, this.pipelineState, this.runId, this.startDate, this.status, this.timestamp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PipelineStatus {\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    pipelineState: ").append(this.toIndentedString((Object)this.pipelineState)).append("\n");
        sb.append("    runId: ").append(this.toIndentedString(this.runId)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PipelineStateEnum {
        QUEUED("queued"),
        SUCCESS("success"),
        FAILED("failed"),
        RUNNING("running"),
        PARTIALSUCCESS("partialSuccess");

        private String value;

        private PipelineStateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PipelineStateEnum fromValue(String value) {
            for (PipelineStateEnum b : PipelineStateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

