/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.EntityError;
import org.openmetadata.client.model.Function;
import org.openmetadata.client.model.Paging;

@JsonPropertyOrder(value={"data", "errors", "paging"})
public class ResultListFunction {
    public static final String JSON_PROPERTY_DATA = "data";
    private List<Function> data = new ArrayList<Function>();
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private List<EntityError> errors;
    public static final String JSON_PROPERTY_PAGING = "paging";
    private Paging paging;

    public ResultListFunction data(List<Function> data) {
        this.data = data;
        return this;
    }

    public ResultListFunction addDataItem(Function dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<Function>();
        }
        this.data.add(dataItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Function> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setData(List<Function> data) {
        this.data = data;
    }

    public ResultListFunction errors(List<EntityError> errors) {
        this.errors = errors;
        return this;
    }

    public ResultListFunction addErrorsItem(EntityError errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<EntityError>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityError> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrors(List<EntityError> errors) {
        this.errors = errors;
    }

    public ResultListFunction paging(Paging paging) {
        this.paging = paging;
        return this;
    }

    @Nullable
    @JsonProperty(value="paging")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Paging getPaging() {
        return this.paging;
    }

    @JsonProperty(value="paging")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaging(Paging paging) {
        this.paging = paging;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultListFunction resultListFunction = (ResultListFunction)o;
        return Objects.equals(this.data, resultListFunction.data) && Objects.equals(this.errors, resultListFunction.errors) && Objects.equals(this.paging, resultListFunction.paging);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.errors, this.paging);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResultListFunction {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    paging: ").append(this.toIndentedString(this.paging)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

