/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateIngestionPipeline;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.IngestionPipeline;
import org.openmetadata.client.model.PipelineServiceClientResponse;
import org.openmetadata.client.model.PipelineStatus;
import org.openmetadata.client.model.RestoreEntity;

public interface IngestionPipelinesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/ingestionPipelines/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToIngestionPipeline(@Param(value="id") UUID var1, String var2);

    @RequestLine(value="PUT /v1/services/ingestionPipelines/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToIngestionPipelineWithHttpInfo(@Param(value="id") UUID var1, String var2);

    @RequestLine(value="PUT /v1/services/ingestionPipelines/{fqn}/pipelineStatus")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public IngestionPipeline addPipelineStatus(@Param(value="fqn") String var1, PipelineStatus var2);

    @RequestLine(value="PUT /v1/services/ingestionPipelines/{fqn}/pipelineStatus")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<IngestionPipeline> addPipelineStatusWithHttpInfo(@Param(value="fqn") String var1, PipelineStatus var2);

    @RequestLine(value="POST /v1/services/ingestionPipelines/bulk/deploy")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public PipelineServiceClientResponse bulkDeployIngestion(List<UUID> var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines/bulk/deploy")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<PipelineServiceClientResponse> bulkDeployIngestionWithHttpInfo(List<UUID> var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines/ip")
    @Headers(value={"Accept: application/json"})
    public void checkAirflowHostIp();

    @RequestLine(value="GET /v1/services/ingestionPipelines/ip")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> checkAirflowHostIpWithHttpInfo();

    @RequestLine(value="GET /v1/services/ingestionPipelines/status")
    @Headers(value={"Accept: application/json"})
    public void checkRestAirflowStatus();

    @RequestLine(value="GET /v1/services/ingestionPipelines/status")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> checkRestAirflowStatusWithHttpInfo();

    @RequestLine(value="POST /v1/services/ingestionPipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public IngestionPipeline createIngestionPipeline(CreateIngestionPipeline var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<IngestionPipeline> createIngestionPipelineWithHttpInfo(CreateIngestionPipeline var1);

    @RequestLine(value="PUT /v1/services/ingestionPipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public IngestionPipeline createOrUpdateIngestionPipeline(CreateIngestionPipeline var1);

    @RequestLine(value="PUT /v1/services/ingestionPipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<IngestionPipeline> createOrUpdateIngestionPipelineWithHttpInfo(CreateIngestionPipeline var1);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower13(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower13WithHttpInfo(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteIngestionPipeline(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteIngestionPipelineWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteIngestionPipeline(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteIngestionPipelineQueryParams var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteIngestionPipelineWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteIngestionPipelineQueryParams var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteIngestionPipelineAsync(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteIngestionPipelineAsyncWithHttpInfo(@Param(value="id") UUID var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteIngestionPipelineAsync(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteIngestionPipelineAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteIngestionPipelineAsyncWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteIngestionPipelineAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteIngestionPipelineByFQN(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteIngestionPipelineByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteIngestionPipelineByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteIngestionPipelineByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteIngestionPipelineByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteIngestionPipelineByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}/pipelineStatus")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline deletePipelineStatus(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}/pipelineStatus")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> deletePipelineStatusWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}/pipelineStatus")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline deletePipelineStatus_1(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}/pipelineStatus")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> deletePipelineStatus_1WithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines/deploy/{id}")
    @Headers(value={"Accept: application/json"})
    public PipelineServiceClientResponse deployIngestion(@Param(value="id") UUID var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines/deploy/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineServiceClientResponse> deployIngestionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline getIngestionPipelineByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> getIngestionPipelineByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline getIngestionPipelineByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetIngestionPipelineByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> getIngestionPipelineByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetIngestionPipelineByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{id}/last?after={after}")
    @Headers(value={"Accept: application/json"})
    public void getLastIngestionLogs(@Param(value="id") UUID var1, @Param(value="after") String var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{id}/last?after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getLastIngestionLogsWithHttpInfo(@Param(value="id") UUID var1, @Param(value="after") String var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{id}/last?after={after}")
    @Headers(value={"Accept: application/json"})
    public void getLastIngestionLogs(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetLastIngestionLogsQueryParams var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{id}/last?after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getLastIngestionLogsWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetLastIngestionLogsQueryParams var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{fqn}/pipelineStatus/{id}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline getPipelineStatus(@Param(value="fqn") String var1, @Param(value="id") String var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{fqn}/pipelineStatus/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> getPipelineStatusWithHttpInfo(@Param(value="fqn") String var1, @Param(value="id") String var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline getSpecificIngestionPipelineByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/ingestionPipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> getSpecificIngestionPipelineByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/ingestionPipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline getSpecificIngestionPipelineByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetSpecificIngestionPipelineByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> getSpecificIngestionPipelineByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetSpecificIngestionPipelineByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline getSpecificIngestionPipelineVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> getSpecificIngestionPipelineVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="POST /v1/services/ingestionPipelines/kill/{id}")
    @Headers(value={"Accept: application/json"})
    public PipelineServiceClientResponse killIngestionPipelineRuns(@Param(value="id") UUID var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines/kill/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineServiceClientResponse> killIngestionPipelineRunsWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllIngestionPipelineVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllIngestionPipelineVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines?fields={fields}&service={service}&testSuite={testSuite}&pipelineType={pipelineType}&serviceType={serviceType}&applicationType={applicationType}&limit={limit}&before={before}&after={after}&include={include}&provider={provider}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline listIngestionPipelines(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="testSuite") String var3, @Param(value="pipelineType") String var4, @Param(value="serviceType") String var5, @Param(value="applicationType") String var6, @Param(value="limit") Integer var7, @Param(value="before") String var8, @Param(value="after") String var9, @Param(value="include") String var10, @Param(value="provider") String var11);

    @RequestLine(value="GET /v1/services/ingestionPipelines?fields={fields}&service={service}&testSuite={testSuite}&pipelineType={pipelineType}&serviceType={serviceType}&applicationType={applicationType}&limit={limit}&before={before}&after={after}&include={include}&provider={provider}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> listIngestionPipelinesWithHttpInfo(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="testSuite") String var3, @Param(value="pipelineType") String var4, @Param(value="serviceType") String var5, @Param(value="applicationType") String var6, @Param(value="limit") Integer var7, @Param(value="before") String var8, @Param(value="after") String var9, @Param(value="include") String var10, @Param(value="provider") String var11);

    @RequestLine(value="GET /v1/services/ingestionPipelines?fields={fields}&service={service}&testSuite={testSuite}&pipelineType={pipelineType}&serviceType={serviceType}&applicationType={applicationType}&limit={limit}&before={before}&after={after}&include={include}&provider={provider}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline listIngestionPipelines(@QueryMap(encoded=true) ListIngestionPipelinesQueryParams var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines?fields={fields}&service={service}&testSuite={testSuite}&pipelineType={pipelineType}&serviceType={serviceType}&applicationType={applicationType}&limit={limit}&before={before}&after={after}&include={include}&provider={provider}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> listIngestionPipelinesWithHttpInfo(@QueryMap(encoded=true) ListIngestionPipelinesQueryParams var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{fqn}/pipelineStatus?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline listPipelineStatuses1(@Param(value="fqn") String var1, @Param(value="startTs") BigDecimal var2, @Param(value="endTs") BigDecimal var3);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{fqn}/pipelineStatus?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> listPipelineStatuses1WithHttpInfo(@Param(value="fqn") String var1, @Param(value="startTs") BigDecimal var2, @Param(value="endTs") BigDecimal var3);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{fqn}/pipelineStatus?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline listPipelineStatuses1(@Param(value="fqn") String var1, @QueryMap(encoded=true) ListPipelineStatuses1QueryParams var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{fqn}/pipelineStatus?startTs={startTs}&endTs={endTs}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> listPipelineStatuses1WithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) ListPipelineStatuses1QueryParams var2);

    @RequestLine(value="PATCH /v1/services/ingestionPipelines/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchIngestionPipeline(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/services/ingestionPipelines/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchIngestionPipelineWithHttpInfo(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/services/ingestionPipelines/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchIngestionPipeline1(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/services/ingestionPipelines/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchIngestionPipeline1WithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/services/ingestionPipelines/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public IngestionPipeline restore27(RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/ingestionPipelines/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<IngestionPipeline> restore27WithHttpInfo(RestoreEntity var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines/toggleIngestion/{id}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline toggleIngestionPipelineEnabled(@Param(value="id") UUID var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines/toggleIngestion/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<IngestionPipeline> toggleIngestionPipelineEnabledWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines/trigger/{id}")
    @Headers(value={"Accept: application/json"})
    public PipelineServiceClientResponse triggerIngestionPipelineRun(@Param(value="id") UUID var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines/trigger/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PipelineServiceClientResponse> triggerIngestionPipelineRunWithHttpInfo(@Param(value="id") UUID var1);

    public static class ListPipelineStatuses1QueryParams
    extends HashMap<String, Object> {
        public ListPipelineStatuses1QueryParams startTs(BigDecimal value) {
            this.put("startTs", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelineStatuses1QueryParams endTs(BigDecimal value) {
            this.put("endTs", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListIngestionPipelinesQueryParams
    extends HashMap<String, Object> {
        public ListIngestionPipelinesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams testSuite(String value) {
            this.put("testSuite", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams pipelineType(String value) {
            this.put("pipelineType", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams serviceType(String value) {
            this.put("serviceType", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams applicationType(String value) {
            this.put("applicationType", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams provider(String value) {
            this.put("provider", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetSpecificIngestionPipelineByFQNQueryParams
    extends HashMap<String, Object> {
        public GetSpecificIngestionPipelineByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetSpecificIngestionPipelineByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetLastIngestionLogsQueryParams
    extends HashMap<String, Object> {
        public GetLastIngestionLogsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetIngestionPipelineByIDQueryParams
    extends HashMap<String, Object> {
        public GetIngestionPipelineByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetIngestionPipelineByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteIngestionPipelineByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteIngestionPipelineByFQNQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteIngestionPipelineAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteIngestionPipelineAsyncQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteIngestionPipelineQueryParams
    extends HashMap<String, Object> {
        public DeleteIngestionPipelineQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

