/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.AggregationRequest;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.PreviewSearchRequest;
import org.openmetadata.client.model.SearchResponse;
import org.openmetadata.client.model.Suggest;

public interface SearchApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/search/aggregate")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public SearchResponse aggregateSearchRequest(AggregationRequest var1);

    @RequestLine(value="POST /v1/search/aggregate")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public ApiResponse<SearchResponse> aggregateSearchRequestWithHttpInfo(AggregationRequest var1);

    @RequestLine(value="GET /v1/search/aggregate?index={index}&field={field}&value={value}&sourceFields={sourceFields}&q={q}&size={size}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public Suggest getAggregateFields(@Param(value="q") String var1, @Param(value="index") String var2, @Param(value="field") String var3, @Param(value="value") String var4, @Param(value="sourceFields") String var5, @Param(value="size") Integer var6, @Param(value="deleted") Boolean var7);

    @RequestLine(value="GET /v1/search/aggregate?index={index}&field={field}&value={value}&sourceFields={sourceFields}&q={q}&size={size}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Suggest> getAggregateFieldsWithHttpInfo(@Param(value="q") String var1, @Param(value="index") String var2, @Param(value="field") String var3, @Param(value="value") String var4, @Param(value="sourceFields") String var5, @Param(value="size") Integer var6, @Param(value="deleted") Boolean var7);

    @RequestLine(value="GET /v1/search/aggregate?index={index}&field={field}&value={value}&sourceFields={sourceFields}&q={q}&size={size}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public Suggest getAggregateFields(@QueryMap(encoded=true) GetAggregateFieldsQueryParams var1);

    @RequestLine(value="GET /v1/search/aggregate?index={index}&field={field}&value={value}&sourceFields={sourceFields}&q={q}&size={size}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Suggest> getAggregateFieldsWithHttpInfo(@QueryMap(encoded=true) GetAggregateFieldsQueryParams var1);

    @RequestLine(value="POST /v1/search/preview")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public SearchResponse previewSearch(PreviewSearchRequest var1);

    @RequestLine(value="POST /v1/search/preview")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<SearchResponse> previewSearchWithHttpInfo(PreviewSearchRequest var1);

    @RequestLine(value="GET /v1/search/nlq/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&search_after={searchAfter}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&getHierarchy={getHierarchy}&explain={explain}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchEntitiesWithNLQ(@Param(value="q") String var1, @Param(value="index") String var2, @Param(value="deleted") Boolean var3, @Param(value="from") Integer var4, @Param(value="size") Integer var5, @Param(value="searchAfter") String var6, @Param(value="sortField") String var7, @Param(value="sortOrder") String var8, @Param(value="trackTotalHits") Boolean var9, @Param(value="queryFilter") String var10, @Param(value="postFilter") String var11, @Param(value="fetchSource") Boolean var12, @Param(value="includeSourceFields") List<String> var13, @Param(value="getHierarchy") Boolean var14, @Param(value="explain") Boolean var15);

    @RequestLine(value="GET /v1/search/nlq/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&search_after={searchAfter}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&getHierarchy={getHierarchy}&explain={explain}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchEntitiesWithNLQWithHttpInfo(@Param(value="q") String var1, @Param(value="index") String var2, @Param(value="deleted") Boolean var3, @Param(value="from") Integer var4, @Param(value="size") Integer var5, @Param(value="searchAfter") String var6, @Param(value="sortField") String var7, @Param(value="sortOrder") String var8, @Param(value="trackTotalHits") Boolean var9, @Param(value="queryFilter") String var10, @Param(value="postFilter") String var11, @Param(value="fetchSource") Boolean var12, @Param(value="includeSourceFields") List<String> var13, @Param(value="getHierarchy") Boolean var14, @Param(value="explain") Boolean var15);

    @RequestLine(value="GET /v1/search/nlq/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&search_after={searchAfter}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&getHierarchy={getHierarchy}&explain={explain}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchEntitiesWithNLQ(@QueryMap(encoded=true) SearchEntitiesWithNLQQueryParams var1);

    @RequestLine(value="GET /v1/search/nlq/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&search_after={searchAfter}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&getHierarchy={getHierarchy}&explain={explain}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchEntitiesWithNLQWithHttpInfo(@QueryMap(encoded=true) SearchEntitiesWithNLQQueryParams var1);

    @RequestLine(value="GET /v1/search/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&search_after={searchAfter}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&getHierarchy={getHierarchy}&explain={explain}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchEntitiesWithQuery(@Param(value="q") String var1, @Param(value="index") String var2, @Param(value="deleted") Boolean var3, @Param(value="from") Integer var4, @Param(value="size") Integer var5, @Param(value="searchAfter") String var6, @Param(value="sortField") String var7, @Param(value="sortOrder") String var8, @Param(value="trackTotalHits") Boolean var9, @Param(value="queryFilter") String var10, @Param(value="postFilter") String var11, @Param(value="fetchSource") Boolean var12, @Param(value="includeSourceFields") List<String> var13, @Param(value="getHierarchy") Boolean var14, @Param(value="explain") Boolean var15);

    @RequestLine(value="GET /v1/search/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&search_after={searchAfter}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&getHierarchy={getHierarchy}&explain={explain}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchEntitiesWithQueryWithHttpInfo(@Param(value="q") String var1, @Param(value="index") String var2, @Param(value="deleted") Boolean var3, @Param(value="from") Integer var4, @Param(value="size") Integer var5, @Param(value="searchAfter") String var6, @Param(value="sortField") String var7, @Param(value="sortOrder") String var8, @Param(value="trackTotalHits") Boolean var9, @Param(value="queryFilter") String var10, @Param(value="postFilter") String var11, @Param(value="fetchSource") Boolean var12, @Param(value="includeSourceFields") List<String> var13, @Param(value="getHierarchy") Boolean var14, @Param(value="explain") Boolean var15);

    @RequestLine(value="GET /v1/search/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&search_after={searchAfter}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&getHierarchy={getHierarchy}&explain={explain}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchEntitiesWithQuery(@QueryMap(encoded=true) SearchEntitiesWithQueryQueryParams var1);

    @RequestLine(value="GET /v1/search/query?q={q}&index={index}&deleted={deleted}&from={from}&size={size}&search_after={searchAfter}&sort_field={sortField}&sort_order={sortOrder}&track_total_hits={trackTotalHits}&query_filter={queryFilter}&post_filter={postFilter}&fetch_source={fetchSource}&include_source_fields={includeSourceFields}&getHierarchy={getHierarchy}&explain={explain}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchEntitiesWithQueryWithHttpInfo(@QueryMap(encoded=true) SearchEntitiesWithQueryQueryParams var1);

    @RequestLine(value="GET /v1/search/sourceUrl?sourceUrl={sourceUrl}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchEntitiesWithSourceUrl(@Param(value="sourceUrl") String var1);

    @RequestLine(value="GET /v1/search/sourceUrl?sourceUrl={sourceUrl}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchEntitiesWithSourceUrlWithHttpInfo(@Param(value="sourceUrl") String var1);

    @RequestLine(value="GET /v1/search/sourceUrl?sourceUrl={sourceUrl}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchEntitiesWithSourceUrl(@QueryMap(encoded=true) SearchEntitiesWithSourceUrlQueryParams var1);

    @RequestLine(value="GET /v1/search/sourceUrl?sourceUrl={sourceUrl}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchEntitiesWithSourceUrlWithHttpInfo(@QueryMap(encoded=true) SearchEntitiesWithSourceUrlQueryParams var1);

    @RequestLine(value="GET /v1/search/fieldQuery?fieldName={fieldName}&fieldValue={fieldValue}&index={index}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchEntitiesWithSpecificFieldAndValue(@Param(value="fieldName") String var1, @Param(value="fieldValue") String var2, @Param(value="index") String var3, @Param(value="deleted") Boolean var4);

    @RequestLine(value="GET /v1/search/fieldQuery?fieldName={fieldName}&fieldValue={fieldValue}&index={index}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchEntitiesWithSpecificFieldAndValueWithHttpInfo(@Param(value="fieldName") String var1, @Param(value="fieldValue") String var2, @Param(value="index") String var3, @Param(value="deleted") Boolean var4);

    @RequestLine(value="GET /v1/search/fieldQuery?fieldName={fieldName}&fieldValue={fieldValue}&index={index}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchEntitiesWithSpecificFieldAndValue(@QueryMap(encoded=true) SearchEntitiesWithSpecificFieldAndValueQueryParams var1);

    @RequestLine(value="GET /v1/search/fieldQuery?fieldName={fieldName}&fieldValue={fieldValue}&index={index}&deleted={deleted}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchEntitiesWithSpecificFieldAndValueWithHttpInfo(@QueryMap(encoded=true) SearchEntitiesWithSpecificFieldAndValueQueryParams var1);

    @RequestLine(value="GET /v1/search/get/{index}/doc/{id}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchEntityInEsIndexWithId(@Param(value="id") UUID var1, @Param(value="index") String var2);

    @RequestLine(value="GET /v1/search/get/{index}/doc/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchEntityInEsIndexWithIdWithHttpInfo(@Param(value="id") UUID var1, @Param(value="index") String var2);

    public static class SearchEntitiesWithSpecificFieldAndValueQueryParams
    extends HashMap<String, Object> {
        public SearchEntitiesWithSpecificFieldAndValueQueryParams fieldName(String value) {
            this.put("fieldName", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithSpecificFieldAndValueQueryParams fieldValue(String value) {
            this.put("fieldValue", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithSpecificFieldAndValueQueryParams index(String value) {
            this.put("index", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithSpecificFieldAndValueQueryParams deleted(Boolean value) {
            this.put("deleted", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class SearchEntitiesWithSourceUrlQueryParams
    extends HashMap<String, Object> {
        public SearchEntitiesWithSourceUrlQueryParams sourceUrl(String value) {
            this.put("sourceUrl", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class SearchEntitiesWithQueryQueryParams
    extends HashMap<String, Object> {
        public SearchEntitiesWithQueryQueryParams q(String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams index(String value) {
            this.put("index", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams deleted(Boolean value) {
            this.put("deleted", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams from(Integer value) {
            this.put("from", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams size(Integer value) {
            this.put("size", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams searchAfter(String value) {
            this.put("search_after", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams sortField(String value) {
            this.put("sort_field", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams sortOrder(String value) {
            this.put("sort_order", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams trackTotalHits(Boolean value) {
            this.put("track_total_hits", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams queryFilter(String value) {
            this.put("query_filter", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams postFilter(String value) {
            this.put("post_filter", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams fetchSource(Boolean value) {
            this.put("fetch_source", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams includeSourceFields(List<String> value) {
            this.put("include_source_fields", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams getHierarchy(Boolean value) {
            this.put("getHierarchy", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithQueryQueryParams explain(Boolean value) {
            this.put("explain", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class SearchEntitiesWithNLQQueryParams
    extends HashMap<String, Object> {
        public SearchEntitiesWithNLQQueryParams q(String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams index(String value) {
            this.put("index", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams deleted(Boolean value) {
            this.put("deleted", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams from(Integer value) {
            this.put("from", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams size(Integer value) {
            this.put("size", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams searchAfter(String value) {
            this.put("search_after", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams sortField(String value) {
            this.put("sort_field", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams sortOrder(String value) {
            this.put("sort_order", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams trackTotalHits(Boolean value) {
            this.put("track_total_hits", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams queryFilter(String value) {
            this.put("query_filter", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams postFilter(String value) {
            this.put("post_filter", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams fetchSource(Boolean value) {
            this.put("fetch_source", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams includeSourceFields(List<String> value) {
            this.put("include_source_fields", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams getHierarchy(Boolean value) {
            this.put("getHierarchy", EncodingUtils.encode(value));
            return this;
        }

        public SearchEntitiesWithNLQQueryParams explain(Boolean value) {
            this.put("explain", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetAggregateFieldsQueryParams
    extends HashMap<String, Object> {
        public GetAggregateFieldsQueryParams index(String value) {
            this.put("index", EncodingUtils.encode(value));
            return this;
        }

        public GetAggregateFieldsQueryParams field(String value) {
            this.put("field", EncodingUtils.encode(value));
            return this;
        }

        public GetAggregateFieldsQueryParams value(String value) {
            this.put("value", EncodingUtils.encode(value));
            return this;
        }

        public GetAggregateFieldsQueryParams sourceFields(String value) {
            this.put("sourceFields", EncodingUtils.encode(value));
            return this;
        }

        public GetAggregateFieldsQueryParams q(String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }

        public GetAggregateFieldsQueryParams size(Integer value) {
            this.put("size", EncodingUtils.encode(value));
            return this;
        }

        public GetAggregateFieldsQueryParams deleted(Boolean value) {
            this.put("deleted", EncodingUtils.encode(value));
            return this;
        }
    }
}

