/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.ColumnLineage;
import org.openmetadata.client.model.EntityReference;

@JsonPropertyOrder(value={"assetEdges", "columnsLineage", "createdAt", "createdBy", "description", "pipeline", "source", "sqlQuery", "updatedAt", "updatedBy"})
public class LineageDetails {
    public static final String JSON_PROPERTY_ASSET_EDGES = "assetEdges";
    private Integer assetEdges;
    public static final String JSON_PROPERTY_COLUMNS_LINEAGE = "columnsLineage";
    private List<ColumnLineage> columnsLineage;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private Long createdAt;
    public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
    private String createdBy;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_PIPELINE = "pipeline";
    private EntityReference pipeline;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private SourceEnum source;
    public static final String JSON_PROPERTY_SQL_QUERY = "sqlQuery";
    private String sqlQuery;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private Long updatedAt;
    public static final String JSON_PROPERTY_UPDATED_BY = "updatedBy";
    private String updatedBy;

    public LineageDetails assetEdges(Integer assetEdges) {
        this.assetEdges = assetEdges;
        return this;
    }

    @Nullable
    @JsonProperty(value="assetEdges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAssetEdges() {
        return this.assetEdges;
    }

    @JsonProperty(value="assetEdges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssetEdges(Integer assetEdges) {
        this.assetEdges = assetEdges;
    }

    public LineageDetails columnsLineage(List<ColumnLineage> columnsLineage) {
        this.columnsLineage = columnsLineage;
        return this;
    }

    public LineageDetails addColumnsLineageItem(ColumnLineage columnsLineageItem) {
        if (this.columnsLineage == null) {
            this.columnsLineage = new ArrayList<ColumnLineage>();
        }
        this.columnsLineage.add(columnsLineageItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="columnsLineage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ColumnLineage> getColumnsLineage() {
        return this.columnsLineage;
    }

    @JsonProperty(value="columnsLineage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColumnsLineage(List<ColumnLineage> columnsLineage) {
        this.columnsLineage = columnsLineage;
    }

    public LineageDetails createdAt(Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public LineageDetails createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="createdBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedBy() {
        return this.createdBy;
    }

    @JsonProperty(value="createdBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public LineageDetails description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public LineageDetails pipeline(EntityReference pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    @Nullable
    @JsonProperty(value="pipeline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityReference getPipeline() {
        return this.pipeline;
    }

    @JsonProperty(value="pipeline")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPipeline(EntityReference pipeline) {
        this.pipeline = pipeline;
    }

    public LineageDetails source(SourceEnum source) {
        this.source = source;
        return this;
    }

    @Nullable
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SourceEnum getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public LineageDetails sqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
        return this;
    }

    @Nullable
    @JsonProperty(value="sqlQuery")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSqlQuery() {
        return this.sqlQuery;
    }

    @JsonProperty(value="sqlQuery")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
    }

    public LineageDetails updatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public LineageDetails updatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @JsonProperty(value="updatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineageDetails lineageDetails = (LineageDetails)o;
        return Objects.equals(this.assetEdges, lineageDetails.assetEdges) && Objects.equals(this.columnsLineage, lineageDetails.columnsLineage) && Objects.equals(this.createdAt, lineageDetails.createdAt) && Objects.equals(this.createdBy, lineageDetails.createdBy) && Objects.equals(this.description, lineageDetails.description) && Objects.equals(this.pipeline, lineageDetails.pipeline) && Objects.equals((Object)this.source, (Object)lineageDetails.source) && Objects.equals(this.sqlQuery, lineageDetails.sqlQuery) && Objects.equals(this.updatedAt, lineageDetails.updatedAt) && Objects.equals(this.updatedBy, lineageDetails.updatedBy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.assetEdges, this.columnsLineage, this.createdAt, this.createdBy, this.description, this.pipeline, this.source, this.sqlQuery, this.updatedAt, this.updatedBy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LineageDetails {\n");
        sb.append("    assetEdges: ").append(this.toIndentedString(this.assetEdges)).append("\n");
        sb.append("    columnsLineage: ").append(this.toIndentedString(this.columnsLineage)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    pipeline: ").append(this.toIndentedString(this.pipeline)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    sqlQuery: ").append(this.toIndentedString(this.sqlQuery)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SourceEnum {
        MANUAL("Manual"),
        VIEWLINEAGE("ViewLineage"),
        QUERYLINEAGE("QueryLineage"),
        PIPELINELINEAGE("PipelineLineage"),
        DASHBOARDLINEAGE("DashboardLineage"),
        DBTLINEAGE("DbtLineage"),
        SPARKLINEAGE("SparkLineage"),
        OPENLINEAGE("OpenLineage"),
        EXTERNALTABLELINEAGE("ExternalTableLineage"),
        CROSSDATABASELINEAGE("CrossDatabaseLineage"),
        CHILDASSETS("ChildAssets");

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceEnum fromValue(String value) {
            for (SourceEnum b : SourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

