/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"children", "description", "displayName", "fullyQualifiedName", "href", "id", "isJoinable", "name", "teamType"})
public class TeamHierarchy {
    public static final String JSON_PROPERTY_CHILDREN = "children";
    private List<TeamHierarchy> children;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
    private String fullyQualifiedName;
    public static final String JSON_PROPERTY_HREF = "href";
    private URI href;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_IS_JOINABLE = "isJoinable";
    private Boolean isJoinable;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TEAM_TYPE = "teamType";
    private TeamTypeEnum teamType;

    public TeamHierarchy children(List<TeamHierarchy> children) {
        this.children = children;
        return this;
    }

    public TeamHierarchy addChildrenItem(TeamHierarchy childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<TeamHierarchy>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TeamHierarchy> getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildren(List<TeamHierarchy> children) {
        this.children = children;
    }

    public TeamHierarchy description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public TeamHierarchy displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public TeamHierarchy fullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        return this;
    }

    @Nullable
    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public TeamHierarchy href(URI href) {
        this.href = href;
        return this;
    }

    @Nullable
    @JsonProperty(value="href")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getHref() {
        return this.href;
    }

    @JsonProperty(value="href")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHref(URI href) {
        this.href = href;
    }

    public TeamHierarchy id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(UUID id) {
        this.id = id;
    }

    public TeamHierarchy isJoinable(Boolean isJoinable) {
        this.isJoinable = isJoinable;
        return this;
    }

    @Nullable
    @JsonProperty(value="isJoinable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsJoinable() {
        return this.isJoinable;
    }

    @JsonProperty(value="isJoinable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsJoinable(Boolean isJoinable) {
        this.isJoinable = isJoinable;
    }

    public TeamHierarchy name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public TeamHierarchy teamType(TeamTypeEnum teamType) {
        this.teamType = teamType;
        return this;
    }

    @Nullable
    @JsonProperty(value="teamType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TeamTypeEnum getTeamType() {
        return this.teamType;
    }

    @JsonProperty(value="teamType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTeamType(TeamTypeEnum teamType) {
        this.teamType = teamType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeamHierarchy teamHierarchy = (TeamHierarchy)o;
        return Objects.equals(this.children, teamHierarchy.children) && Objects.equals(this.description, teamHierarchy.description) && Objects.equals(this.displayName, teamHierarchy.displayName) && Objects.equals(this.fullyQualifiedName, teamHierarchy.fullyQualifiedName) && Objects.equals(this.href, teamHierarchy.href) && Objects.equals(this.id, teamHierarchy.id) && Objects.equals(this.isJoinable, teamHierarchy.isJoinable) && Objects.equals(this.name, teamHierarchy.name) && Objects.equals((Object)this.teamType, (Object)teamHierarchy.teamType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.children, this.description, this.displayName, this.fullyQualifiedName, this.href, this.id, this.isJoinable, this.name, this.teamType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TeamHierarchy {\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    fullyQualifiedName: ").append(this.toIndentedString(this.fullyQualifiedName)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isJoinable: ").append(this.toIndentedString(this.isJoinable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    teamType: ").append(this.toIndentedString((Object)this.teamType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TeamTypeEnum {
        GROUP("Group"),
        DEPARTMENT("Department"),
        DIVISION("Division"),
        BUSINESSUNIT("BusinessUnit"),
        ORGANIZATION("Organization");

        private String value;

        private TeamTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TeamTypeEnum fromValue(String value) {
            for (TeamTypeEnum b : TeamTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

