/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CSVExportResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateDatabase;
import org.openmetadata.client.model.CsvImportResult;
import org.openmetadata.client.model.Database;
import org.openmetadata.client.model.DatabaseList;
import org.openmetadata.client.model.DatabaseProfilerConfig;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;

public interface DatabasesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/databases/{id}/databaseProfilerConfig")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Database addDataProfilerConfig(@Param(value="id") UUID var1, DatabaseProfilerConfig var2);

    @RequestLine(value="PUT /v1/databases/{id}/databaseProfilerConfig")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Database> addDataProfilerConfigWithHttpInfo(@Param(value="id") UUID var1, DatabaseProfilerConfig var2);

    @RequestLine(value="PUT /v1/databases/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToDatabase(@Param(value="id") UUID var1, String var2);

    @RequestLine(value="PUT /v1/databases/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToDatabaseWithHttpInfo(@Param(value="id") UUID var1, String var2);

    @RequestLine(value="POST /v1/databases")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Database createDatabase(CreateDatabase var1);

    @RequestLine(value="POST /v1/databases")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Database> createDatabaseWithHttpInfo(CreateDatabase var1);

    @RequestLine(value="PUT /v1/databases")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Database createOrUpdateDatabase(CreateDatabase var1);

    @RequestLine(value="PUT /v1/databases")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Database> createOrUpdateDatabaseWithHttpInfo(CreateDatabase var1);

    @RequestLine(value="DELETE /v1/databases/{id}/databaseProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public Database deleteDataProfilerConfig(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/databases/{id}/databaseProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Database> deleteDataProfilerConfigWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="DELETE /v1/databases/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDatabase(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/databases/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDatabaseWithHttpInfo(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/databases/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDatabase(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteDatabaseQueryParams var2);

    @RequestLine(value="DELETE /v1/databases/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDatabaseWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteDatabaseQueryParams var2);

    @RequestLine(value="DELETE /v1/databases/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDatabaseAsync(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/databases/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDatabaseAsyncWithHttpInfo(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/databases/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDatabaseAsync(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteDatabaseAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/databases/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDatabaseAsyncWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteDatabaseAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/databases/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDatabaseByFQN(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/databases/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDatabaseByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/databases/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDatabaseByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteDatabaseByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/databases/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDatabaseByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) DeleteDatabaseByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/databases/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower1(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/databases/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower1WithHttpInfo(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="GET /v1/databases/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public String exportDatabase(@Param(value="name") String var1, @Param(value="recursive") Boolean var2);

    @RequestLine(value="GET /v1/databases/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportDatabaseWithHttpInfo(@Param(value="name") String var1, @Param(value="recursive") Boolean var2);

    @RequestLine(value="GET /v1/databases/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public String exportDatabase(@Param(value="name") String var1, @QueryMap(encoded=true) ExportDatabaseQueryParams var2);

    @RequestLine(value="GET /v1/databases/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportDatabaseWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) ExportDatabaseQueryParams var2);

    @RequestLine(value="GET /v1/databases/name/{name}/exportAsync?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public CSVExportResponse exportDatabase1(@Param(value="name") String var1, @Param(value="recursive") Boolean var2);

    @RequestLine(value="GET /v1/databases/name/{name}/exportAsync?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CSVExportResponse> exportDatabase1WithHttpInfo(@Param(value="name") String var1, @Param(value="recursive") Boolean var2);

    @RequestLine(value="GET /v1/databases/name/{name}/exportAsync?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public CSVExportResponse exportDatabase1(@Param(value="name") String var1, @QueryMap(encoded=true) ExportDatabase1QueryParams var2);

    @RequestLine(value="GET /v1/databases/name/{name}/exportAsync?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CSVExportResponse> exportDatabase1WithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) ExportDatabase1QueryParams var2);

    @RequestLine(value="GET /v1/databases/{id}/databaseProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public Database getDataProfilerConfig(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/databases/{id}/databaseProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Database> getDataProfilerConfigWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/databases/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Database getDatabaseByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/databases/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Database> getDatabaseByFQNWithHttpInfo(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/databases/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Database getDatabaseByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetDatabaseByFQNQueryParams var2);

    @RequestLine(value="GET /v1/databases/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Database> getDatabaseByFQNWithHttpInfo(@Param(value="fqn") String var1, @QueryMap(encoded=true) GetDatabaseByFQNQueryParams var2);

    @RequestLine(value="GET /v1/databases/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Database getDatabaseByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/databases/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Database> getDatabaseByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/databases/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Database getDatabaseByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetDatabaseByIDQueryParams var2);

    @RequestLine(value="GET /v1/databases/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Database> getDatabaseByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetDatabaseByIDQueryParams var2);

    @RequestLine(value="GET /v1/databases/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Database getSpecificDatabaseVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/databases/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Database> getSpecificDatabaseVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="PUT /v1/databases/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset&#x3D;UTF-8", "Accept: application/json"})
    public CsvImportResult importDatabase(@Param(value="name") String var1, @Param(value="dryRun") Boolean var2, @Param(value="recursive") Boolean var3, String var4);

    @RequestLine(value="PUT /v1/databases/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset&#x3D;UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDatabaseWithHttpInfo(@Param(value="name") String var1, @Param(value="dryRun") Boolean var2, @Param(value="recursive") Boolean var3, String var4);

    @RequestLine(value="PUT /v1/databases/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset&#x3D;UTF-8", "Accept: application/json"})
    public CsvImportResult importDatabase(@Param(value="name") String var1, String var2, @QueryMap(encoded=true) ImportDatabaseQueryParams var3);

    @RequestLine(value="PUT /v1/databases/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset&#x3D;UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDatabaseWithHttpInfo(@Param(value="name") String var1, String var2, @QueryMap(encoded=true) ImportDatabaseQueryParams var3);

    @RequestLine(value="PUT /v1/databases/name/{name}/importAsync?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset&#x3D;UTF-8", "Accept: application/json"})
    public CsvImportResult importDatabaseAsync(@Param(value="name") String var1, @Param(value="dryRun") Boolean var2, @Param(value="recursive") Boolean var3, String var4);

    @RequestLine(value="PUT /v1/databases/name/{name}/importAsync?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset&#x3D;UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDatabaseAsyncWithHttpInfo(@Param(value="name") String var1, @Param(value="dryRun") Boolean var2, @Param(value="recursive") Boolean var3, String var4);

    @RequestLine(value="PUT /v1/databases/name/{name}/importAsync?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset&#x3D;UTF-8", "Accept: application/json"})
    public CsvImportResult importDatabaseAsync(@Param(value="name") String var1, String var2, @QueryMap(encoded=true) ImportDatabaseAsyncQueryParams var3);

    @RequestLine(value="PUT /v1/databases/name/{name}/importAsync?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset&#x3D;UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDatabaseAsyncWithHttpInfo(@Param(value="name") String var1, String var2, @QueryMap(encoded=true) ImportDatabaseAsyncQueryParams var3);

    @RequestLine(value="GET /v1/databases/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllDatabaseVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/databases/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllDatabaseVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/databases?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseList listDatabases(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/databases?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseList> listDatabasesWithHttpInfo(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/databases?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseList listDatabases(@QueryMap(encoded=true) ListDatabasesQueryParams var1);

    @RequestLine(value="GET /v1/databases?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseList> listDatabasesWithHttpInfo(@QueryMap(encoded=true) ListDatabasesQueryParams var1);

    @RequestLine(value="PATCH /v1/databases/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDatabase(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/databases/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDatabaseWithHttpInfo(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/databases/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDatabase1(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/databases/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDatabase1WithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/databases/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Database restore7(RestoreEntity var1);

    @RequestLine(value="PUT /v1/databases/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Database> restore7WithHttpInfo(RestoreEntity var1);

    @RequestLine(value="PUT /v1/databases/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity2(@Param(value="id") UUID var1, VoteRequest var2);

    @RequestLine(value="PUT /v1/databases/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity2WithHttpInfo(@Param(value="id") UUID var1, VoteRequest var2);

    public static class ListDatabasesQueryParams
    extends HashMap<String, Object> {
        public ListDatabasesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDatabasesQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListDatabasesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDatabasesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDatabasesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListDatabasesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportDatabaseAsyncQueryParams
    extends HashMap<String, Object> {
        public ImportDatabaseAsyncQueryParams dryRun(Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }

        public ImportDatabaseAsyncQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportDatabaseQueryParams
    extends HashMap<String, Object> {
        public ImportDatabaseQueryParams dryRun(Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }

        public ImportDatabaseQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDatabaseByIDQueryParams
    extends HashMap<String, Object> {
        public GetDatabaseByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDatabaseByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDatabaseByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDatabaseByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDatabaseByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ExportDatabase1QueryParams
    extends HashMap<String, Object> {
        public ExportDatabase1QueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ExportDatabaseQueryParams
    extends HashMap<String, Object> {
        public ExportDatabaseQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDatabaseByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteDatabaseByFQNQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDatabaseByFQNQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDatabaseAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteDatabaseAsyncQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDatabaseAsyncQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDatabaseQueryParams
    extends HashMap<String, Object> {
        public DeleteDatabaseQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDatabaseQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

