/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateMessagingService;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.MessagingService;
import org.openmetadata.client.model.MessagingServiceList;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestConnectionResult;

public interface MessagingServicesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/messagingServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToDatabaseService1(@Param(value="id") UUID var1, String var2);

    @RequestLine(value="PUT /v1/services/messagingServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToDatabaseService1WithHttpInfo(@Param(value="id") UUID var1, String var2);

    @RequestLine(value="PUT /v1/services/messagingServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MessagingService addTestConnectionResult3(@Param(value="id") UUID var1, TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/messagingServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MessagingService> addTestConnectionResult3WithHttpInfo(@Param(value="id") UUID var1, TestConnectionResult var2);

    @RequestLine(value="POST /v1/services/messagingServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MessagingService createMessagingService(CreateMessagingService var1);

    @RequestLine(value="POST /v1/services/messagingServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MessagingService> createMessagingServiceWithHttpInfo(CreateMessagingService var1);

    @RequestLine(value="PUT /v1/services/messagingServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MessagingService createOrUpdateMessagingService(CreateMessagingService var1);

    @RequestLine(value="PUT /v1/services/messagingServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MessagingService> createOrUpdateMessagingServiceWithHttpInfo(CreateMessagingService var1);

    @RequestLine(value="DELETE /v1/services/messagingServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower14(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/services/messagingServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower14WithHttpInfo(@Param(value="id") UUID var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/services/messagingServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMessagingService(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/messagingServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMessagingServiceWithHttpInfo(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/messagingServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMessagingService(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteMessagingServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/messagingServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMessagingServiceWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteMessagingServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/messagingServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMessagingServiceAsync(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/messagingServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMessagingServiceAsyncWithHttpInfo(@Param(value="id") UUID var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/services/messagingServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMessagingServiceAsync(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteMessagingServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/messagingServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMessagingServiceAsyncWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) DeleteMessagingServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/messagingServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteMessagingServiceByName(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/services/messagingServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMessagingServiceByNameWithHttpInfo(@Param(value="name") String var1, @Param(value="hardDelete") Boolean var2, @Param(value="recursive") Boolean var3);

    @RequestLine(value="DELETE /v1/services/messagingServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteMessagingServiceByName(@Param(value="name") String var1, @QueryMap(encoded=true) DeleteMessagingServiceByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/services/messagingServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMessagingServiceByNameWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) DeleteMessagingServiceByNameQueryParams var2);

    @RequestLine(value="GET /v1/services/messagingServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MessagingService getMessagingServiceByFQN(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/messagingServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MessagingService> getMessagingServiceByFQNWithHttpInfo(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/messagingServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MessagingService getMessagingServiceByFQN(@Param(value="name") String var1, @QueryMap(encoded=true) GetMessagingServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/messagingServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MessagingService> getMessagingServiceByFQNWithHttpInfo(@Param(value="name") String var1, @QueryMap(encoded=true) GetMessagingServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/messagingServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MessagingService getMessagingServiceByID(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/messagingServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MessagingService> getMessagingServiceByIDWithHttpInfo(@Param(value="id") UUID var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/messagingServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MessagingService getMessagingServiceByID(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetMessagingServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/messagingServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MessagingService> getMessagingServiceByIDWithHttpInfo(@Param(value="id") UUID var1, @QueryMap(encoded=true) GetMessagingServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/messagingServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public MessagingService getSpecificMessagingServiceVersion(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/services/messagingServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MessagingService> getSpecificMessagingServiceVersionWithHttpInfo(@Param(value="id") UUID var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/services/messagingServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllMessagingServiceVersion(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/services/messagingServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllMessagingServiceVersionWithHttpInfo(@Param(value="id") UUID var1);

    @RequestLine(value="GET /v1/services/messagingServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MessagingServiceList listMessagingService(@Param(value="fields") String var1, @Param(value="domain") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/services/messagingServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MessagingServiceList> listMessagingServiceWithHttpInfo(@Param(value="fields") String var1, @Param(value="domain") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/services/messagingServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MessagingServiceList listMessagingService(@QueryMap(encoded=true) ListMessagingServiceQueryParams var1);

    @RequestLine(value="GET /v1/services/messagingServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MessagingServiceList> listMessagingServiceWithHttpInfo(@QueryMap(encoded=true) ListMessagingServiceQueryParams var1);

    @RequestLine(value="PATCH /v1/services/messagingServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchMessagingService(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/services/messagingServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchMessagingServiceWithHttpInfo(@Param(value="fqn") String var1, Object var2);

    @RequestLine(value="PATCH /v1/services/messagingServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchMessagingService1(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PATCH /v1/services/messagingServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchMessagingService1WithHttpInfo(@Param(value="id") UUID var1, Object var2);

    @RequestLine(value="PUT /v1/services/messagingServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MessagingService restore28(RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/messagingServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MessagingService> restore28WithHttpInfo(RestoreEntity var1);

    public static class ListMessagingServiceQueryParams
    extends HashMap<String, Object> {
        public ListMessagingServiceQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListMessagingServiceQueryParams domain(String value) {
            this.put("domain", EncodingUtils.encode(value));
            return this;
        }

        public ListMessagingServiceQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListMessagingServiceQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListMessagingServiceQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListMessagingServiceQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetMessagingServiceByIDQueryParams
    extends HashMap<String, Object> {
        public GetMessagingServiceByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetMessagingServiceByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetMessagingServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public GetMessagingServiceByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetMessagingServiceByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMessagingServiceByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteMessagingServiceByNameQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteMessagingServiceByNameQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMessagingServiceAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteMessagingServiceAsyncQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteMessagingServiceAsyncQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMessagingServiceQueryParams
    extends HashMap<String, Object> {
        public DeleteMessagingServiceQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteMessagingServiceQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

