/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.openmetadata.client.model.AppSchedule;
import org.openmetadata.client.model.EntityReference;
import org.openmetadata.client.model.FailureContext;
import org.openmetadata.client.model.SuccessContext;

@JsonPropertyOrder(value={"appId", "appName", "config", "endTime", "executionTime", "extension", "failureContext", "properties", "runType", "scheduleInfo", "services", "startTime", "status", "successContext", "timestamp"})
public class AppRunRecord {
    public static final String JSON_PROPERTY_APP_ID = "appId";
    private UUID appId;
    public static final String JSON_PROPERTY_APP_NAME = "appName";
    private String appName;
    public static final String JSON_PROPERTY_CONFIG = "config";
    private Map<String, Object> config = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_END_TIME = "endTime";
    private Long endTime;
    public static final String JSON_PROPERTY_EXECUTION_TIME = "executionTime";
    private Long executionTime;
    public static final String JSON_PROPERTY_EXTENSION = "extension";
    private String extension;
    public static final String JSON_PROPERTY_FAILURE_CONTEXT = "failureContext";
    private FailureContext failureContext;
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private Map<String, Object> properties = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_RUN_TYPE = "runType";
    private String runType;
    public static final String JSON_PROPERTY_SCHEDULE_INFO = "scheduleInfo";
    private AppSchedule scheduleInfo;
    public static final String JSON_PROPERTY_SERVICES = "services";
    private List<EntityReference> services;
    public static final String JSON_PROPERTY_START_TIME = "startTime";
    private Long startTime;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_SUCCESS_CONTEXT = "successContext";
    private SuccessContext successContext;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private Long timestamp;

    public AppRunRecord appId(UUID appId) {
        this.appId = appId;
        return this;
    }

    @Nullable
    @JsonProperty(value="appId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getAppId() {
        return this.appId;
    }

    @JsonProperty(value="appId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppId(UUID appId) {
        this.appId = appId;
    }

    public AppRunRecord appName(String appName) {
        this.appName = appName;
        return this;
    }

    @Nullable
    @JsonProperty(value="appName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAppName() {
        return this.appName;
    }

    @JsonProperty(value="appName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppName(String appName) {
        this.appName = appName;
    }

    public AppRunRecord config(Map<String, Object> config) {
        this.config = config;
        return this;
    }

    public AppRunRecord putConfigItem(String key, Object configItem) {
        if (this.config == null) {
            this.config = new HashMap<String, Object>();
        }
        this.config.put(key, configItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    public AppRunRecord endTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="endTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getEndTime() {
        return this.endTime;
    }

    @JsonProperty(value="endTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public AppRunRecord executionTime(Long executionTime) {
        this.executionTime = executionTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="executionTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getExecutionTime() {
        return this.executionTime;
    }

    @JsonProperty(value="executionTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExecutionTime(Long executionTime) {
        this.executionTime = executionTime;
    }

    public AppRunRecord extension(String extension) {
        this.extension = extension;
        return this;
    }

    @Nullable
    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExtension() {
        return this.extension;
    }

    @JsonProperty(value="extension")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtension(String extension) {
        this.extension = extension;
    }

    public AppRunRecord failureContext(FailureContext failureContext) {
        this.failureContext = failureContext;
        return this;
    }

    @Nullable
    @JsonProperty(value="failureContext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FailureContext getFailureContext() {
        return this.failureContext;
    }

    @JsonProperty(value="failureContext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailureContext(FailureContext failureContext) {
        this.failureContext = failureContext;
    }

    public AppRunRecord properties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public AppRunRecord putPropertiesItem(String key, Object propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public AppRunRecord runType(String runType) {
        this.runType = runType;
        return this;
    }

    @Nullable
    @JsonProperty(value="runType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRunType() {
        return this.runType;
    }

    @JsonProperty(value="runType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRunType(String runType) {
        this.runType = runType;
    }

    public AppRunRecord scheduleInfo(AppSchedule scheduleInfo) {
        this.scheduleInfo = scheduleInfo;
        return this;
    }

    @Nullable
    @JsonProperty(value="scheduleInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AppSchedule getScheduleInfo() {
        return this.scheduleInfo;
    }

    @JsonProperty(value="scheduleInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScheduleInfo(AppSchedule scheduleInfo) {
        this.scheduleInfo = scheduleInfo;
    }

    public AppRunRecord services(List<EntityReference> services) {
        this.services = services;
        return this;
    }

    public AppRunRecord addServicesItem(EntityReference servicesItem) {
        if (this.services == null) {
            this.services = new ArrayList<EntityReference>();
        }
        this.services.add(servicesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="services")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EntityReference> getServices() {
        return this.services;
    }

    @JsonProperty(value="services")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setServices(List<EntityReference> services) {
        this.services = services;
    }

    public AppRunRecord startTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="startTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="startTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public AppRunRecord status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AppRunRecord successContext(SuccessContext successContext) {
        this.successContext = successContext;
        return this;
    }

    @Nullable
    @JsonProperty(value="successContext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SuccessContext getSuccessContext() {
        return this.successContext;
    }

    @JsonProperty(value="successContext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSuccessContext(SuccessContext successContext) {
        this.successContext = successContext;
    }

    public AppRunRecord timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppRunRecord appRunRecord = (AppRunRecord)o;
        return Objects.equals(this.appId, appRunRecord.appId) && Objects.equals(this.appName, appRunRecord.appName) && Objects.equals(this.config, appRunRecord.config) && Objects.equals(this.endTime, appRunRecord.endTime) && Objects.equals(this.executionTime, appRunRecord.executionTime) && Objects.equals(this.extension, appRunRecord.extension) && Objects.equals(this.failureContext, appRunRecord.failureContext) && Objects.equals(this.properties, appRunRecord.properties) && Objects.equals(this.runType, appRunRecord.runType) && Objects.equals(this.scheduleInfo, appRunRecord.scheduleInfo) && Objects.equals(this.services, appRunRecord.services) && Objects.equals(this.startTime, appRunRecord.startTime) && Objects.equals((Object)this.status, (Object)appRunRecord.status) && Objects.equals(this.successContext, appRunRecord.successContext) && Objects.equals(this.timestamp, appRunRecord.timestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appId, this.appName, this.config, this.endTime, this.executionTime, this.extension, this.failureContext, this.properties, this.runType, this.scheduleInfo, this.services, this.startTime, this.status, this.successContext, this.timestamp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppRunRecord {\n");
        sb.append("    appId: ").append(this.toIndentedString(this.appId)).append("\n");
        sb.append("    appName: ").append(this.toIndentedString(this.appName)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    executionTime: ").append(this.toIndentedString(this.executionTime)).append("\n");
        sb.append("    extension: ").append(this.toIndentedString(this.extension)).append("\n");
        sb.append("    failureContext: ").append(this.toIndentedString(this.failureContext)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    runType: ").append(this.toIndentedString(this.runType)).append("\n");
        sb.append("    scheduleInfo: ").append(this.toIndentedString(this.scheduleInfo)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    successContext: ").append(this.toIndentedString(this.successContext)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        STARTED("started"),
        RUNNING("running"),
        COMPLETED("completed"),
        FAILED("failed"),
        ACTIVE("active"),
        ACTIVEERROR("activeError"),
        STOPPED("stopped"),
        SUCCESS("success"),
        PENDING("pending");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

