/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.model.Aggregation;
import org.openmetadata.client.model.FieldBoost;
import org.openmetadata.client.model.FieldValueBoost;
import org.openmetadata.client.model.TermBoost;

@JsonPropertyOrder(value={"additionalSettings", "aggregations", "assetType", "boostMode", "fieldValueBoosts", "highlightFields", "scoreMode", "searchFields", "termBoosts"})
public class AssetTypeConfiguration {
    public static final String JSON_PROPERTY_ADDITIONAL_SETTINGS = "additionalSettings";
    private Object additionalSettings;
    public static final String JSON_PROPERTY_AGGREGATIONS = "aggregations";
    private List<Aggregation> aggregations;
    public static final String JSON_PROPERTY_ASSET_TYPE = "assetType";
    private String assetType;
    public static final String JSON_PROPERTY_BOOST_MODE = "boostMode";
    private BoostModeEnum boostMode;
    public static final String JSON_PROPERTY_FIELD_VALUE_BOOSTS = "fieldValueBoosts";
    private List<FieldValueBoost> fieldValueBoosts;
    public static final String JSON_PROPERTY_HIGHLIGHT_FIELDS = "highlightFields";
    private List<String> highlightFields;
    public static final String JSON_PROPERTY_SCORE_MODE = "scoreMode";
    private ScoreModeEnum scoreMode;
    public static final String JSON_PROPERTY_SEARCH_FIELDS = "searchFields";
    private List<FieldBoost> searchFields;
    public static final String JSON_PROPERTY_TERM_BOOSTS = "termBoosts";
    private List<TermBoost> termBoosts;

    public AssetTypeConfiguration additionalSettings(Object additionalSettings) {
        this.additionalSettings = additionalSettings;
        return this;
    }

    @Nullable
    @JsonProperty(value="additionalSettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getAdditionalSettings() {
        return this.additionalSettings;
    }

    @JsonProperty(value="additionalSettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalSettings(Object additionalSettings) {
        this.additionalSettings = additionalSettings;
    }

    public AssetTypeConfiguration aggregations(List<Aggregation> aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    public AssetTypeConfiguration addAggregationsItem(Aggregation aggregationsItem) {
        if (this.aggregations == null) {
            this.aggregations = new ArrayList<Aggregation>();
        }
        this.aggregations.add(aggregationsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="aggregations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Aggregation> getAggregations() {
        return this.aggregations;
    }

    @JsonProperty(value="aggregations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAggregations(List<Aggregation> aggregations) {
        this.aggregations = aggregations;
    }

    public AssetTypeConfiguration assetType(String assetType) {
        this.assetType = assetType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="assetType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAssetType() {
        return this.assetType;
    }

    @JsonProperty(value="assetType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAssetType(String assetType) {
        this.assetType = assetType;
    }

    public AssetTypeConfiguration boostMode(BoostModeEnum boostMode) {
        this.boostMode = boostMode;
        return this;
    }

    @Nullable
    @JsonProperty(value="boostMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BoostModeEnum getBoostMode() {
        return this.boostMode;
    }

    @JsonProperty(value="boostMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBoostMode(BoostModeEnum boostMode) {
        this.boostMode = boostMode;
    }

    public AssetTypeConfiguration fieldValueBoosts(List<FieldValueBoost> fieldValueBoosts) {
        this.fieldValueBoosts = fieldValueBoosts;
        return this;
    }

    public AssetTypeConfiguration addFieldValueBoostsItem(FieldValueBoost fieldValueBoostsItem) {
        if (this.fieldValueBoosts == null) {
            this.fieldValueBoosts = new ArrayList<FieldValueBoost>();
        }
        this.fieldValueBoosts.add(fieldValueBoostsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="fieldValueBoosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FieldValueBoost> getFieldValueBoosts() {
        return this.fieldValueBoosts;
    }

    @JsonProperty(value="fieldValueBoosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFieldValueBoosts(List<FieldValueBoost> fieldValueBoosts) {
        this.fieldValueBoosts = fieldValueBoosts;
    }

    public AssetTypeConfiguration highlightFields(List<String> highlightFields) {
        this.highlightFields = highlightFields;
        return this;
    }

    public AssetTypeConfiguration addHighlightFieldsItem(String highlightFieldsItem) {
        if (this.highlightFields == null) {
            this.highlightFields = new ArrayList<String>();
        }
        this.highlightFields.add(highlightFieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="highlightFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getHighlightFields() {
        return this.highlightFields;
    }

    @JsonProperty(value="highlightFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHighlightFields(List<String> highlightFields) {
        this.highlightFields = highlightFields;
    }

    public AssetTypeConfiguration scoreMode(ScoreModeEnum scoreMode) {
        this.scoreMode = scoreMode;
        return this;
    }

    @Nullable
    @JsonProperty(value="scoreMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScoreModeEnum getScoreMode() {
        return this.scoreMode;
    }

    @JsonProperty(value="scoreMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScoreMode(ScoreModeEnum scoreMode) {
        this.scoreMode = scoreMode;
    }

    public AssetTypeConfiguration searchFields(List<FieldBoost> searchFields) {
        this.searchFields = searchFields;
        return this;
    }

    public AssetTypeConfiguration addSearchFieldsItem(FieldBoost searchFieldsItem) {
        if (this.searchFields == null) {
            this.searchFields = new ArrayList<FieldBoost>();
        }
        this.searchFields.add(searchFieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="searchFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FieldBoost> getSearchFields() {
        return this.searchFields;
    }

    @JsonProperty(value="searchFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSearchFields(List<FieldBoost> searchFields) {
        this.searchFields = searchFields;
    }

    public AssetTypeConfiguration termBoosts(List<TermBoost> termBoosts) {
        this.termBoosts = termBoosts;
        return this;
    }

    public AssetTypeConfiguration addTermBoostsItem(TermBoost termBoostsItem) {
        if (this.termBoosts == null) {
            this.termBoosts = new ArrayList<TermBoost>();
        }
        this.termBoosts.add(termBoostsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="termBoosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TermBoost> getTermBoosts() {
        return this.termBoosts;
    }

    @JsonProperty(value="termBoosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTermBoosts(List<TermBoost> termBoosts) {
        this.termBoosts = termBoosts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetTypeConfiguration assetTypeConfiguration = (AssetTypeConfiguration)o;
        return Objects.equals(this.additionalSettings, assetTypeConfiguration.additionalSettings) && Objects.equals(this.aggregations, assetTypeConfiguration.aggregations) && Objects.equals(this.assetType, assetTypeConfiguration.assetType) && Objects.equals((Object)this.boostMode, (Object)assetTypeConfiguration.boostMode) && Objects.equals(this.fieldValueBoosts, assetTypeConfiguration.fieldValueBoosts) && Objects.equals(this.highlightFields, assetTypeConfiguration.highlightFields) && Objects.equals((Object)this.scoreMode, (Object)assetTypeConfiguration.scoreMode) && Objects.equals(this.searchFields, assetTypeConfiguration.searchFields) && Objects.equals(this.termBoosts, assetTypeConfiguration.termBoosts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalSettings, this.aggregations, this.assetType, this.boostMode, this.fieldValueBoosts, this.highlightFields, this.scoreMode, this.searchFields, this.termBoosts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetTypeConfiguration {\n");
        sb.append("    additionalSettings: ").append(this.toIndentedString(this.additionalSettings)).append("\n");
        sb.append("    aggregations: ").append(this.toIndentedString(this.aggregations)).append("\n");
        sb.append("    assetType: ").append(this.toIndentedString(this.assetType)).append("\n");
        sb.append("    boostMode: ").append(this.toIndentedString((Object)this.boostMode)).append("\n");
        sb.append("    fieldValueBoosts: ").append(this.toIndentedString(this.fieldValueBoosts)).append("\n");
        sb.append("    highlightFields: ").append(this.toIndentedString(this.highlightFields)).append("\n");
        sb.append("    scoreMode: ").append(this.toIndentedString((Object)this.scoreMode)).append("\n");
        sb.append("    searchFields: ").append(this.toIndentedString(this.searchFields)).append("\n");
        sb.append("    termBoosts: ").append(this.toIndentedString(this.termBoosts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum BoostModeEnum {
        MULTIPLY("multiply"),
        REPLACE("replace"),
        SUM("sum"),
        AVG("avg"),
        MAX("max"),
        MIN("min");

        private String value;

        private BoostModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BoostModeEnum fromValue(String value) {
            for (BoostModeEnum b : BoostModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ScoreModeEnum {
        MULTIPLY("multiply"),
        SUM("sum"),
        AVG("avg"),
        FIRST("first"),
        MAX("max"),
        MIN("min");

        private String value;

        private ScoreModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScoreModeEnum fromValue(String value) {
            for (ScoreModeEnum b : ScoreModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

