/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openmetadata.client.model.Aggregation;
import org.openmetadata.client.model.FieldValueBoost;
import org.openmetadata.client.model.TermBoost;

@JsonPropertyOrder(value={"aggregations", "enableAccessControl", "fieldValueBoosts", "highlightFields", "maxAggregateSize", "maxAnalyzedOffset", "maxResultHits", "termBoosts"})
public class GlobalSettings {
    public static final String JSON_PROPERTY_AGGREGATIONS = "aggregations";
    private List<Aggregation> aggregations;
    public static final String JSON_PROPERTY_ENABLE_ACCESS_CONTROL = "enableAccessControl";
    private Boolean enableAccessControl;
    public static final String JSON_PROPERTY_FIELD_VALUE_BOOSTS = "fieldValueBoosts";
    private List<FieldValueBoost> fieldValueBoosts;
    public static final String JSON_PROPERTY_HIGHLIGHT_FIELDS = "highlightFields";
    private List<String> highlightFields;
    public static final String JSON_PROPERTY_MAX_AGGREGATE_SIZE = "maxAggregateSize";
    private Integer maxAggregateSize;
    public static final String JSON_PROPERTY_MAX_ANALYZED_OFFSET = "maxAnalyzedOffset";
    private Integer maxAnalyzedOffset;
    public static final String JSON_PROPERTY_MAX_RESULT_HITS = "maxResultHits";
    private Integer maxResultHits;
    public static final String JSON_PROPERTY_TERM_BOOSTS = "termBoosts";
    private List<TermBoost> termBoosts;

    public GlobalSettings aggregations(List<Aggregation> aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    public GlobalSettings addAggregationsItem(Aggregation aggregationsItem) {
        if (this.aggregations == null) {
            this.aggregations = new ArrayList<Aggregation>();
        }
        this.aggregations.add(aggregationsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="aggregations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Aggregation> getAggregations() {
        return this.aggregations;
    }

    @JsonProperty(value="aggregations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAggregations(List<Aggregation> aggregations) {
        this.aggregations = aggregations;
    }

    public GlobalSettings enableAccessControl(Boolean enableAccessControl) {
        this.enableAccessControl = enableAccessControl;
        return this;
    }

    @Nullable
    @JsonProperty(value="enableAccessControl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnableAccessControl() {
        return this.enableAccessControl;
    }

    @JsonProperty(value="enableAccessControl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnableAccessControl(Boolean enableAccessControl) {
        this.enableAccessControl = enableAccessControl;
    }

    public GlobalSettings fieldValueBoosts(List<FieldValueBoost> fieldValueBoosts) {
        this.fieldValueBoosts = fieldValueBoosts;
        return this;
    }

    public GlobalSettings addFieldValueBoostsItem(FieldValueBoost fieldValueBoostsItem) {
        if (this.fieldValueBoosts == null) {
            this.fieldValueBoosts = new ArrayList<FieldValueBoost>();
        }
        this.fieldValueBoosts.add(fieldValueBoostsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="fieldValueBoosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FieldValueBoost> getFieldValueBoosts() {
        return this.fieldValueBoosts;
    }

    @JsonProperty(value="fieldValueBoosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFieldValueBoosts(List<FieldValueBoost> fieldValueBoosts) {
        this.fieldValueBoosts = fieldValueBoosts;
    }

    public GlobalSettings highlightFields(List<String> highlightFields) {
        this.highlightFields = highlightFields;
        return this;
    }

    public GlobalSettings addHighlightFieldsItem(String highlightFieldsItem) {
        if (this.highlightFields == null) {
            this.highlightFields = new ArrayList<String>();
        }
        this.highlightFields.add(highlightFieldsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="highlightFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getHighlightFields() {
        return this.highlightFields;
    }

    @JsonProperty(value="highlightFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHighlightFields(List<String> highlightFields) {
        this.highlightFields = highlightFields;
    }

    public GlobalSettings maxAggregateSize(Integer maxAggregateSize) {
        this.maxAggregateSize = maxAggregateSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="maxAggregateSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxAggregateSize() {
        return this.maxAggregateSize;
    }

    @JsonProperty(value="maxAggregateSize")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxAggregateSize(Integer maxAggregateSize) {
        this.maxAggregateSize = maxAggregateSize;
    }

    public GlobalSettings maxAnalyzedOffset(Integer maxAnalyzedOffset) {
        this.maxAnalyzedOffset = maxAnalyzedOffset;
        return this;
    }

    @Nullable
    @JsonProperty(value="maxAnalyzedOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxAnalyzedOffset() {
        return this.maxAnalyzedOffset;
    }

    @JsonProperty(value="maxAnalyzedOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxAnalyzedOffset(Integer maxAnalyzedOffset) {
        this.maxAnalyzedOffset = maxAnalyzedOffset;
    }

    public GlobalSettings maxResultHits(Integer maxResultHits) {
        this.maxResultHits = maxResultHits;
        return this;
    }

    @Nullable
    @JsonProperty(value="maxResultHits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxResultHits() {
        return this.maxResultHits;
    }

    @JsonProperty(value="maxResultHits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxResultHits(Integer maxResultHits) {
        this.maxResultHits = maxResultHits;
    }

    public GlobalSettings termBoosts(List<TermBoost> termBoosts) {
        this.termBoosts = termBoosts;
        return this;
    }

    public GlobalSettings addTermBoostsItem(TermBoost termBoostsItem) {
        if (this.termBoosts == null) {
            this.termBoosts = new ArrayList<TermBoost>();
        }
        this.termBoosts.add(termBoostsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="termBoosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TermBoost> getTermBoosts() {
        return this.termBoosts;
    }

    @JsonProperty(value="termBoosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTermBoosts(List<TermBoost> termBoosts) {
        this.termBoosts = termBoosts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalSettings globalSettings = (GlobalSettings)o;
        return Objects.equals(this.aggregations, globalSettings.aggregations) && Objects.equals(this.enableAccessControl, globalSettings.enableAccessControl) && Objects.equals(this.fieldValueBoosts, globalSettings.fieldValueBoosts) && Objects.equals(this.highlightFields, globalSettings.highlightFields) && Objects.equals(this.maxAggregateSize, globalSettings.maxAggregateSize) && Objects.equals(this.maxAnalyzedOffset, globalSettings.maxAnalyzedOffset) && Objects.equals(this.maxResultHits, globalSettings.maxResultHits) && Objects.equals(this.termBoosts, globalSettings.termBoosts);
    }

    public int hashCode() {
        return Objects.hash(this.aggregations, this.enableAccessControl, this.fieldValueBoosts, this.highlightFields, this.maxAggregateSize, this.maxAnalyzedOffset, this.maxResultHits, this.termBoosts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GlobalSettings {\n");
        sb.append("    aggregations: ").append(this.toIndentedString(this.aggregations)).append("\n");
        sb.append("    enableAccessControl: ").append(this.toIndentedString(this.enableAccessControl)).append("\n");
        sb.append("    fieldValueBoosts: ").append(this.toIndentedString(this.fieldValueBoosts)).append("\n");
        sb.append("    highlightFields: ").append(this.toIndentedString(this.highlightFields)).append("\n");
        sb.append("    maxAggregateSize: ").append(this.toIndentedString(this.maxAggregateSize)).append("\n");
        sb.append("    maxAnalyzedOffset: ").append(this.toIndentedString(this.maxAnalyzedOffset)).append("\n");
        sb.append("    maxResultHits: ").append(this.toIndentedString(this.maxResultHits)).append("\n");
        sb.append("    termBoosts: ").append(this.toIndentedString(this.termBoosts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

