/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateDashboardDataModel;
import org.openmetadata.client.model.DashboardDataModel;
import org.openmetadata.client.model.DashboardDataModelList;
import org.openmetadata.client.model.DataModelColumnList;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;

public interface DashboardDataModelsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/dashboard/datamodels/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void addFollowerToDataModel(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/dashboard/datamodels/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> addFollowerToDataModelWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="POST /v1/dashboard/datamodels")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DashboardDataModel createDataModel(@Nullable CreateDashboardDataModel var1);

    @RequestLine(value="POST /v1/dashboard/datamodels")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DashboardDataModel> createDataModelWithHttpInfo(@Nullable CreateDashboardDataModel var1);

    @RequestLine(value="PUT /v1/dashboard/datamodels")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DashboardDataModel createOrUpdateDataModel(@Nullable CreateDashboardDataModel var1);

    @RequestLine(value="PUT /v1/dashboard/datamodels")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DashboardDataModel> createOrUpdateDataModelWithHttpInfo(@Nullable CreateDashboardDataModel var1);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataModel(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataModelWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataModel(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDataModelQueryParams var2);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataModelWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDataModelQueryParams var2);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataModelAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataModelAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataModelAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDataModelAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataModelAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDataModelAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataModelByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataModelByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataModelByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteDataModelByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataModelByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteDataModelByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public void deleteFollowerFromDataModel(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="DELETE /v1/dashboard/datamodels/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteFollowerFromDataModelWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardDataModel getDataModelByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/dashboard/datamodels/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardDataModel> getDataModelByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/dashboard/datamodels/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardDataModel getDataModelByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetDataModelByFQNQueryParams var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardDataModel> getDataModelByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetDataModelByFQNQueryParams var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardDataModel getDataModelByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardDataModel> getDataModelByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardDataModel getDataModelByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDataModelByIDQueryParams var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardDataModel> getDataModelByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDataModelByIDQueryParams var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}/columns?limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DataModelColumnList getDataModelColumns(@Param(value="id") @Nonnull UUID var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3, @Param(value="fields") @Nullable String var4, @Param(value="include") @Nullable String var5);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}/columns?limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataModelColumnList> getDataModelColumnsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3, @Param(value="fields") @Nullable String var4, @Param(value="include") @Nullable String var5);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}/columns?limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DataModelColumnList getDataModelColumns(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDataModelColumnsQueryParams var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}/columns?limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataModelColumnList> getDataModelColumnsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDataModelColumnsQueryParams var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/name/{fqn}/columns?limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DataModelColumnList getDataModelColumnsByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3, @Param(value="fields") @Nullable String var4, @Param(value="include") @Nullable String var5);

    @RequestLine(value="GET /v1/dashboard/datamodels/name/{fqn}/columns?limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataModelColumnList> getDataModelColumnsByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="offset") @Nullable Integer var3, @Param(value="fields") @Nullable String var4, @Param(value="include") @Nullable String var5);

    @RequestLine(value="GET /v1/dashboard/datamodels/name/{fqn}/columns?limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DataModelColumnList getDataModelColumnsByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetDataModelColumnsByFQNQueryParams var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/name/{fqn}/columns?limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataModelColumnList> getDataModelColumnsByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetDataModelColumnsByFQNQueryParams var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public DashboardDataModel getSpecificDataModelVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardDataModel> getSpecificDataModelVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllDataModelVersions(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllDataModelVersionsWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/dashboard/datamodels?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardDataModelList listDashboardDataModels(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/dashboard/datamodels?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardDataModelList> listDashboardDataModelsWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/dashboard/datamodels?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardDataModelList listDashboardDataModels(@QueryMap(encoded=true) ListDashboardDataModelsQueryParams var1);

    @RequestLine(value="GET /v1/dashboard/datamodels?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DashboardDataModelList> listDashboardDataModelsWithHttpInfo(@QueryMap(encoded=true) ListDashboardDataModelsQueryParams var1);

    @RequestLine(value="PATCH /v1/dashboard/datamodels/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDataModel(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/dashboard/datamodels/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDataModelWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/dashboard/datamodels/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDataModel1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/dashboard/datamodels/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDataModel1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/dashboard/datamodels/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DashboardDataModel restore12(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/dashboard/datamodels/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DashboardDataModel> restore12WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="GET /v1/dashboard/datamodels/name/{fqn}/columns/search?q={q}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DataModelColumnList searchDataModelColumnsByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="q") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="offset") @Nullable Integer var4, @Param(value="fields") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/dashboard/datamodels/name/{fqn}/columns/search?q={q}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataModelColumnList> searchDataModelColumnsByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="q") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="offset") @Nullable Integer var4, @Param(value="fields") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/dashboard/datamodels/name/{fqn}/columns/search?q={q}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DataModelColumnList searchDataModelColumnsByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) SearchDataModelColumnsByFQNQueryParams var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/name/{fqn}/columns/search?q={q}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataModelColumnList> searchDataModelColumnsByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) SearchDataModelColumnsByFQNQueryParams var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}/columns/search?q={q}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DataModelColumnList searchDataModelColumnsById(@Param(value="id") @Nonnull String var1, @Param(value="q") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="offset") @Nullable Integer var4, @Param(value="fields") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}/columns/search?q={q}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataModelColumnList> searchDataModelColumnsByIdWithHttpInfo(@Param(value="id") @Nonnull String var1, @Param(value="q") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="offset") @Nullable Integer var4, @Param(value="fields") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}/columns/search?q={q}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DataModelColumnList searchDataModelColumnsById(@Param(value="id") @Nonnull String var1, @QueryMap(encoded=true) SearchDataModelColumnsByIdQueryParams var2);

    @RequestLine(value="GET /v1/dashboard/datamodels/{id}/columns/search?q={q}&limit={limit}&offset={offset}&fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataModelColumnList> searchDataModelColumnsByIdWithHttpInfo(@Param(value="id") @Nonnull String var1, @QueryMap(encoded=true) SearchDataModelColumnsByIdQueryParams var2);

    @RequestLine(value="PUT /v1/dashboard/datamodels/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity6(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/dashboard/datamodels/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity6WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    public static class SearchDataModelColumnsByIdQueryParams
    extends HashMap<String, Object> {
        public SearchDataModelColumnsByIdQueryParams q(@Nullable String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }

        public SearchDataModelColumnsByIdQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public SearchDataModelColumnsByIdQueryParams offset(@Nullable Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public SearchDataModelColumnsByIdQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public SearchDataModelColumnsByIdQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class SearchDataModelColumnsByFQNQueryParams
    extends HashMap<String, Object> {
        public SearchDataModelColumnsByFQNQueryParams q(@Nullable String value) {
            this.put("q", EncodingUtils.encode(value));
            return this;
        }

        public SearchDataModelColumnsByFQNQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public SearchDataModelColumnsByFQNQueryParams offset(@Nullable Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public SearchDataModelColumnsByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public SearchDataModelColumnsByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListDashboardDataModelsQueryParams
    extends HashMap<String, Object> {
        public ListDashboardDataModelsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardDataModelsQueryParams service(@Nullable String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardDataModelsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardDataModelsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardDataModelsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardDataModelsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDataModelColumnsByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDataModelColumnsByFQNQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public GetDataModelColumnsByFQNQueryParams offset(@Nullable Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public GetDataModelColumnsByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDataModelColumnsByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDataModelColumnsQueryParams
    extends HashMap<String, Object> {
        public GetDataModelColumnsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public GetDataModelColumnsQueryParams offset(@Nullable Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public GetDataModelColumnsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDataModelColumnsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDataModelByIDQueryParams
    extends HashMap<String, Object> {
        public GetDataModelByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDataModelByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDataModelByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDataModelByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDataModelByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDataModelByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteDataModelByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDataModelByFQNQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDataModelAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteDataModelAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDataModelAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDataModelQueryParams
    extends HashMap<String, Object> {
        public DeleteDataModelQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDataModelQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }
}

