/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CSVExportResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateDatabaseSchema;
import org.openmetadata.client.model.CsvImportResult;
import org.openmetadata.client.model.DatabaseSchema;
import org.openmetadata.client.model.DatabaseSchemaList;
import org.openmetadata.client.model.DatabaseSchemaProfilerConfig;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.SearchResponse;
import org.openmetadata.client.model.VoteRequest;

public interface DatabaseSchemasApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/databaseSchemas/{id}/databaseSchemaProfilerConfig")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseSchema addDataProfilerConfig1(@Param(value="id") @Nonnull UUID var1, @Nullable DatabaseSchemaProfilerConfig var2);

    @RequestLine(value="PUT /v1/databaseSchemas/{id}/databaseSchemaProfilerConfig")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DatabaseSchema> addDataProfilerConfig1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable DatabaseSchemaProfilerConfig var2);

    @RequestLine(value="PUT /v1/databaseSchemas/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToDatabaseSchema(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/databaseSchemas/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToDatabaseSchemaWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="POST /v1/databaseSchemas")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseSchema createDBSchema(@Nullable CreateDatabaseSchema var1);

    @RequestLine(value="POST /v1/databaseSchemas")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DatabaseSchema> createDBSchemaWithHttpInfo(@Nullable CreateDatabaseSchema var1);

    @RequestLine(value="PUT /v1/databaseSchemas")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseSchema createOrUpdateDBSchema(@Nullable CreateDatabaseSchema var1);

    @RequestLine(value="PUT /v1/databaseSchemas")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DatabaseSchema> createOrUpdateDBSchemaWithHttpInfo(@Nullable CreateDatabaseSchema var1);

    @RequestLine(value="DELETE /v1/databaseSchemas/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDBSchema(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/databaseSchemas/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDBSchemaWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/databaseSchemas/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDBSchema(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDBSchemaQueryParams var2);

    @RequestLine(value="DELETE /v1/databaseSchemas/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDBSchemaWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDBSchemaQueryParams var2);

    @RequestLine(value="DELETE /v1/databaseSchemas/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDBSchemaAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/databaseSchemas/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDBSchemaAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/databaseSchemas/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDBSchemaAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDBSchemaAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/databaseSchemas/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDBSchemaAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDBSchemaAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/databaseSchemas/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDBSchemaByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/databaseSchemas/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDBSchemaByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/databaseSchemas/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDBSchemaByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteDBSchemaByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/databaseSchemas/name/{fqn}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDBSchemaByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteDBSchemaByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/databaseSchemas/{id}/databaseSchemaProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchema deleteDataProfilerConfig1(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/databaseSchemas/{id}/databaseSchemaProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseSchema> deleteDataProfilerConfig1WithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/databaseSchemas/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower2(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/databaseSchemas/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower2WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public String exportDatabaseSchema(@Param(value="name") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportDatabaseSchemaWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public String exportDatabaseSchema(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) ExportDatabaseSchemaQueryParams var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportDatabaseSchemaWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) ExportDatabaseSchemaQueryParams var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{name}/exportAsync?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public CSVExportResponse exportDatabaseSchema1(@Param(value="name") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{name}/exportAsync?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CSVExportResponse> exportDatabaseSchema1WithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{name}/exportAsync?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public CSVExportResponse exportDatabaseSchema1(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) ExportDatabaseSchema1QueryParams var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{name}/exportAsync?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CSVExportResponse> exportDatabaseSchema1WithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) ExportDatabaseSchema1QueryParams var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchema getDBSchemaByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/databaseSchemas/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseSchema> getDBSchemaByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/databaseSchemas/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchema getDBSchemaByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetDBSchemaByFQNQueryParams var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseSchema> getDBSchemaByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetDBSchemaByFQNQueryParams var2);

    @RequestLine(value="GET /v1/databaseSchemas/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchema getDBSchemaByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/databaseSchemas/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseSchema> getDBSchemaByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/databaseSchemas/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchema getDBSchemaByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDBSchemaByIDQueryParams var2);

    @RequestLine(value="GET /v1/databaseSchemas/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseSchema> getDBSchemaByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDBSchemaByIDQueryParams var2);

    @RequestLine(value="GET /v1/databaseSchemas/{id}/databaseSchemaProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchema getDataProfilerConfig1(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/databaseSchemas/{id}/databaseSchemaProfilerConfig")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseSchema> getDataProfilerConfig1WithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/databaseSchemas/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchema getSpecificDBSchemaVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/databaseSchemas/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseSchema> getSpecificDBSchemaVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="PUT /v1/databaseSchemas/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public CsvImportResult importDatabaseSchema(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3, @Nullable String var4);

    @RequestLine(value="PUT /v1/databaseSchemas/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDatabaseSchemaWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3, @Nullable String var4);

    @RequestLine(value="PUT /v1/databaseSchemas/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public CsvImportResult importDatabaseSchema(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportDatabaseSchemaQueryParams var3);

    @RequestLine(value="PUT /v1/databaseSchemas/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDatabaseSchemaWithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportDatabaseSchemaQueryParams var3);

    @RequestLine(value="PUT /v1/databaseSchemas/name/{name}/importAsync?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public CsvImportResult importDatabaseSchemaAsync(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3, @Nullable String var4);

    @RequestLine(value="PUT /v1/databaseSchemas/name/{name}/importAsync?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDatabaseSchemaAsyncWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3, @Nullable String var4);

    @RequestLine(value="PUT /v1/databaseSchemas/name/{name}/importAsync?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public CsvImportResult importDatabaseSchemaAsync(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportDatabaseSchemaAsyncQueryParams var3);

    @RequestLine(value="PUT /v1/databaseSchemas/name/{name}/importAsync?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDatabaseSchemaAsyncWithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportDatabaseSchemaAsyncQueryParams var3);

    @RequestLine(value="GET /v1/databaseSchemas/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllDBSchemaVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/databaseSchemas/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllDBSchemaVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/databaseSchemas?fields={fields}&database={database}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchemaList listDBSchemas(@Param(value="fields") @Nullable String var1, @Param(value="database") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/databaseSchemas?fields={fields}&database={database}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseSchemaList> listDBSchemasWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="database") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/databaseSchemas?fields={fields}&database={database}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchemaList listDBSchemas(@QueryMap(encoded=true) ListDBSchemasQueryParams var1);

    @RequestLine(value="GET /v1/databaseSchemas?fields={fields}&database={database}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseSchemaList> listDBSchemasWithHttpInfo(@QueryMap(encoded=true) ListDBSchemasQueryParams var1);

    @RequestLine(value="PATCH /v1/databaseSchemas/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDBSchema(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/databaseSchemas/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDBSchemaWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/databaseSchemas/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDBSchema1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/databaseSchemas/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDBSchema1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/databaseSchemas/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseSchema restore9(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/databaseSchemas/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DatabaseSchema> restore9WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="GET /v1/databaseSchemas/entityRelationship?fqn={fqn}&query_filter={queryFilter}&fields={fields}&offset={offset}&limit={limit}&from={from}&size={size}&includeDeleted={includeDeleted}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchSchemaEntityRelationship(@Param(value="fqn") @Nullable String var1, @Param(value="queryFilter") @Nullable String var2, @Param(value="fields") @Nullable String var3, @Param(value="offset") @Nullable Integer var4, @Param(value="limit") @Nullable Integer var5, @Param(value="from") @Nullable Integer var6, @Param(value="size") @Nullable Integer var7, @Param(value="includeDeleted") @Nullable Boolean var8);

    @RequestLine(value="GET /v1/databaseSchemas/entityRelationship?fqn={fqn}&query_filter={queryFilter}&fields={fields}&offset={offset}&limit={limit}&from={from}&size={size}&includeDeleted={includeDeleted}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchSchemaEntityRelationshipWithHttpInfo(@Param(value="fqn") @Nullable String var1, @Param(value="queryFilter") @Nullable String var2, @Param(value="fields") @Nullable String var3, @Param(value="offset") @Nullable Integer var4, @Param(value="limit") @Nullable Integer var5, @Param(value="from") @Nullable Integer var6, @Param(value="size") @Nullable Integer var7, @Param(value="includeDeleted") @Nullable Boolean var8);

    @RequestLine(value="GET /v1/databaseSchemas/entityRelationship?fqn={fqn}&query_filter={queryFilter}&fields={fields}&offset={offset}&limit={limit}&from={from}&size={size}&includeDeleted={includeDeleted}")
    @Headers(value={"Accept: application/json"})
    public SearchResponse searchSchemaEntityRelationship(@QueryMap(encoded=true) SearchSchemaEntityRelationshipQueryParams var1);

    @RequestLine(value="GET /v1/databaseSchemas/entityRelationship?fqn={fqn}&query_filter={queryFilter}&fields={fields}&offset={offset}&limit={limit}&from={from}&size={size}&includeDeleted={includeDeleted}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SearchResponse> searchSchemaEntityRelationshipWithHttpInfo(@QueryMap(encoded=true) SearchSchemaEntityRelationshipQueryParams var1);

    @RequestLine(value="PUT /v1/databaseSchemas/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForEntity3(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/databaseSchemas/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForEntity3WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    public static class SearchSchemaEntityRelationshipQueryParams
    extends HashMap<String, Object> {
        public SearchSchemaEntityRelationshipQueryParams fqn(@Nullable String value) {
            this.put("fqn", EncodingUtils.encode(value));
            return this;
        }

        public SearchSchemaEntityRelationshipQueryParams queryFilter(@Nullable String value) {
            this.put("query_filter", EncodingUtils.encode(value));
            return this;
        }

        public SearchSchemaEntityRelationshipQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public SearchSchemaEntityRelationshipQueryParams offset(@Nullable Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public SearchSchemaEntityRelationshipQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public SearchSchemaEntityRelationshipQueryParams from(@Nullable Integer value) {
            this.put("from", EncodingUtils.encode(value));
            return this;
        }

        public SearchSchemaEntityRelationshipQueryParams size(@Nullable Integer value) {
            this.put("size", EncodingUtils.encode(value));
            return this;
        }

        public SearchSchemaEntityRelationshipQueryParams includeDeleted(@Nullable Boolean value) {
            this.put("includeDeleted", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListDBSchemasQueryParams
    extends HashMap<String, Object> {
        public ListDBSchemasQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDBSchemasQueryParams database(@Nullable String value) {
            this.put("database", EncodingUtils.encode(value));
            return this;
        }

        public ListDBSchemasQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDBSchemasQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDBSchemasQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListDBSchemasQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportDatabaseSchemaAsyncQueryParams
    extends HashMap<String, Object> {
        public ImportDatabaseSchemaAsyncQueryParams dryRun(@Nullable Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }

        public ImportDatabaseSchemaAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportDatabaseSchemaQueryParams
    extends HashMap<String, Object> {
        public ImportDatabaseSchemaQueryParams dryRun(@Nullable Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }

        public ImportDatabaseSchemaQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDBSchemaByIDQueryParams
    extends HashMap<String, Object> {
        public GetDBSchemaByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDBSchemaByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDBSchemaByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDBSchemaByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDBSchemaByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ExportDatabaseSchema1QueryParams
    extends HashMap<String, Object> {
        public ExportDatabaseSchema1QueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ExportDatabaseSchemaQueryParams
    extends HashMap<String, Object> {
        public ExportDatabaseSchemaQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDBSchemaByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteDBSchemaByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDBSchemaByFQNQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDBSchemaAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteDBSchemaAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDBSchemaAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDBSchemaQueryParams
    extends HashMap<String, Object> {
        public DeleteDBSchemaQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDBSchemaQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

