/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CSVExportResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateDatabaseService;
import org.openmetadata.client.model.CsvImportResult;
import org.openmetadata.client.model.DatabaseService;
import org.openmetadata.client.model.DatabaseServiceList;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestConnectionResult;

public interface DatabaseServicesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/databaseServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToDatabaseService(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/databaseServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToDatabaseServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/databaseServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseService addTestConnectionResult3(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/databaseServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DatabaseService> addTestConnectionResult3WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="POST /v1/services/databaseServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseService createDatabaseService(@Nullable CreateDatabaseService var1);

    @RequestLine(value="POST /v1/services/databaseServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DatabaseService> createDatabaseServiceWithHttpInfo(@Nullable CreateDatabaseService var1);

    @RequestLine(value="PUT /v1/services/databaseServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseService createOrUpdateDatabaseService(@Nullable CreateDatabaseService var1);

    @RequestLine(value="PUT /v1/services/databaseServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DatabaseService> createOrUpdateDatabaseServiceWithHttpInfo(@Nullable CreateDatabaseService var1);

    @RequestLine(value="DELETE /v1/services/databaseServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDatabaseService(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/databaseServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDatabaseServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/databaseServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDatabaseService(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDatabaseServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/databaseServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDatabaseServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDatabaseServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/databaseServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDatabaseServiceAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/databaseServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDatabaseServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/databaseServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDatabaseServiceAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDatabaseServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/databaseServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDatabaseServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDatabaseServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/databaseServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDatabaseServiceByName(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/databaseServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDatabaseServiceByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/databaseServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDatabaseServiceByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteDatabaseServiceByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/services/databaseServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDatabaseServiceByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteDatabaseServiceByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/services/databaseServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower12(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/services/databaseServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower12WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/databaseServices/name/{name}/exportAsync?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public CSVExportResponse exportDatabaseService(@Param(value="name") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2);

    @RequestLine(value="GET /v1/services/databaseServices/name/{name}/exportAsync?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CSVExportResponse> exportDatabaseServiceWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2);

    @RequestLine(value="GET /v1/services/databaseServices/name/{name}/exportAsync?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public CSVExportResponse exportDatabaseService(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) ExportDatabaseServiceQueryParams var2);

    @RequestLine(value="GET /v1/services/databaseServices/name/{name}/exportAsync?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CSVExportResponse> exportDatabaseServiceWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) ExportDatabaseServiceQueryParams var2);

    @RequestLine(value="GET /v1/services/databaseServices/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public String exportDatabaseServices(@Param(value="name") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2);

    @RequestLine(value="GET /v1/services/databaseServices/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportDatabaseServicesWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2);

    @RequestLine(value="GET /v1/services/databaseServices/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public String exportDatabaseServices(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) ExportDatabaseServicesQueryParams var2);

    @RequestLine(value="GET /v1/services/databaseServices/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> exportDatabaseServicesWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) ExportDatabaseServicesQueryParams var2);

    @RequestLine(value="GET /v1/services/databaseServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseService getDatabaseServiceByFQN(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/databaseServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseService> getDatabaseServiceByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/databaseServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseService getDatabaseServiceByFQN(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetDatabaseServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/databaseServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseService> getDatabaseServiceByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetDatabaseServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/databaseServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseService getDatabaseServiceByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/databaseServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseService> getDatabaseServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/databaseServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseService getDatabaseServiceByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDatabaseServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/databaseServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseService> getDatabaseServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDatabaseServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/databaseServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public DatabaseService getSpecificDatabaseServiceVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/databaseServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseService> getSpecificDatabaseServiceVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="PUT /v1/services/databaseServices/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public CsvImportResult importDatabaseService(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3, @Nullable String var4);

    @RequestLine(value="PUT /v1/services/databaseServices/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDatabaseServiceWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3, @Nullable String var4);

    @RequestLine(value="PUT /v1/services/databaseServices/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public CsvImportResult importDatabaseService(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportDatabaseServiceQueryParams var3);

    @RequestLine(value="PUT /v1/services/databaseServices/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDatabaseServiceWithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportDatabaseServiceQueryParams var3);

    @RequestLine(value="PUT /v1/services/databaseServices/name/{name}/importAsync?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public CsvImportResult importDatabaseServiceAsync(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3, @Nullable String var4);

    @RequestLine(value="PUT /v1/services/databaseServices/name/{name}/importAsync?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDatabaseServiceAsyncWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3, @Nullable String var4);

    @RequestLine(value="PUT /v1/services/databaseServices/name/{name}/importAsync?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public CsvImportResult importDatabaseServiceAsync(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportDatabaseServiceAsyncQueryParams var3);

    @RequestLine(value="PUT /v1/services/databaseServices/name/{name}/importAsync?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDatabaseServiceAsyncWithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportDatabaseServiceAsyncQueryParams var3);

    @RequestLine(value="GET /v1/services/databaseServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllDatabaseServiceVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/databaseServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllDatabaseServiceVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/databaseServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseServiceList listDatabaseServices(@Param(value="fields") @Nullable String var1, @Param(value="domain") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/services/databaseServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseServiceList> listDatabaseServicesWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="domain") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/services/databaseServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseServiceList listDatabaseServices(@QueryMap(encoded=true) ListDatabaseServicesQueryParams var1);

    @RequestLine(value="GET /v1/services/databaseServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DatabaseServiceList> listDatabaseServicesWithHttpInfo(@QueryMap(encoded=true) ListDatabaseServicesQueryParams var1);

    @RequestLine(value="PATCH /v1/services/databaseServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDatabaseService(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/databaseServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDatabaseServiceWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/databaseServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDatabaseService1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/databaseServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDatabaseService1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/services/databaseServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseService restore28(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/databaseServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DatabaseService> restore28WithHttpInfo(@Nullable RestoreEntity var1);

    public static class ListDatabaseServicesQueryParams
    extends HashMap<String, Object> {
        public ListDatabaseServicesQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDatabaseServicesQueryParams domain(@Nullable String value) {
            this.put("domain", EncodingUtils.encode(value));
            return this;
        }

        public ListDatabaseServicesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDatabaseServicesQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDatabaseServicesQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListDatabaseServicesQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportDatabaseServiceAsyncQueryParams
    extends HashMap<String, Object> {
        public ImportDatabaseServiceAsyncQueryParams dryRun(@Nullable Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }

        public ImportDatabaseServiceAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportDatabaseServiceQueryParams
    extends HashMap<String, Object> {
        public ImportDatabaseServiceQueryParams dryRun(@Nullable Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }

        public ImportDatabaseServiceQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDatabaseServiceByIDQueryParams
    extends HashMap<String, Object> {
        public GetDatabaseServiceByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDatabaseServiceByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDatabaseServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDatabaseServiceByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDatabaseServiceByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ExportDatabaseServicesQueryParams
    extends HashMap<String, Object> {
        public ExportDatabaseServicesQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ExportDatabaseServiceQueryParams
    extends HashMap<String, Object> {
        public ExportDatabaseServiceQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDatabaseServiceByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteDatabaseServiceByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDatabaseServiceByNameQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDatabaseServiceAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteDatabaseServiceAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDatabaseServiceAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDatabaseServiceQueryParams
    extends HashMap<String, Object> {
        public DeleteDatabaseServiceQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDatabaseServiceQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

