/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateDirectory;
import org.openmetadata.client.model.CsvImportResult;
import org.openmetadata.client.model.Directory;
import org.openmetadata.client.model.DirectoryList;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;

public interface DirectoriesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/drives/directories/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToDirectory(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/drives/directories/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToDirectoryWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="POST /v1/drives/directories")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Directory createDirectory(@Nullable CreateDirectory var1);

    @RequestLine(value="POST /v1/drives/directories")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Directory> createDirectoryWithHttpInfo(@Nullable CreateDirectory var1);

    @RequestLine(value="PUT /v1/drives/directories")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Directory createOrUpdateDirectory(@Nullable CreateDirectory var1);

    @RequestLine(value="PUT /v1/drives/directories")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Directory> createOrUpdateDirectoryWithHttpInfo(@Nullable CreateDirectory var1);

    @RequestLine(value="DELETE /v1/drives/directories/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDirectory(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/drives/directories/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDirectoryWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/drives/directories/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDirectory(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDirectoryQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/directories/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDirectoryWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDirectoryQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/directories/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDirectoryAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/drives/directories/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDirectoryAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/drives/directories/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteDirectoryAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDirectoryAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/directories/async/{id}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDirectoryAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDirectoryAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/directories/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDirectoryByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/drives/directories/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDirectoryByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/drives/directories/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDirectoryByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteDirectoryByFQNQueryParams var2);

    @RequestLine(value="DELETE /v1/drives/directories/name/{fqn}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDirectoryByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteDirectoryByFQNQueryParams var2);

    @RequestLine(value="GET /v1/drives/directories/export?name={name}")
    @Headers(value={"Accept: application/json"})
    public void exportDirectories(@Param(value="name") @Nullable String var1);

    @RequestLine(value="GET /v1/drives/directories/export?name={name}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> exportDirectoriesWithHttpInfo(@Param(value="name") @Nullable String var1);

    @RequestLine(value="GET /v1/drives/directories/export?name={name}")
    @Headers(value={"Accept: application/json"})
    public void exportDirectories(@QueryMap(encoded=true) ExportDirectoriesQueryParams var1);

    @RequestLine(value="GET /v1/drives/directories/export?name={name}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> exportDirectoriesWithHttpInfo(@QueryMap(encoded=true) ExportDirectoriesQueryParams var1);

    @RequestLine(value="GET /v1/drives/directories/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Directory getDirectoryByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/drives/directories/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Directory> getDirectoryByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/drives/directories/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Directory getDirectoryByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetDirectoryByFQNQueryParams var2);

    @RequestLine(value="GET /v1/drives/directories/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Directory> getDirectoryByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetDirectoryByFQNQueryParams var2);

    @RequestLine(value="GET /v1/drives/directories/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Directory getDirectoryByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/drives/directories/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Directory> getDirectoryByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/drives/directories/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Directory getDirectoryByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDirectoryByIDQueryParams var2);

    @RequestLine(value="GET /v1/drives/directories/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Directory> getDirectoryByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDirectoryByIDQueryParams var2);

    @RequestLine(value="GET /v1/drives/directories/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Directory getSpecificDirectoryVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/drives/directories/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Directory> getSpecificDirectoryVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="POST /v1/drives/directories/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public CsvImportResult importDirectory(@Param(value="dryRun") @Nullable Boolean var1, @Nullable String var2);

    @RequestLine(value="POST /v1/drives/directories/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDirectoryWithHttpInfo(@Param(value="dryRun") @Nullable Boolean var1, @Nullable String var2);

    @RequestLine(value="POST /v1/drives/directories/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public CsvImportResult importDirectory(@Nullable String var1, @QueryMap(encoded=true) ImportDirectoryQueryParams var2);

    @RequestLine(value="POST /v1/drives/directories/import?dryRun={dryRun}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDirectoryWithHttpInfo(@Nullable String var1, @QueryMap(encoded=true) ImportDirectoryQueryParams var2);

    @RequestLine(value="GET /v1/drives/directories/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllDirectoryVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/drives/directories/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllDirectoryVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/drives/directories?fields={fields}&service={service}&parent={parent}&root={root}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DirectoryList listDirectories(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="parent") @Nullable String var3, @Param(value="root") @Nullable Boolean var4, @Param(value="limit") @Nullable Integer var5, @Param(value="before") @Nullable String var6, @Param(value="after") @Nullable String var7, @Param(value="include") @Nullable String var8);

    @RequestLine(value="GET /v1/drives/directories?fields={fields}&service={service}&parent={parent}&root={root}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DirectoryList> listDirectoriesWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="service") @Nullable String var2, @Param(value="parent") @Nullable String var3, @Param(value="root") @Nullable Boolean var4, @Param(value="limit") @Nullable Integer var5, @Param(value="before") @Nullable String var6, @Param(value="after") @Nullable String var7, @Param(value="include") @Nullable String var8);

    @RequestLine(value="GET /v1/drives/directories?fields={fields}&service={service}&parent={parent}&root={root}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DirectoryList listDirectories(@QueryMap(encoded=true) ListDirectoriesQueryParams var1);

    @RequestLine(value="GET /v1/drives/directories?fields={fields}&service={service}&parent={parent}&root={root}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DirectoryList> listDirectoriesWithHttpInfo(@QueryMap(encoded=true) ListDirectoriesQueryParams var1);

    @RequestLine(value="PATCH /v1/drives/directories/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDirectory(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/drives/directories/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDirectoryWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="DELETE /v1/drives/directories/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent removeFollowerFromDirectory(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="DELETE /v1/drives/directories/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> removeFollowerFromDirectoryWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="PUT /v1/drives/directories/{id}/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Directory restoreDirectory(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/drives/directories/{id}/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Directory> restoreDirectoryWithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/drives/directories/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Directory restoreDirectoryById(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/drives/directories/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Directory> restoreDirectoryByIdWithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/drives/directories/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForDirectory(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/drives/directories/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForDirectoryWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    public static class ListDirectoriesQueryParams
    extends HashMap<String, Object> {
        public ListDirectoriesQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDirectoriesQueryParams service(@Nullable String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListDirectoriesQueryParams parent(@Nullable String value) {
            this.put("parent", EncodingUtils.encode(value));
            return this;
        }

        public ListDirectoriesQueryParams root(@Nullable Boolean value) {
            this.put("root", EncodingUtils.encode(value));
            return this;
        }

        public ListDirectoriesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDirectoriesQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDirectoriesQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListDirectoriesQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportDirectoryQueryParams
    extends HashMap<String, Object> {
        public ImportDirectoryQueryParams dryRun(@Nullable Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDirectoryByIDQueryParams
    extends HashMap<String, Object> {
        public GetDirectoryByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDirectoryByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDirectoryByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDirectoryByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDirectoryByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ExportDirectoriesQueryParams
    extends HashMap<String, Object> {
        public ExportDirectoriesQueryParams name(@Nullable String value) {
            this.put("name", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDirectoryByFQNQueryParams
    extends HashMap<String, Object> {
        public DeleteDirectoryByFQNQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDirectoryByFQNQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDirectoryAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteDirectoryAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDirectoryAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDirectoryQueryParams
    extends HashMap<String, Object> {
        public DeleteDirectoryQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDirectoryQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

