/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.BulkAssets;
import org.openmetadata.client.model.BulkOperationResult;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateDataProduct;
import org.openmetadata.client.model.CreateDomain;
import org.openmetadata.client.model.DataProduct;
import org.openmetadata.client.model.DataProductList;
import org.openmetadata.client.model.Domain;
import org.openmetadata.client.model.DomainList;
import org.openmetadata.client.model.EntityHierarchyList;
import org.openmetadata.client.model.EntityHistory;

public interface DomainsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/dataProducts/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToDataProduct(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/dataProducts/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToDataProductWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/domains/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToDomain(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/domains/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToDomainWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/dataProducts/{name}/assets/add")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public BulkOperationResult bulkAddAssets(@Param(value="name") @Nonnull String var1, @Nullable BulkAssets var2);

    @RequestLine(value="PUT /v1/dataProducts/{name}/assets/add")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<BulkOperationResult> bulkAddAssetsWithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable BulkAssets var2);

    @RequestLine(value="PUT /v1/domains/{name}/assets/add")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public BulkOperationResult bulkAddAssets1(@Param(value="name") @Nonnull String var1, @Nullable BulkAssets var2);

    @RequestLine(value="PUT /v1/domains/{name}/assets/add")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<BulkOperationResult> bulkAddAssets1WithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable BulkAssets var2);

    @RequestLine(value="PUT /v1/dataProducts/{name}/assets/remove")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent bulkRemoveAssets(@Param(value="name") @Nonnull String var1, @Nullable BulkAssets var2);

    @RequestLine(value="PUT /v1/dataProducts/{name}/assets/remove")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> bulkRemoveAssetsWithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable BulkAssets var2);

    @RequestLine(value="PUT /v1/domains/{name}/assets/remove")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent bulkRemoveAssets1(@Param(value="name") @Nonnull String var1, @Nullable BulkAssets var2);

    @RequestLine(value="PUT /v1/domains/{name}/assets/remove")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> bulkRemoveAssets1WithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable BulkAssets var2);

    @RequestLine(value="POST /v1/dataProducts")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DataProduct createDataProduct(@Nullable CreateDataProduct var1);

    @RequestLine(value="POST /v1/dataProducts")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DataProduct> createDataProductWithHttpInfo(@Nullable CreateDataProduct var1);

    @RequestLine(value="POST /v1/domains")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Domain createDomain(@Nullable CreateDomain var1);

    @RequestLine(value="POST /v1/domains")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Domain> createDomainWithHttpInfo(@Nullable CreateDomain var1);

    @RequestLine(value="PUT /v1/dataProducts")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DataProduct createOrUpdateDataProduct(@Nullable CreateDataProduct var1);

    @RequestLine(value="PUT /v1/dataProducts")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DataProduct> createOrUpdateDataProductWithHttpInfo(@Nullable CreateDataProduct var1);

    @RequestLine(value="PUT /v1/domains")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Domain createOrUpdateDomain(@Nullable CreateDomain var1);

    @RequestLine(value="PUT /v1/domains")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Domain> createOrUpdateDomainWithHttpInfo(@Nullable CreateDomain var1);

    @RequestLine(value="DELETE /v1/dataProducts/{id}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataProduct(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/dataProducts/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataProductWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/dataProducts/async/{id}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataProductAsync(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/dataProducts/async/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataProductAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/dataProducts/name/{name}")
    @Headers(value={"Accept: application/json"})
    public void deleteDataProductByFQN(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="DELETE /v1/dataProducts/name/{name}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDataProductByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="DELETE /v1/domains/{id}")
    @Headers(value={"Accept: application/json"})
    public void deleteDomain(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/domains/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDomainWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/domains/async/{id}")
    @Headers(value={"Accept: application/json"})
    public void deleteDomainAsync(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/domains/async/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDomainAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/domains/name/{name}")
    @Headers(value={"Accept: application/json"})
    public void deleteDomainByFQN(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="DELETE /v1/domains/name/{name}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDomainByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="DELETE /v1/dataProducts/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollowerFromDataProduct(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/dataProducts/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollowerFromDataProductWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/domains/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollowerFromDomain(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/domains/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollowerFromDomainWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="GET /v1/dataProducts/name/{name}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public DataProduct getDataProductByFQN(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /v1/dataProducts/name/{name}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataProduct> getDataProductByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /v1/dataProducts/name/{name}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public DataProduct getDataProductByFQN(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetDataProductByFQNQueryParams var2);

    @RequestLine(value="GET /v1/dataProducts/name/{name}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataProduct> getDataProductByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetDataProductByFQNQueryParams var2);

    @RequestLine(value="GET /v1/dataProducts/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public DataProduct getDataProductByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /v1/dataProducts/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataProduct> getDataProductByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /v1/dataProducts/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public DataProduct getDataProductByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDataProductByIDQueryParams var2);

    @RequestLine(value="GET /v1/dataProducts/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataProduct> getDataProductByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDataProductByIDQueryParams var2);

    @RequestLine(value="GET /v1/domains/name/{name}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Domain getDomainByFQN(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /v1/domains/name/{name}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Domain> getDomainByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /v1/domains/name/{name}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Domain getDomainByFQN(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetDomainByFQNQueryParams var2);

    @RequestLine(value="GET /v1/domains/name/{name}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Domain> getDomainByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetDomainByFQNQueryParams var2);

    @RequestLine(value="GET /v1/domains/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Domain getDomainByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /v1/domains/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Domain> getDomainByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /v1/domains/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Domain getDomainByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDomainByIDQueryParams var2);

    @RequestLine(value="GET /v1/domains/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Domain> getDomainByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDomainByIDQueryParams var2);

    @RequestLine(value="GET /v1/dataProducts/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllDataProductVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/dataProducts/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllDataProductVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/domains/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllDomainVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/domains/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllDomainVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/dataProducts?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public DataProductList listDataProducts(@Param(value="fields") @Nullable String var1, @Param(value="domain") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5);

    @RequestLine(value="GET /v1/dataProducts?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataProductList> listDataProductsWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="domain") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5);

    @RequestLine(value="GET /v1/dataProducts?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public DataProductList listDataProducts(@QueryMap(encoded=true) ListDataProductsQueryParams var1);

    @RequestLine(value="GET /v1/dataProducts?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataProductList> listDataProductsWithHttpInfo(@QueryMap(encoded=true) ListDataProductsQueryParams var1);

    @RequestLine(value="GET /v1/domains?fields={fields}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public DomainList listDomains(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4);

    @RequestLine(value="GET /v1/domains?fields={fields}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DomainList> listDomainsWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4);

    @RequestLine(value="GET /v1/domains?fields={fields}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public DomainList listDomains(@QueryMap(encoded=true) ListDomainsQueryParams var1);

    @RequestLine(value="GET /v1/domains?fields={fields}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DomainList> listDomainsWithHttpInfo(@QueryMap(encoded=true) ListDomainsQueryParams var1);

    @RequestLine(value="GET /v1/domains/hierarchy?fields={fields}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public EntityHierarchyList listDomainsHierarchy(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2);

    @RequestLine(value="GET /v1/domains/hierarchy?fields={fields}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHierarchyList> listDomainsHierarchyWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2);

    @RequestLine(value="GET /v1/domains/hierarchy?fields={fields}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public EntityHierarchyList listDomainsHierarchy(@QueryMap(encoded=true) ListDomainsHierarchyQueryParams var1);

    @RequestLine(value="GET /v1/domains/hierarchy?fields={fields}&limit={limit}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHierarchyList> listDomainsHierarchyWithHttpInfo(@QueryMap(encoded=true) ListDomainsHierarchyQueryParams var1);

    @RequestLine(value="GET /v1/dataProducts/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public DataProduct listSpecificDataProductVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/dataProducts/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DataProduct> listSpecificDataProductVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/domains/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Domain listSpecificDomainVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/domains/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Domain> listSpecificDomainVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="PATCH /v1/dataProducts/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDataProduct(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/dataProducts/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDataProductWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/dataProducts/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDataProduct1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/dataProducts/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDataProduct1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/domains/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDomain(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/domains/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDomainWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/domains/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDomain1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/domains/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDomain1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    public static class ListDomainsHierarchyQueryParams
    extends HashMap<String, Object> {
        public ListDomainsHierarchyQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDomainsHierarchyQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListDomainsQueryParams
    extends HashMap<String, Object> {
        public ListDomainsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDomainsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDomainsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDomainsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListDataProductsQueryParams
    extends HashMap<String, Object> {
        public ListDataProductsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDataProductsQueryParams domain(@Nullable String value) {
            this.put("domain", EncodingUtils.encode(value));
            return this;
        }

        public ListDataProductsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDataProductsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDataProductsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDomainByIDQueryParams
    extends HashMap<String, Object> {
        public GetDomainByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDomainByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDomainByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDataProductByIDQueryParams
    extends HashMap<String, Object> {
        public GetDataProductByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDataProductByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDataProductByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }
}

