/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateDriveService;
import org.openmetadata.client.model.CsvImportResult;
import org.openmetadata.client.model.DriveService;
import org.openmetadata.client.model.DriveServiceList;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestConnectionResult;

public interface DriveServicesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/driveServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToDriveService(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/services/driveServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToDriveServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/services/driveServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DriveService addTestConnectionResult(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/driveServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DriveService> addTestConnectionResultWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="POST /v1/services/driveServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DriveService createDriveService(@Nullable CreateDriveService var1);

    @RequestLine(value="POST /v1/services/driveServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DriveService> createDriveServiceWithHttpInfo(@Nullable CreateDriveService var1);

    @RequestLine(value="PUT /v1/services/driveServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DriveService createOrUpdateDriveService(@Nullable CreateDriveService var1);

    @RequestLine(value="PUT /v1/services/driveServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DriveService> createOrUpdateDriveServiceWithHttpInfo(@Nullable CreateDriveService var1);

    @RequestLine(value="DELETE /v1/services/driveServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDriveService(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/driveServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDriveServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/driveServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDriveService(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDriveServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/driveServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDriveServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDriveServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/driveServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDriveServiceAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/driveServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDriveServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/driveServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDriveServiceAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDriveServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/driveServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDriveServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteDriveServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/driveServices/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDriveServiceByName(@Param(value="name") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/driveServices/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDriveServiceByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/driveServices/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteDriveServiceByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteDriveServiceByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/services/driveServices/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteDriveServiceByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteDriveServiceByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/services/driveServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollowerFromDriveService(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="DELETE /v1/services/driveServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollowerFromDriveServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull UUID var2);

    @RequestLine(value="GET /v1/services/driveServices/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void exportDriveService(@Param(value="name") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2);

    @RequestLine(value="GET /v1/services/driveServices/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> exportDriveServiceWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2);

    @RequestLine(value="GET /v1/services/driveServices/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void exportDriveService(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) ExportDriveServiceQueryParams var2);

    @RequestLine(value="GET /v1/services/driveServices/name/{name}/export?recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> exportDriveServiceWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) ExportDriveServiceQueryParams var2);

    @RequestLine(value="GET /v1/services/driveServices/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DriveService getDriveServiceByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/driveServices/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DriveService> getDriveServiceByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/driveServices/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DriveService getDriveServiceByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetDriveServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/driveServices/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DriveService> getDriveServiceByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetDriveServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/driveServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DriveService getDriveServiceByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/driveServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DriveService> getDriveServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/driveServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DriveService getDriveServiceByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDriveServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/driveServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DriveService> getDriveServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetDriveServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/driveServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public DriveService getSpecificDriveServiceVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/driveServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DriveService> getSpecificDriveServiceVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="PUT /v1/services/driveServices/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public CsvImportResult importDriveService(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3, @Nullable String var4);

    @RequestLine(value="PUT /v1/services/driveServices/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDriveServiceWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="dryRun") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3, @Nullable String var4);

    @RequestLine(value="PUT /v1/services/driveServices/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public CsvImportResult importDriveService(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportDriveServiceQueryParams var3);

    @RequestLine(value="PUT /v1/services/driveServices/name/{name}/import?dryRun={dryRun}&recursive={recursive}")
    @Headers(value={"Content-Type: text/plain; charset=UTF-8", "Accept: application/json"})
    public ApiResponse<CsvImportResult> importDriveServiceWithHttpInfo(@Param(value="name") @Nonnull String var1, @Nullable String var2, @QueryMap(encoded=true) ImportDriveServiceQueryParams var3);

    @RequestLine(value="GET /v1/services/driveServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllDriveServiceVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/driveServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllDriveServiceVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/driveServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DriveServiceList listDriveServices(@Param(value="fields") @Nullable String var1, @Param(value="domain") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/services/driveServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DriveServiceList> listDriveServicesWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="domain") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/services/driveServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DriveServiceList listDriveServices(@QueryMap(encoded=true) ListDriveServicesQueryParams var1);

    @RequestLine(value="GET /v1/services/driveServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DriveServiceList> listDriveServicesWithHttpInfo(@QueryMap(encoded=true) ListDriveServicesQueryParams var1);

    @RequestLine(value="PATCH /v1/services/driveServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDriveService(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/driveServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchDriveServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/services/driveServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DriveService restore25(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/driveServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DriveService> restore25WithHttpInfo(@Nullable RestoreEntity var1);

    public static class ListDriveServicesQueryParams
    extends HashMap<String, Object> {
        public ListDriveServicesQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDriveServicesQueryParams domain(@Nullable String value) {
            this.put("domain", EncodingUtils.encode(value));
            return this;
        }

        public ListDriveServicesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDriveServicesQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDriveServicesQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListDriveServicesQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ImportDriveServiceQueryParams
    extends HashMap<String, Object> {
        public ImportDriveServiceQueryParams dryRun(@Nullable Boolean value) {
            this.put("dryRun", EncodingUtils.encode(value));
            return this;
        }

        public ImportDriveServiceQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDriveServiceByIDQueryParams
    extends HashMap<String, Object> {
        public GetDriveServiceByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDriveServiceByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDriveServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDriveServiceByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDriveServiceByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ExportDriveServiceQueryParams
    extends HashMap<String, Object> {
        public ExportDriveServiceQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDriveServiceByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteDriveServiceByNameQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDriveServiceByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDriveServiceAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteDriveServiceAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDriveServiceAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDriveServiceQueryParams
    extends HashMap<String, Object> {
        public DeleteDriveServiceQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDriveServiceQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

