/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateEventSubscription;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.EventList;
import org.openmetadata.client.model.EventSubscription;
import org.openmetadata.client.model.EventSubscriptionDestinationTestRequest;
import org.openmetadata.client.model.EventSubscriptionDiagnosticInfo;
import org.openmetadata.client.model.EventSubscriptionList;
import org.openmetadata.client.model.EventsRecord;
import org.openmetadata.client.model.Response;
import org.openmetadata.client.model.ResultListFilterResourceDescriptor;
import org.openmetadata.client.model.SubscriptionDestination;
import org.openmetadata.client.model.SubscriptionStatus;

public interface EventsApi
extends ApiClient.Api {
    @RequestLine(value="GET /v1/events/subscriptions/{id}/processedEvents")
    @Headers(value={"Accept: application/json"})
    public EntityHistory checkIfThePublisherProcessedALlEvents(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/events/subscriptions/{id}/processedEvents")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> checkIfThePublisherProcessedALlEventsWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="POST /v1/events/subscriptions")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public CreateEventSubscription createEventSubscription(@Nullable CreateEventSubscription var1);

    @RequestLine(value="POST /v1/events/subscriptions")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<CreateEventSubscription> createEventSubscriptionWithHttpInfo(@Nullable CreateEventSubscription var1);

    @RequestLine(value="PUT /v1/events/subscriptions")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public CreateEventSubscription createOrUpdateEventSubscription(@Nullable CreateEventSubscription var1);

    @RequestLine(value="PUT /v1/events/subscriptions")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<CreateEventSubscription> createOrUpdateEventSubscriptionWithHttpInfo(@Nullable CreateEventSubscription var1);

    @RequestLine(value="DELETE /v1/events/subscriptions/{id}")
    @Headers(value={"Accept: application/json"})
    public EventSubscription deleteEventSubscription(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/events/subscriptions/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscription> deleteEventSubscriptionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/events/subscriptions/async/{id}")
    @Headers(value={"Accept: application/json"})
    public EventSubscription deleteEventSubscriptionAsync(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/events/subscriptions/async/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscription> deleteEventSubscriptionAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="DELETE /v1/events/subscriptions/name/{name}")
    @Headers(value={"Accept: application/json"})
    public void deleteEventSubscriptionByName(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="DELETE /v1/events/subscriptions/name/{name}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteEventSubscriptionByNameWithHttpInfo(@Param(value="name") @Nonnull String var1);

    @RequestLine(value="GET /v1/events/subscriptions/id/{eventSubscriptionId}/destinations")
    @Headers(value={"Accept: application/json"})
    public SubscriptionDestination getAllDestinationForEventSubscription(@Param(value="eventSubscriptionId") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/events/subscriptions/id/{eventSubscriptionId}/destinations")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SubscriptionDestination> getAllDestinationForEventSubscriptionWithHttpInfo(@Param(value="eventSubscriptionId") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}/destinations")
    @Headers(value={"Accept: application/json"})
    public SubscriptionDestination getAllDestinationForEventSubscriptionByName(@Param(value="eventSubscriptionName") @Nonnull String var1);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}/destinations")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SubscriptionDestination> getAllDestinationForEventSubscriptionByNameWithHttpInfo(@Param(value="eventSubscriptionName") @Nonnull String var1);

    @RequestLine(value="GET /v1/events/subscriptions/listAllFailedEvents?limit={limit}&paginationOffset={paginationOffset}&source={source}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent getAllFailedEvents(@Param(value="limit") @Nullable Long var1, @Param(value="paginationOffset") @Nullable Long var2, @Param(value="source") @Nullable String var3);

    @RequestLine(value="GET /v1/events/subscriptions/listAllFailedEvents?limit={limit}&paginationOffset={paginationOffset}&source={source}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> getAllFailedEventsWithHttpInfo(@Param(value="limit") @Nullable Long var1, @Param(value="paginationOffset") @Nullable Long var2, @Param(value="source") @Nullable String var3);

    @RequestLine(value="GET /v1/events/subscriptions/listAllFailedEvents?limit={limit}&paginationOffset={paginationOffset}&source={source}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent getAllFailedEvents(@QueryMap(encoded=true) GetAllFailedEventsQueryParams var1);

    @RequestLine(value="GET /v1/events/subscriptions/listAllFailedEvents?limit={limit}&paginationOffset={paginationOffset}&source={source}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> getAllFailedEventsWithHttpInfo(@QueryMap(encoded=true) GetAllFailedEventsQueryParams var1);

    @RequestLine(value="GET /v1/events/subscriptions/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public EventSubscription getEventSubscriptionByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /v1/events/subscriptions/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscription> getEventSubscriptionByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /v1/events/subscriptions/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public EventSubscription getEventSubscriptionByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetEventSubscriptionByIDQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/{id}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscription> getEventSubscriptionByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetEventSubscriptionByIDQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public EventSubscription getEventSubscriptionByName(@Param(value="eventSubscriptionName") @Nonnull String var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscription> getEventSubscriptionByNameWithHttpInfo(@Param(value="eventSubscriptionName") @Nonnull String var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public EventSubscription getEventSubscriptionByName(@Param(value="eventSubscriptionName") @Nonnull String var1, @QueryMap(encoded=true) GetEventSubscriptionByNameQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscription> getEventSubscriptionByNameWithHttpInfo(@Param(value="eventSubscriptionName") @Nonnull String var1, @QueryMap(encoded=true) GetEventSubscriptionByNameQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/id/{subscriptionId}/diagnosticInfo?limit={limit}&paginationOffset={paginationOffset}&listCountOnly={listCountOnly}")
    @Headers(value={"Accept: application/json"})
    public EventSubscriptionDiagnosticInfo getEventSubscriptionDiagnosticInfoById(@Param(value="subscriptionId") @Nonnull UUID var1, @Param(value="limit") @Nullable Integer var2, @Param(value="paginationOffset") @Nullable Long var3, @Param(value="listCountOnly") @Nullable Boolean var4);

    @RequestLine(value="GET /v1/events/subscriptions/id/{subscriptionId}/diagnosticInfo?limit={limit}&paginationOffset={paginationOffset}&listCountOnly={listCountOnly}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscriptionDiagnosticInfo> getEventSubscriptionDiagnosticInfoByIdWithHttpInfo(@Param(value="subscriptionId") @Nonnull UUID var1, @Param(value="limit") @Nullable Integer var2, @Param(value="paginationOffset") @Nullable Long var3, @Param(value="listCountOnly") @Nullable Boolean var4);

    @RequestLine(value="GET /v1/events/subscriptions/id/{subscriptionId}/diagnosticInfo?limit={limit}&paginationOffset={paginationOffset}&listCountOnly={listCountOnly}")
    @Headers(value={"Accept: application/json"})
    public EventSubscriptionDiagnosticInfo getEventSubscriptionDiagnosticInfoById(@Param(value="subscriptionId") @Nonnull UUID var1, @QueryMap(encoded=true) GetEventSubscriptionDiagnosticInfoByIdQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/id/{subscriptionId}/diagnosticInfo?limit={limit}&paginationOffset={paginationOffset}&listCountOnly={listCountOnly}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscriptionDiagnosticInfo> getEventSubscriptionDiagnosticInfoByIdWithHttpInfo(@Param(value="subscriptionId") @Nonnull UUID var1, @QueryMap(encoded=true) GetEventSubscriptionDiagnosticInfoByIdQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/name/{subscriptionName}/diagnosticInfo?limit={limit}&paginationOffset={paginationOffset}&listCountOnly={listCountOnly}")
    @Headers(value={"Accept: application/json"})
    public EventSubscriptionDiagnosticInfo getEventSubscriptionDiagnosticInfoByName(@Param(value="subscriptionName") @Nonnull String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="paginationOffset") @Nullable Long var3, @Param(value="listCountOnly") @Nullable Boolean var4);

    @RequestLine(value="GET /v1/events/subscriptions/name/{subscriptionName}/diagnosticInfo?limit={limit}&paginationOffset={paginationOffset}&listCountOnly={listCountOnly}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscriptionDiagnosticInfo> getEventSubscriptionDiagnosticInfoByNameWithHttpInfo(@Param(value="subscriptionName") @Nonnull String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="paginationOffset") @Nullable Long var3, @Param(value="listCountOnly") @Nullable Boolean var4);

    @RequestLine(value="GET /v1/events/subscriptions/name/{subscriptionName}/diagnosticInfo?limit={limit}&paginationOffset={paginationOffset}&listCountOnly={listCountOnly}")
    @Headers(value={"Accept: application/json"})
    public EventSubscriptionDiagnosticInfo getEventSubscriptionDiagnosticInfoByName(@Param(value="subscriptionName") @Nonnull String var1, @QueryMap(encoded=true) GetEventSubscriptionDiagnosticInfoByNameQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/name/{subscriptionName}/diagnosticInfo?limit={limit}&paginationOffset={paginationOffset}&listCountOnly={listCountOnly}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscriptionDiagnosticInfo> getEventSubscriptionDiagnosticInfoByNameWithHttpInfo(@Param(value="subscriptionName") @Nonnull String var1, @QueryMap(encoded=true) GetEventSubscriptionDiagnosticInfoByNameQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/id/{subscriptionId}/eventsRecord")
    @Headers(value={"Accept: application/json"})
    public EventsRecord getEventSubscriptionEventsRecordById(@Param(value="subscriptionId") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/events/subscriptions/id/{subscriptionId}/eventsRecord")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventsRecord> getEventSubscriptionEventsRecordByIdWithHttpInfo(@Param(value="subscriptionId") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/events/subscriptions/name/{subscriptionName}/eventsRecord")
    @Headers(value={"Accept: application/json"})
    public EventsRecord getEventSubscriptionEventsRecordByName(@Param(value="subscriptionName") @Nonnull String var1);

    @RequestLine(value="GET /v1/events/subscriptions/name/{subscriptionName}/eventsRecord")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventsRecord> getEventSubscriptionEventsRecordByNameWithHttpInfo(@Param(value="subscriptionName") @Nonnull String var1);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}/status/{destinationId}")
    @Headers(value={"Accept: application/json"})
    public SubscriptionStatus getEventSubscriptionStatus(@Param(value="eventSubscriptionName") @Nonnull String var1, @Param(value="destinationId") @Nonnull UUID var2);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}/status/{destinationId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SubscriptionStatus> getEventSubscriptionStatusWithHttpInfo(@Param(value="eventSubscriptionName") @Nonnull String var1, @Param(value="destinationId") @Nonnull UUID var2);

    @RequestLine(value="GET /v1/events/subscriptions/{eventSubscriptionId}/status/{destinationId}")
    @Headers(value={"Accept: application/json"})
    public SubscriptionStatus getEventSubscriptionStatusById(@Param(value="eventSubscriptionId") @Nonnull UUID var1, @Param(value="destinationId") @Nonnull UUID var2);

    @RequestLine(value="GET /v1/events/subscriptions/{eventSubscriptionId}/status/{destinationId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SubscriptionStatus> getEventSubscriptionStatusByIdWithHttpInfo(@Param(value="eventSubscriptionId") @Nonnull UUID var1, @Param(value="destinationId") @Nonnull UUID var2);

    @RequestLine(value="GET /v1/events/subscriptions/id/{id}/listEvents?status={status}&limit={limit}&paginationOffset={paginationOffset}")
    @Headers(value={"Accept: application/json"})
    public void getEvents(@Param(value="id") @Nonnull UUID var1, @Param(value="status") @Nullable String var2, @Param(value="limit") @Nullable Long var3, @Param(value="paginationOffset") @Nullable Long var4);

    @RequestLine(value="GET /v1/events/subscriptions/id/{id}/listEvents?status={status}&limit={limit}&paginationOffset={paginationOffset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getEventsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="status") @Nullable String var2, @Param(value="limit") @Nullable Long var3, @Param(value="paginationOffset") @Nullable Long var4);

    @RequestLine(value="GET /v1/events/subscriptions/id/{id}/listEvents?status={status}&limit={limit}&paginationOffset={paginationOffset}")
    @Headers(value={"Accept: application/json"})
    public void getEvents(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetEventsQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/id/{id}/listEvents?status={status}&limit={limit}&paginationOffset={paginationOffset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> getEventsWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetEventsQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/id/{id}/failedEvents?limit={limit}&paginationOffset={paginationOffset}&source={source}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent getFailedEventsBySubscriptionId(@Param(value="id") @Nonnull UUID var1, @Param(value="limit") @Nullable Long var2, @Param(value="paginationOffset") @Nullable Long var3, @Param(value="source") @Nullable String var4);

    @RequestLine(value="GET /v1/events/subscriptions/id/{id}/failedEvents?limit={limit}&paginationOffset={paginationOffset}&source={source}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> getFailedEventsBySubscriptionIdWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="limit") @Nullable Long var2, @Param(value="paginationOffset") @Nullable Long var3, @Param(value="source") @Nullable String var4);

    @RequestLine(value="GET /v1/events/subscriptions/id/{id}/failedEvents?limit={limit}&paginationOffset={paginationOffset}&source={source}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent getFailedEventsBySubscriptionId(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetFailedEventsBySubscriptionIdQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/id/{id}/failedEvents?limit={limit}&paginationOffset={paginationOffset}&source={source}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> getFailedEventsBySubscriptionIdWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetFailedEventsBySubscriptionIdQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}/failedEvents?limit={limit}&paginationOffset={paginationOffset}&source={source}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent getFailedEventsBySubscriptionName(@Param(value="eventSubscriptionName") @Nonnull String var1, @Param(value="limit") @Nullable Long var2, @Param(value="paginationOffset") @Nullable Long var3, @Param(value="source") @Nullable String var4);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}/failedEvents?limit={limit}&paginationOffset={paginationOffset}&source={source}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> getFailedEventsBySubscriptionNameWithHttpInfo(@Param(value="eventSubscriptionName") @Nonnull String var1, @Param(value="limit") @Nullable Long var2, @Param(value="paginationOffset") @Nullable Long var3, @Param(value="source") @Nullable String var4);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}/failedEvents?limit={limit}&paginationOffset={paginationOffset}&source={source}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent getFailedEventsBySubscriptionName(@Param(value="eventSubscriptionName") @Nonnull String var1, @QueryMap(encoded=true) GetFailedEventsBySubscriptionNameQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}/failedEvents?limit={limit}&paginationOffset={paginationOffset}&source={source}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> getFailedEventsBySubscriptionNameWithHttpInfo(@Param(value="eventSubscriptionName") @Nonnull String var1, @QueryMap(encoded=true) GetFailedEventsBySubscriptionNameQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public EventSubscription getSpecificEventSubscriptionVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/events/subscriptions/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscription> getSpecificEventSubscriptionVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/events/subscriptions/id/{id}/listSuccessfullySentChangeEvents?limit={limit}&paginationOffset={paginationOffset}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent getSuccessfullySentChangeEventsForAlert(@Param(value="id") @Nonnull UUID var1, @Param(value="limit") @Nullable Long var2, @Param(value="paginationOffset") @Nullable Long var3);

    @RequestLine(value="GET /v1/events/subscriptions/id/{id}/listSuccessfullySentChangeEvents?limit={limit}&paginationOffset={paginationOffset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> getSuccessfullySentChangeEventsForAlertWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="limit") @Nullable Long var2, @Param(value="paginationOffset") @Nullable Long var3);

    @RequestLine(value="GET /v1/events/subscriptions/id/{id}/listSuccessfullySentChangeEvents?limit={limit}&paginationOffset={paginationOffset}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent getSuccessfullySentChangeEventsForAlert(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetSuccessfullySentChangeEventsForAlertQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/id/{id}/listSuccessfullySentChangeEvents?limit={limit}&paginationOffset={paginationOffset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> getSuccessfullySentChangeEventsForAlertWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetSuccessfullySentChangeEventsForAlertQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}/listSuccessfullySentChangeEvents?limit={limit}&paginationOffset={paginationOffset}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent getSuccessfullySentChangeEventsForAlertByName(@Param(value="eventSubscriptionName") @Nonnull String var1, @Param(value="limit") @Nullable Long var2, @Param(value="paginationOffset") @Nullable Long var3);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}/listSuccessfullySentChangeEvents?limit={limit}&paginationOffset={paginationOffset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> getSuccessfullySentChangeEventsForAlertByNameWithHttpInfo(@Param(value="eventSubscriptionName") @Nonnull String var1, @Param(value="limit") @Nullable Long var2, @Param(value="paginationOffset") @Nullable Long var3);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}/listSuccessfullySentChangeEvents?limit={limit}&paginationOffset={paginationOffset}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent getSuccessfullySentChangeEventsForAlertByName(@Param(value="eventSubscriptionName") @Nonnull String var1, @QueryMap(encoded=true) GetSuccessfullySentChangeEventsForAlertByNameQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/name/{eventSubscriptionName}/listSuccessfullySentChangeEvents?limit={limit}&paginationOffset={paginationOffset}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> getSuccessfullySentChangeEventsForAlertByNameWithHttpInfo(@Param(value="eventSubscriptionName") @Nonnull String var1, @QueryMap(encoded=true) GetSuccessfullySentChangeEventsForAlertByNameQueryParams var2);

    @RequestLine(value="GET /v1/events/subscriptions/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllEventSubscriptionVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/events/subscriptions/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllEventSubscriptionVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/events?entityCreated={entityCreated}&entityUpdated={entityUpdated}&entityRestored={entityRestored}&entityDeleted={entityDeleted}&timestamp={timestamp}")
    @Headers(value={"Accept: application/json"})
    public EventList listChangeEvents(@Param(value="timestamp") @Nonnull Long var1, @Param(value="entityCreated") @Nullable String var2, @Param(value="entityUpdated") @Nullable String var3, @Param(value="entityRestored") @Nullable String var4, @Param(value="entityDeleted") @Nullable String var5);

    @RequestLine(value="GET /v1/events?entityCreated={entityCreated}&entityUpdated={entityUpdated}&entityRestored={entityRestored}&entityDeleted={entityDeleted}&timestamp={timestamp}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventList> listChangeEventsWithHttpInfo(@Param(value="timestamp") @Nonnull Long var1, @Param(value="entityCreated") @Nullable String var2, @Param(value="entityUpdated") @Nullable String var3, @Param(value="entityRestored") @Nullable String var4, @Param(value="entityDeleted") @Nullable String var5);

    @RequestLine(value="GET /v1/events?entityCreated={entityCreated}&entityUpdated={entityUpdated}&entityRestored={entityRestored}&entityDeleted={entityDeleted}&timestamp={timestamp}")
    @Headers(value={"Accept: application/json"})
    public EventList listChangeEvents(@QueryMap(encoded=true) ListChangeEventsQueryParams var1);

    @RequestLine(value="GET /v1/events?entityCreated={entityCreated}&entityUpdated={entityUpdated}&entityRestored={entityRestored}&entityDeleted={entityDeleted}&timestamp={timestamp}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventList> listChangeEventsWithHttpInfo(@QueryMap(encoded=true) ListChangeEventsQueryParams var1);

    @RequestLine(value="GET /v1/events/subscriptions/{alertType}/resources")
    @Headers(value={"Accept: application/json"})
    public ResultListFilterResourceDescriptor listEventSubscriptionResources(@Param(value="alertType") @Nonnull String var1);

    @RequestLine(value="GET /v1/events/subscriptions/{alertType}/resources")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ResultListFilterResourceDescriptor> listEventSubscriptionResourcesWithHttpInfo(@Param(value="alertType") @Nonnull String var1);

    @RequestLine(value="GET /v1/events/subscriptions?fields={fields}&limit={limit}&alertType={alertType}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public EventSubscriptionList listEventSubscriptions(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="alertType") @Nullable String var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5);

    @RequestLine(value="GET /v1/events/subscriptions?fields={fields}&limit={limit}&alertType={alertType}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscriptionList> listEventSubscriptionsWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="alertType") @Nullable String var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5);

    @RequestLine(value="GET /v1/events/subscriptions?fields={fields}&limit={limit}&alertType={alertType}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public EventSubscriptionList listEventSubscriptions(@QueryMap(encoded=true) ListEventSubscriptionsQueryParams var1);

    @RequestLine(value="GET /v1/events/subscriptions?fields={fields}&limit={limit}&alertType={alertType}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EventSubscriptionList> listEventSubscriptionsWithHttpInfo(@QueryMap(encoded=true) ListEventSubscriptionsQueryParams var1);

    @RequestLine(value="PATCH /v1/events/subscriptions/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchEventSubscription(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/events/subscriptions/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchEventSubscriptionWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/events/subscriptions/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchEventSubscription1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/events/subscriptions/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchEventSubscription1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/events/subscriptions/name/{eventSubscriptionName}/syncOffset")
    @Headers(value={"Accept: application/json"})
    public SubscriptionDestination syncOffsetForEventSubscriptionByName(@Param(value="eventSubscriptionName") @Nonnull String var1);

    @RequestLine(value="PUT /v1/events/subscriptions/name/{eventSubscriptionName}/syncOffset")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<SubscriptionDestination> syncOffsetForEventSubscriptionByNameWithHttpInfo(@Param(value="eventSubscriptionName") @Nonnull String var1);

    @RequestLine(value="POST /v1/events/subscriptions/testDestination")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Response testDestination(@Nullable EventSubscriptionDestinationTestRequest var1);

    @RequestLine(value="POST /v1/events/subscriptions/testDestination")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Response> testDestinationWithHttpInfo(@Nullable EventSubscriptionDestinationTestRequest var1);

    public static class ListEventSubscriptionsQueryParams
    extends HashMap<String, Object> {
        public ListEventSubscriptionsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListEventSubscriptionsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListEventSubscriptionsQueryParams alertType(@Nullable String value) {
            this.put("alertType", EncodingUtils.encode(value));
            return this;
        }

        public ListEventSubscriptionsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListEventSubscriptionsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListChangeEventsQueryParams
    extends HashMap<String, Object> {
        public ListChangeEventsQueryParams entityCreated(@Nullable String value) {
            this.put("entityCreated", EncodingUtils.encode(value));
            return this;
        }

        public ListChangeEventsQueryParams entityUpdated(@Nullable String value) {
            this.put("entityUpdated", EncodingUtils.encode(value));
            return this;
        }

        public ListChangeEventsQueryParams entityRestored(@Nullable String value) {
            this.put("entityRestored", EncodingUtils.encode(value));
            return this;
        }

        public ListChangeEventsQueryParams entityDeleted(@Nullable String value) {
            this.put("entityDeleted", EncodingUtils.encode(value));
            return this;
        }

        public ListChangeEventsQueryParams timestamp(@Nonnull Long value) {
            this.put("timestamp", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetSuccessfullySentChangeEventsForAlertByNameQueryParams
    extends HashMap<String, Object> {
        public GetSuccessfullySentChangeEventsForAlertByNameQueryParams limit(@Nullable Long value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public GetSuccessfullySentChangeEventsForAlertByNameQueryParams paginationOffset(@Nullable Long value) {
            this.put("paginationOffset", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetSuccessfullySentChangeEventsForAlertQueryParams
    extends HashMap<String, Object> {
        public GetSuccessfullySentChangeEventsForAlertQueryParams limit(@Nullable Long value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public GetSuccessfullySentChangeEventsForAlertQueryParams paginationOffset(@Nullable Long value) {
            this.put("paginationOffset", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetFailedEventsBySubscriptionNameQueryParams
    extends HashMap<String, Object> {
        public GetFailedEventsBySubscriptionNameQueryParams limit(@Nullable Long value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public GetFailedEventsBySubscriptionNameQueryParams paginationOffset(@Nullable Long value) {
            this.put("paginationOffset", EncodingUtils.encode(value));
            return this;
        }

        public GetFailedEventsBySubscriptionNameQueryParams source(@Nullable String value) {
            this.put("source", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetFailedEventsBySubscriptionIdQueryParams
    extends HashMap<String, Object> {
        public GetFailedEventsBySubscriptionIdQueryParams limit(@Nullable Long value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public GetFailedEventsBySubscriptionIdQueryParams paginationOffset(@Nullable Long value) {
            this.put("paginationOffset", EncodingUtils.encode(value));
            return this;
        }

        public GetFailedEventsBySubscriptionIdQueryParams source(@Nullable String value) {
            this.put("source", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetEventsQueryParams
    extends HashMap<String, Object> {
        public GetEventsQueryParams status(@Nullable String value) {
            this.put("status", EncodingUtils.encode(value));
            return this;
        }

        public GetEventsQueryParams limit(@Nullable Long value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public GetEventsQueryParams paginationOffset(@Nullable Long value) {
            this.put("paginationOffset", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetEventSubscriptionDiagnosticInfoByNameQueryParams
    extends HashMap<String, Object> {
        public GetEventSubscriptionDiagnosticInfoByNameQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public GetEventSubscriptionDiagnosticInfoByNameQueryParams paginationOffset(@Nullable Long value) {
            this.put("paginationOffset", EncodingUtils.encode(value));
            return this;
        }

        public GetEventSubscriptionDiagnosticInfoByNameQueryParams listCountOnly(@Nullable Boolean value) {
            this.put("listCountOnly", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetEventSubscriptionDiagnosticInfoByIdQueryParams
    extends HashMap<String, Object> {
        public GetEventSubscriptionDiagnosticInfoByIdQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public GetEventSubscriptionDiagnosticInfoByIdQueryParams paginationOffset(@Nullable Long value) {
            this.put("paginationOffset", EncodingUtils.encode(value));
            return this;
        }

        public GetEventSubscriptionDiagnosticInfoByIdQueryParams listCountOnly(@Nullable Boolean value) {
            this.put("listCountOnly", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetEventSubscriptionByNameQueryParams
    extends HashMap<String, Object> {
        public GetEventSubscriptionByNameQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetEventSubscriptionByIDQueryParams
    extends HashMap<String, Object> {
        public GetEventSubscriptionByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetAllFailedEventsQueryParams
    extends HashMap<String, Object> {
        public GetAllFailedEventsQueryParams limit(@Nullable Long value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public GetAllFailedEventsQueryParams paginationOffset(@Nullable Long value) {
            this.put("paginationOffset", EncodingUtils.encode(value));
            return this;
        }

        public GetAllFailedEventsQueryParams source(@Nullable String value) {
            this.put("source", EncodingUtils.encode(value));
            return this;
        }
    }
}

