/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.CloseTask;
import org.openmetadata.client.model.CreatePost;
import org.openmetadata.client.model.CreateThread;
import org.openmetadata.client.model.PostList;
import org.openmetadata.client.model.ResolveTask;
import org.openmetadata.client.model.Thread;
import org.openmetadata.client.model.ThreadCountList;
import org.openmetadata.client.model.ThreadList;

public interface FeedsApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/feed/{id}/posts")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Thread addPostToThread(@Param(value="id") @Nonnull String var1, @Nullable CreatePost var2);

    @RequestLine(value="POST /v1/feed/{id}/posts")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Thread> addPostToThreadWithHttpInfo(@Param(value="id") @Nonnull String var1, @Nullable CreatePost var2);

    @RequestLine(value="PUT /v1/feed/tasks/{id}/close")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Thread closeTask(@Param(value="id") @Nonnull String var1, @Nullable CloseTask var2);

    @RequestLine(value="PUT /v1/feed/tasks/{id}/close")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Thread> closeTaskWithHttpInfo(@Param(value="id") @Nonnull String var1, @Nullable CloseTask var2);

    @RequestLine(value="GET /v1/feed/count?entityLink={entityLink}")
    @Headers(value={"Accept: application/json"})
    public ThreadCountList countThreads(@Param(value="entityLink") @Nullable String var1);

    @RequestLine(value="GET /v1/feed/count?entityLink={entityLink}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ThreadCountList> countThreadsWithHttpInfo(@Param(value="entityLink") @Nullable String var1);

    @RequestLine(value="GET /v1/feed/count?entityLink={entityLink}")
    @Headers(value={"Accept: application/json"})
    public ThreadCountList countThreads(@QueryMap(encoded=true) CountThreadsQueryParams var1);

    @RequestLine(value="GET /v1/feed/count?entityLink={entityLink}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ThreadCountList> countThreadsWithHttpInfo(@QueryMap(encoded=true) CountThreadsQueryParams var1);

    @RequestLine(value="POST /v1/feed")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Thread createThread(@Nullable CreateThread var1);

    @RequestLine(value="POST /v1/feed")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Thread> createThreadWithHttpInfo(@Nullable CreateThread var1);

    @RequestLine(value="DELETE /v1/feed/{threadId}/posts/{postId}")
    @Headers(value={"Accept: application/json"})
    public void deletePostFromThread(@Param(value="threadId") @Nonnull String var1, @Param(value="postId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/feed/{threadId}/posts/{postId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deletePostFromThreadWithHttpInfo(@Param(value="threadId") @Nonnull String var1, @Param(value="postId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/feed/{threadId}")
    @Headers(value={"Accept: application/json"})
    public void deleteThread(@Param(value="threadId") @Nonnull String var1);

    @RequestLine(value="DELETE /v1/feed/{threadId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteThreadWithHttpInfo(@Param(value="threadId") @Nonnull String var1);

    @RequestLine(value="GET /v1/feed/{id}/posts")
    @Headers(value={"Accept: application/json"})
    public PostList getAllPostOfThread(@Param(value="id") @Nonnull String var1);

    @RequestLine(value="GET /v1/feed/{id}/posts")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PostList> getAllPostOfThreadWithHttpInfo(@Param(value="id") @Nonnull String var1);

    @RequestLine(value="GET /v1/feed/tasks/{id}")
    @Headers(value={"Accept: application/json"})
    public Thread getTaskByID(@Param(value="id") @Nonnull String var1);

    @RequestLine(value="GET /v1/feed/tasks/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Thread> getTaskByIDWithHttpInfo(@Param(value="id") @Nonnull String var1);

    @RequestLine(value="GET /v1/feed/{id}")
    @Headers(value={"Accept: application/json"})
    public Thread getThreadByID(@Param(value="id") @Nonnull String var1, @Param(value="entityType") @Nonnull String var2);

    @RequestLine(value="GET /v1/feed/{id}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Thread> getThreadByIDWithHttpInfo(@Param(value="id") @Nonnull String var1, @Param(value="entityType") @Nonnull String var2);

    @RequestLine(value="GET /v1/feed?limitPosts={limitPosts}&limit={limit}&before={before}&after={after}&entityLink={entityLink}&userId={userId}&filterType={filterType}&resolved={resolved}&type={type}&taskStatus={taskStatus}&activeAnnouncement={activeAnnouncement}")
    @Headers(value={"Accept: application/json"})
    public ThreadList listThreads(@Param(value="limitPosts") @Nullable Long var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4, @Param(value="entityLink") @Nullable String var5, @Param(value="userId") @Nullable String var6, @Param(value="filterType") @Nullable String var7, @Param(value="resolved") @Nullable Boolean var8, @Param(value="type") @Nullable String var9, @Param(value="taskStatus") @Nullable String var10, @Param(value="activeAnnouncement") @Nullable Boolean var11);

    @RequestLine(value="GET /v1/feed?limitPosts={limitPosts}&limit={limit}&before={before}&after={after}&entityLink={entityLink}&userId={userId}&filterType={filterType}&resolved={resolved}&type={type}&taskStatus={taskStatus}&activeAnnouncement={activeAnnouncement}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ThreadList> listThreadsWithHttpInfo(@Param(value="limitPosts") @Nullable Long var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4, @Param(value="entityLink") @Nullable String var5, @Param(value="userId") @Nullable String var6, @Param(value="filterType") @Nullable String var7, @Param(value="resolved") @Nullable Boolean var8, @Param(value="type") @Nullable String var9, @Param(value="taskStatus") @Nullable String var10, @Param(value="activeAnnouncement") @Nullable Boolean var11);

    @RequestLine(value="GET /v1/feed?limitPosts={limitPosts}&limit={limit}&before={before}&after={after}&entityLink={entityLink}&userId={userId}&filterType={filterType}&resolved={resolved}&type={type}&taskStatus={taskStatus}&activeAnnouncement={activeAnnouncement}")
    @Headers(value={"Accept: application/json"})
    public ThreadList listThreads(@QueryMap(encoded=true) ListThreadsQueryParams var1);

    @RequestLine(value="GET /v1/feed?limitPosts={limitPosts}&limit={limit}&before={before}&after={after}&entityLink={entityLink}&userId={userId}&filterType={filterType}&resolved={resolved}&type={type}&taskStatus={taskStatus}&activeAnnouncement={activeAnnouncement}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ThreadList> listThreadsWithHttpInfo(@QueryMap(encoded=true) ListThreadsQueryParams var1);

    @RequestLine(value="PATCH /v1/feed/{threadId}/posts/{postId}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchPostOfThread(@Param(value="threadId") @Nonnull String var1, @Param(value="postId") @Nonnull String var2, @Nullable Object var3);

    @RequestLine(value="PATCH /v1/feed/{threadId}/posts/{postId}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchPostOfThreadWithHttpInfo(@Param(value="threadId") @Nonnull String var1, @Param(value="postId") @Nonnull String var2, @Nullable Object var3);

    @RequestLine(value="PATCH /v1/feed/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchThread(@Param(value="id") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/feed/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchThreadWithHttpInfo(@Param(value="id") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/feed/tasks/{id}/resolve")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Thread resolveTask(@Param(value="id") @Nonnull String var1, @Nullable ResolveTask var2);

    @RequestLine(value="PUT /v1/feed/tasks/{id}/resolve")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Thread> resolveTaskWithHttpInfo(@Param(value="id") @Nonnull String var1, @Nullable ResolveTask var2);

    public static class ListThreadsQueryParams
    extends HashMap<String, Object> {
        public ListThreadsQueryParams limitPosts(@Nullable Long value) {
            this.put("limitPosts", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams entityLink(@Nullable String value) {
            this.put("entityLink", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams userId(@Nullable String value) {
            this.put("userId", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams filterType(@Nullable String value) {
            this.put("filterType", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams resolved(@Nullable Boolean value) {
            this.put("resolved", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams type(@Nullable String value) {
            this.put("type", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams taskStatus(@Nullable String value) {
            this.put("taskStatus", EncodingUtils.encode(value));
            return this;
        }

        public ListThreadsQueryParams activeAnnouncement(@Nullable Boolean value) {
            this.put("activeAnnouncement", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class CountThreadsQueryParams
    extends HashMap<String, Object> {
        public CountThreadsQueryParams entityLink(@Nullable String value) {
            this.put("entityLink", EncodingUtils.encode(value));
            return this;
        }
    }
}

