/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateMetadataService;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.MetadataService;
import org.openmetadata.client.model.MetadataServiceList;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestConnectionResult;

public interface MetadataServicesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/metadataServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToMetadataService(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/metadataServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToMetadataServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/metadataServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MetadataService addTestConnectionResult5(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/metadataServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MetadataService> addTestConnectionResult5WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="POST /v1/services/metadataServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MetadataService createMetadataService(@Nullable CreateMetadataService var1);

    @RequestLine(value="POST /v1/services/metadataServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MetadataService> createMetadataServiceWithHttpInfo(@Nullable CreateMetadataService var1);

    @RequestLine(value="PUT /v1/services/metadataServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MetadataService createOrUpdateMetadataService(@Nullable CreateMetadataService var1);

    @RequestLine(value="PUT /v1/services/metadataServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MetadataService> createOrUpdateMetadataServiceWithHttpInfo(@Nullable CreateMetadataService var1);

    @RequestLine(value="DELETE /v1/services/metadataServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower15(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/services/metadataServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower15WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/services/metadataServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMetadataService(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/metadataServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMetadataServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/metadataServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMetadataService(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMetadataServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/metadataServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMetadataServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMetadataServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/metadataServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMetadataServiceAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/metadataServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMetadataServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/metadataServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMetadataServiceAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMetadataServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/metadataServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMetadataServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMetadataServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/metadataServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteMetadataServiceByName(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/metadataServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMetadataServiceByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2, @Param(value="recursive") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/metadataServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public void deleteMetadataServiceByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteMetadataServiceByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/services/metadataServices/name/{name}?hardDelete={hardDelete}&recursive={recursive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMetadataServiceByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteMetadataServiceByNameQueryParams var2);

    @RequestLine(value="GET /v1/services/metadataServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MetadataService getMetadataServiceByFQN(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/metadataServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MetadataService> getMetadataServiceByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/metadataServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MetadataService getMetadataServiceByFQN(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetMetadataServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/metadataServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MetadataService> getMetadataServiceByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetMetadataServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/metadataServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MetadataService getMetadataServiceByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/metadataServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MetadataService> getMetadataServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/metadataServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MetadataService getMetadataServiceByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetMetadataServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/metadataServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MetadataService> getMetadataServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetMetadataServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/metadataServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public MetadataService getSpecificMetadataServiceVersion(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/metadataServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MetadataService> getSpecificMetadataServiceVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/metadataServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllMetadataServiceVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/metadataServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllMetadataServiceVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/metadataServices?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MetadataServiceList listMetadataServices(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4, @Param(value="include") @Nullable String var5);

    @RequestLine(value="GET /v1/services/metadataServices?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MetadataServiceList> listMetadataServicesWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4, @Param(value="include") @Nullable String var5);

    @RequestLine(value="GET /v1/services/metadataServices?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MetadataServiceList listMetadataServices(@QueryMap(encoded=true) ListMetadataServicesQueryParams var1);

    @RequestLine(value="GET /v1/services/metadataServices?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MetadataServiceList> listMetadataServicesWithHttpInfo(@QueryMap(encoded=true) ListMetadataServicesQueryParams var1);

    @RequestLine(value="PATCH /v1/services/metadataServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchMetadataService(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/metadataServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchMetadataServiceWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/metadataServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchMetadataService1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/metadataServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchMetadataService1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/services/metadataServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MetadataService restore31(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/metadataServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MetadataService> restore31WithHttpInfo(@Nullable RestoreEntity var1);

    public static class ListMetadataServicesQueryParams
    extends HashMap<String, Object> {
        public ListMetadataServicesQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListMetadataServicesQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListMetadataServicesQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListMetadataServicesQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListMetadataServicesQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetMetadataServiceByIDQueryParams
    extends HashMap<String, Object> {
        public GetMetadataServiceByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetMetadataServiceByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetMetadataServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public GetMetadataServiceByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetMetadataServiceByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMetadataServiceByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteMetadataServiceByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }

        public DeleteMetadataServiceByNameQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMetadataServiceAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteMetadataServiceAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteMetadataServiceAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMetadataServiceQueryParams
    extends HashMap<String, Object> {
        public DeleteMetadataServiceQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteMetadataServiceQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

