/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateMetric;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.Metric;
import org.openmetadata.client.model.MetricsList;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.VoteRequest;

public interface MetricsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/metrics/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower2(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="PUT /v1/metrics/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollower2WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable UUID var2);

    @RequestLine(value="POST /v1/metrics")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Metric createMetric(@Nullable CreateMetric var1);

    @RequestLine(value="POST /v1/metrics")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Metric> createMetricWithHttpInfo(@Nullable CreateMetric var1);

    @RequestLine(value="PUT /v1/metrics")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Metric createOrUpdateMetric(@Nullable CreateMetric var1);

    @RequestLine(value="PUT /v1/metrics")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Metric> createOrUpdateMetricWithHttpInfo(@Nullable CreateMetric var1);

    @RequestLine(value="DELETE /v1/metrics/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPIEndpointByFQN1(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/metrics/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPIEndpointByFQN1WithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/metrics/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteAPIEndpointByFQN1(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteAPIEndpointByFQN1QueryParams var2);

    @RequestLine(value="DELETE /v1/metrics/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteAPIEndpointByFQN1WithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) DeleteAPIEndpointByFQN1QueryParams var2);

    @RequestLine(value="DELETE /v1/metrics/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower5(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/metrics/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower5WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/metrics/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMetric(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/metrics/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMetricWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/metrics/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMetric(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMetricQueryParams var2);

    @RequestLine(value="DELETE /v1/metrics/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMetricWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMetricQueryParams var2);

    @RequestLine(value="DELETE /v1/metrics/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMetricAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/metrics/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMetricAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="hardDelete") @Nullable Boolean var2);

    @RequestLine(value="DELETE /v1/metrics/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMetricAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMetricAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/metrics/async/{id}?hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMetricAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMetricAsyncQueryParams var2);

    @RequestLine(value="GET /v1/metrics/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Metric getMetricByFQN(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/metrics/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Metric> getMetricByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/metrics/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Metric getMetricByFQN(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetMetricByFQNQueryParams var2);

    @RequestLine(value="GET /v1/metrics/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Metric> getMetricByFQNWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @QueryMap(encoded=true) GetMetricByFQNQueryParams var2);

    @RequestLine(value="GET /v1/metrics/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Metric getMetricByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/metrics/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Metric> getMetricByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/metrics/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Metric getMetricByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetMetricByIDQueryParams var2);

    @RequestLine(value="GET /v1/metrics/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Metric> getMetricByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetMetricByIDQueryParams var2);

    @RequestLine(value="GET /v1/metrics/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Metric getSpecificEndpointVersion1(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/metrics/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Metric> getSpecificEndpointVersion1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/metrics/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllMetricVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/metrics/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllMetricVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/metrics?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MetricsList listMetrics(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4, @Param(value="include") @Nullable String var5);

    @RequestLine(value="GET /v1/metrics?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MetricsList> listMetricsWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="limit") @Nullable Integer var2, @Param(value="before") @Nullable String var3, @Param(value="after") @Nullable String var4, @Param(value="include") @Nullable String var5);

    @RequestLine(value="GET /v1/metrics?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MetricsList listMetrics(@QueryMap(encoded=true) ListMetricsQueryParams var1);

    @RequestLine(value="GET /v1/metrics?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MetricsList> listMetricsWithHttpInfo(@QueryMap(encoded=true) ListMetricsQueryParams var1);

    @RequestLine(value="PATCH /v1/metrics/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchMetric(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/metrics/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchMetricWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/metrics/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchMetric1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/metrics/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchMetric1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/metrics/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Metric restore19(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/metrics/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Metric> restore19WithHttpInfo(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/metrics/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent updateVoteForMetric(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    @RequestLine(value="PUT /v1/metrics/{id}/vote")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> updateVoteForMetricWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable VoteRequest var2);

    public static class ListMetricsQueryParams
    extends HashMap<String, Object> {
        public ListMetricsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListMetricsQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListMetricsQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListMetricsQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListMetricsQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetMetricByIDQueryParams
    extends HashMap<String, Object> {
        public GetMetricByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetMetricByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetMetricByFQNQueryParams
    extends HashMap<String, Object> {
        public GetMetricByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetMetricByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMetricAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteMetricAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMetricQueryParams
    extends HashMap<String, Object> {
        public DeleteMetricQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteAPIEndpointByFQN1QueryParams
    extends HashMap<String, Object> {
        public DeleteAPIEndpointByFQN1QueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

