/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openmetadata.client.ApiClient;
import org.openmetadata.client.EncodingUtils;
import org.openmetadata.client.model.ApiResponse;
import org.openmetadata.client.model.ChangeEvent;
import org.openmetadata.client.model.CreateMlModelService;
import org.openmetadata.client.model.EntityHistory;
import org.openmetadata.client.model.MlModelService;
import org.openmetadata.client.model.MlModelServiceList;
import org.openmetadata.client.model.RestoreEntity;
import org.openmetadata.client.model.TestConnectionResult;

public interface MlModelServicesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/services/mlmodelServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToMlModelService(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/mlmodelServices/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ChangeEvent> addFollowerToMlModelServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable String var2);

    @RequestLine(value="PUT /v1/services/mlmodelServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MlModelService addTestConnectionResult6(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="PUT /v1/services/mlmodelServices/{id}/testConnectionResult")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MlModelService> addTestConnectionResult6WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable TestConnectionResult var2);

    @RequestLine(value="POST /v1/services/mlmodelServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MlModelService createMlModelService(@Nullable CreateMlModelService var1);

    @RequestLine(value="POST /v1/services/mlmodelServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MlModelService> createMlModelServiceWithHttpInfo(@Nullable CreateMlModelService var1);

    @RequestLine(value="PUT /v1/services/mlmodelServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MlModelService createOrUpdateMlModelService(@Nullable CreateMlModelService var1);

    @RequestLine(value="PUT /v1/services/mlmodelServices")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MlModelService> createOrUpdateMlModelServiceWithHttpInfo(@Nullable CreateMlModelService var1);

    @RequestLine(value="DELETE /v1/services/mlmodelServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ChangeEvent deleteFollower16(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/services/mlmodelServices/{id}/followers/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ChangeEvent> deleteFollower16WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="userId") @Nonnull String var2);

    @RequestLine(value="DELETE /v1/services/mlmodelServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMlModelService(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/mlmodelServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMlModelServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/mlmodelServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMlModelService(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMlModelServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/mlmodelServices/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMlModelServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMlModelServiceQueryParams var2);

    @RequestLine(value="DELETE /v1/services/mlmodelServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMlModelServiceAsync(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/mlmodelServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMlModelServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/mlmodelServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMlModelServiceAsync(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMlModelServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/mlmodelServices/async/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMlModelServiceAsyncWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) DeleteMlModelServiceAsyncQueryParams var2);

    @RequestLine(value="DELETE /v1/services/mlmodelServices/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMlModelServiceByName(@Param(value="name") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/mlmodelServices/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMlModelServiceByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="recursive") @Nullable Boolean var2, @Param(value="hardDelete") @Nullable Boolean var3);

    @RequestLine(value="DELETE /v1/services/mlmodelServices/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public void deleteMlModelServiceByName(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteMlModelServiceByNameQueryParams var2);

    @RequestLine(value="DELETE /v1/services/mlmodelServices/name/{name}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteMlModelServiceByNameWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) DeleteMlModelServiceByNameQueryParams var2);

    @RequestLine(value="GET /v1/services/mlmodelServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MlModelService getMlModelServiceByFQN(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/mlmodelServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModelService> getMlModelServiceByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/mlmodelServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MlModelService getMlModelServiceByFQN(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetMlModelServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/mlmodelServices/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModelService> getMlModelServiceByFQNWithHttpInfo(@Param(value="name") @Nonnull String var1, @QueryMap(encoded=true) GetMlModelServiceByFQNQueryParams var2);

    @RequestLine(value="GET /v1/services/mlmodelServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MlModelService getMlModelServiceByID(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/mlmodelServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModelService> getMlModelServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="fields") @Nullable String var2, @Param(value="include") @Nullable String var3);

    @RequestLine(value="GET /v1/services/mlmodelServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MlModelService getMlModelServiceByID(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetMlModelServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/mlmodelServices/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModelService> getMlModelServiceByIDWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @QueryMap(encoded=true) GetMlModelServiceByIDQueryParams var2);

    @RequestLine(value="GET /v1/services/mlmodelServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public MlModelService getSpecificMlModelService(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/mlmodelServices/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModelService> getSpecificMlModelServiceWithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Param(value="version") @Nonnull String var2);

    @RequestLine(value="GET /v1/services/mlmodelServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllMlModelServiceVersion(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/mlmodelServices/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<EntityHistory> listAllMlModelServiceVersionWithHttpInfo(@Param(value="id") @Nonnull UUID var1);

    @RequestLine(value="GET /v1/services/mlmodelServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MlModelServiceList listMlModelService(@Param(value="fields") @Nullable String var1, @Param(value="domain") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/services/mlmodelServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModelServiceList> listMlModelServiceWithHttpInfo(@Param(value="fields") @Nullable String var1, @Param(value="domain") @Nullable String var2, @Param(value="limit") @Nullable Integer var3, @Param(value="before") @Nullable String var4, @Param(value="after") @Nullable String var5, @Param(value="include") @Nullable String var6);

    @RequestLine(value="GET /v1/services/mlmodelServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public MlModelServiceList listMlModelService(@QueryMap(encoded=true) ListMlModelServiceQueryParams var1);

    @RequestLine(value="GET /v1/services/mlmodelServices?fields={fields}&domain={domain}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MlModelServiceList> listMlModelServiceWithHttpInfo(@QueryMap(encoded=true) ListMlModelServiceQueryParams var1);

    @RequestLine(value="PATCH /v1/services/mlmodelServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchMlModelService(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/mlmodelServices/name/{fqn}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchMlModelServiceWithHttpInfo(@Param(value="fqn") @Nonnull String var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/mlmodelServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchMlModelService1(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PATCH /v1/services/mlmodelServices/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public ApiResponse<Void> patchMlModelService1WithHttpInfo(@Param(value="id") @Nonnull UUID var1, @Nullable Object var2);

    @RequestLine(value="PUT /v1/services/mlmodelServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public MlModelService restore32(@Nullable RestoreEntity var1);

    @RequestLine(value="PUT /v1/services/mlmodelServices/restore")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<MlModelService> restore32WithHttpInfo(@Nullable RestoreEntity var1);

    public static class ListMlModelServiceQueryParams
    extends HashMap<String, Object> {
        public ListMlModelServiceQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListMlModelServiceQueryParams domain(@Nullable String value) {
            this.put("domain", EncodingUtils.encode(value));
            return this;
        }

        public ListMlModelServiceQueryParams limit(@Nullable Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListMlModelServiceQueryParams before(@Nullable String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListMlModelServiceQueryParams after(@Nullable String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListMlModelServiceQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetMlModelServiceByIDQueryParams
    extends HashMap<String, Object> {
        public GetMlModelServiceByIDQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetMlModelServiceByIDQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetMlModelServiceByFQNQueryParams
    extends HashMap<String, Object> {
        public GetMlModelServiceByFQNQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetMlModelServiceByFQNQueryParams include(@Nullable String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMlModelServiceByNameQueryParams
    extends HashMap<String, Object> {
        public DeleteMlModelServiceByNameQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteMlModelServiceByNameQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMlModelServiceAsyncQueryParams
    extends HashMap<String, Object> {
        public DeleteMlModelServiceAsyncQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteMlModelServiceAsyncQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteMlModelServiceQueryParams
    extends HashMap<String, Object> {
        public DeleteMlModelServiceQueryParams recursive(@Nullable Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteMlModelServiceQueryParams hardDelete(@Nullable Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

